/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.client.render.equipment;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SteampunkSuitModel<T extends LivingEntity>
extends HumanoidArmorModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"steampunk_suit"), "outer");
    private final ModelPart skirt;
    private final ModelPart cannons;
    public final ModelPart cannon_right;
    public final ModelPart cannon_left;

    public SteampunkSuitModel(ModelPart root) {
        super(root);
        this.skirt = this.body.getChild("skirt");
        this.cannons = this.body.getChild("cannons");
        this.cannon_right = this.cannons.getChild("cannon_right");
        this.cannon_left = this.cannons.getChild("cannon_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.75f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.getChild("head");
        PartDefinition hat = partdefinition.getChild("hat");
        PartDefinition body = partdefinition.getChild("body");
        PartDefinition right_arm = partdefinition.getChild("right_arm");
        PartDefinition left_arm = partdefinition.getChild("left_arm");
        PartDefinition right_leg = partdefinition.getChild("right_leg");
        PartDefinition left_leg = partdefinition.getChild("left_leg");
        PartDefinition top_hat = head.addOrReplaceChild("top_hat", CubeListBuilder.create().texOffs(64, 46).addBox(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(96, 30).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(88, 18).addBox(-5.0f, -11.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.25f, (float)0.0f));
        PartDefinition body_overlay = body.addOrReplaceChild("body_overlay", CubeListBuilder.create().texOffs(16, 48).addBox(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.9f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cannons = body.addOrReplaceChild("cannons", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cannon_right = cannons.addOrReplaceChild("cannon_right", CubeListBuilder.create().texOffs(88, 0).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(-0.25f)).texOffs(64, 0).addBox(-2.0f, -4.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.75f)).texOffs(64, 12).addBox(-2.0f, -4.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.5f)).texOffs(112, 2).addBox(0.0f, -6.5f, 4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = cannon_right.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(79, 31).addBox(-3.0f, -5.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.75f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = cannon_right.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(82, 36).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cannon_left = cannons.addOrReplaceChild("cannon_left", CubeListBuilder.create().texOffs(88, 0).mirror().addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(-0.25f)).mirror(false).texOffs(64, 0).mirror().addBox(-2.0f, -4.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.75f)).mirror(false).texOffs(64, 12).mirror().addBox(-2.0f, -4.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.5f)).mirror(false).texOffs(112, 2).mirror().addBox(0.0f, -6.5f, 4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = cannon_left.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(79, 31).mirror().addBox(-3.0f, -5.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.75f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = cannon_left.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(82, 36).mirror().addBox(-3.0f, -6.0f, 0.0f, 6.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition skirt = body.addOrReplaceChild("skirt", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition skirt_right = skirt.addOrReplaceChild("skirt_right", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)0.0f, (float)0.0f));
        PartDefinition skirt_right_r1 = skirt_right.addOrReplaceChild("skirt_right_r1", CubeListBuilder.create().texOffs(114, 0).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offsetAndRotation((float)-2.6f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition skirt_left = skirt.addOrReplaceChild("skirt_left", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)0.0f, (float)0.0f));
        PartDefinition skirt_left_r1 = skirt_left.addOrReplaceChild("skirt_left_r1", CubeListBuilder.create().texOffs(114, 0).mirror().addBox(-1.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(1.0f)).mirror(false), PartPose.offsetAndRotation((float)2.6f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition right_arm_overlay = right_arm.addOrReplaceChild("right_arm_overlay", CubeListBuilder.create().texOffs(40, 48).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_overlay = left_arm.addOrReplaceChild("left_arm_overlay", CubeListBuilder.create().texOffs(40, 32).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_overlay = right_leg.addOrReplaceChild("right_leg_overlay", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_overlay = left_leg.addOrReplaceChild("left_leg_overlay", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public void copyPropertiesTo(HumanoidModel<T> pModel) {
        super.copyPropertiesTo(pModel);
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        float cannonYRot = Math.signum(this.head.yRot) * Math.min(0.63f, Math.abs(this.head.yRot));
        float cannonXRot = Math.min(0.24f, Math.signum(this.head.xRot) * Math.min(0.98f, Math.abs(this.head.xRot)));
        this.cannon_left.yRot = cannonYRot;
        this.cannon_right.yRot = cannonYRot;
        float f11 = 14.0f;
        float f12 = 0.0f;
        if (this.crouching) {
            f11 = 13.0f;
            f12 = -2.75f;
            this.cannon_left.xRot = cannonXRot - this.body.xRot;
            this.cannon_right.xRot = cannonXRot - this.body.xRot;
        } else {
            this.cannon_left.xRot = cannonXRot;
            this.cannon_right.xRot = cannonXRot;
        }
        this.skirt.y = f11;
        this.skirt.z = f12;
        this.skirt.xRot = -this.body.xRot;
        super.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }
}

