/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.lib.SilentLib;

public final class ClientTicks {
    private static final ClientTicks INSTANCE = new ClientTicks();
    private static final int QUEUE_OVERFLOW_LIMIT = 200;
    private volatile Queue<Runnable> scheduledActions = new ConcurrentLinkedDeque<Runnable>();
    public int ticksInGame = 0;
    public float partialTicks = 0.0f;
    public float deltaTicks = 0.0f;
    public float totalTicks = 0.0f;

    private ClientTicks() {
        NeoForge.EVENT_BUS.addListener(this::clientTickEnd);
        NeoForge.EVENT_BUS.addListener(this::renderTick);
    }

    public static void scheduleAction(Runnable action) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientTicks.INSTANCE.scheduledActions.add(action);
        } else {
            SilentLib.LOGGER.error("Tried to add client tick action on server side? {}", (Object)action);
        }
        if (ClientTicks.INSTANCE.scheduledActions.size() >= 200) {
            SilentLib.LOGGER.warn("Too many client tick actions queued! Currently at {} items. Would have added '{}'.", (Object)ClientTicks.INSTANCE.scheduledActions.size(), (Object)action);
            SilentLib.LOGGER.error("ClientTicks queue overflow", (Throwable)new IllegalStateException("ClientTicks queue overflow"));
            ClientTicks.INSTANCE.scheduledActions.clear();
        }
    }

    private void clientTickEnd(ClientTickEvent.Post event) {
        this.runScheduledActions();
        this.updateTickCounters();
    }

    private void renderTick(RenderFrameEvent.Pre event) {
        this.partialTicks = event.getPartialTick().getGameTimeDeltaTicks();
    }

    private void runScheduledActions() {
        Runnable action = this.scheduledActions.poll();
        while (action != null) {
            action.run();
            action = this.scheduledActions.poll();
        }
    }

    private void updateTickCounters() {
        Screen gui = Minecraft.getInstance().screen;
        if (gui == null || !gui.isPauseScreen()) {
            ++this.ticksInGame;
            this.partialTicks = 0.0f;
        }
        float oldTotal = this.totalTicks;
        this.totalTicks = (float)this.ticksInGame + this.partialTicks;
        this.deltaTicks = this.totalTicks - oldTotal;
    }

    public static int ticksInGame() {
        return ClientTicks.INSTANCE.ticksInGame;
    }

    public static float partialTicks() {
        return ClientTicks.INSTANCE.partialTicks;
    }

    public static float deltaTicks() {
        return ClientTicks.INSTANCE.deltaTicks;
    }

    public static float totalTicks() {
        return ClientTicks.INSTANCE.totalTicks;
    }
}

