/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.tiles;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.menus.WandChargerMenu;
import com.verdantartifice.primalmagick.common.tiles.mana.WandChargerTileEntity;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AbstractWandChargerTest
extends AbstractBaseTest {
    public void wand_charger_can_have_its_menu_opened(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        BlockPos pos = BlockPos.ZERO;
        helper.setBlock(pos, (Block)BlocksPM.WAND_CHARGER.get());
        WandChargerTileEntity tile = (WandChargerTileEntity)helper.getBlockEntity(pos);
        Services.PLAYER.openMenu(player, tile, pos);
        AbstractWandChargerTest.assertInstanceOf(helper, player.containerMenu, WandChargerMenu.class, "Menu not of expected type");
        helper.succeed();
    }

    public Collection<TestFunction> wand_charger_output_allows_chargeable_items(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"warded_armor", (Object)ItemsPM.BASIC_WARDING_MODULE.get().applyWard(ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance())).build();
        return TestUtils.createParameterizedTestFunctions("wand_charger_output_allows_chargeable_items", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewWandCharger((GameTestHelper)helper, Direction.NORTH);
            helper.assertTrue(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_charger_output_does_not_allow_unchargeable_items(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"stick", (Object)Items.STICK.getDefaultInstance()).put((Object)"earth_shard", (Object)ItemsPM.ESSENCE_DUST_EARTH.get().getDefaultInstance()).put((Object)"unwarded_armor", (Object)ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance()).build();
        return TestUtils.createParameterizedTestFunctions("wand_charger_output_does_not_allow_unchargeable_items", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewWandCharger((GameTestHelper)helper, Direction.NORTH);
            helper.assertFalse(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly valid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_charger_input_allows_essence(String templateName) {
        Map<String, ItemStack> testParams = EssenceItem.getAllEssences().stream().collect(Collectors.toMap(i -> Services.ITEMS_REGISTRY.getKey(i).getPath(), Item::getDefaultInstance));
        return TestUtils.createParameterizedTestFunctions("wand_charger_input_allows_essence", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewWandCharger((GameTestHelper)helper, Direction.UP);
            helper.assertTrue(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_charger_input_does_not_allow_non_essence(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"stick", (Object)Items.STICK.getDefaultInstance()).put((Object)"unwarded_armor", (Object)ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance()).build();
        return TestUtils.createParameterizedTestFunctions("wand_charger_input_does_not_allow_non_essence", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewWandCharger((GameTestHelper)helper, Direction.UP);
            helper.assertFalse(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly valid for item handler");
            helper.succeed();
        });
    }

    private IItemHandlerPM getItemHandlerForNewWandCharger(GameTestHelper helper, Direction direction) {
        BlockPos pos = BlockPos.ZERO;
        helper.setBlock(pos, (Block)BlocksPM.WAND_CHARGER.get());
        WandChargerTileEntity tile = (WandChargerTileEntity)helper.getBlockEntity(pos);
        IItemHandlerPM handler = tile.getRawItemHandler(direction);
        helper.assertFalse(handler == null, "No item handler found");
        return handler;
    }

    public Collection<TestFunction> wand_charger_can_charge_with_right_items(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"warded_armor", (Object)ItemsPM.BASIC_WARDING_MODULE.get().applyWard(ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance())).build();
        return TestUtils.createParameterizedTestFunctions("wand_charger_can_charge_with_right_items", templateName, testParams, (helper, stack) -> {
            BlockPos pos = BlockPos.ZERO;
            helper.setBlock(pos, (Block)BlocksPM.WAND_CHARGER.get());
            WandChargerTileEntity tile = (WandChargerTileEntity)helper.getBlockEntity(pos);
            tile.setItem(0, 0, ItemsPM.ESSENCE_DUST_EARTH.get().getDefaultInstance());
            tile.setItem(1, 0, (ItemStack)stack);
            helper.assertTrue(tile.canCharge(), "Unable to charge");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_charger_do_charge_with_right_items(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"warded_armor", (Object)ItemsPM.BASIC_WARDING_MODULE.get().applyWard(ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance())).build();
        return TestUtils.createParameterizedTestFunctions("wand_charger_do_charge_with_right_items", templateName, testParams, (helper, stack) -> {
            BlockPos pos = BlockPos.ZERO;
            helper.setBlock(pos, (Block)BlocksPM.WAND_CHARGER.get());
            WandChargerTileEntity tile = (WandChargerTileEntity)helper.getBlockEntity(pos);
            EssenceItem essenceItem = ItemsPM.ESSENCE_DUST_EARTH.get();
            tile.setItem(0, 0, essenceItem.getDefaultInstance());
            tile.setItem(1, 0, (ItemStack)stack);
            helper.assertTrue(stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get()), "Stack has no starting mana storage");
            int before = ((ManaStorage)stack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).getManaStored(essenceItem.getSource());
            tile.doCharge();
            helper.assertTrue(tile.getItem(0, 0).isEmpty(), "Input stack not empty");
            helper.assertFalse(tile.getItem(1, 0).isEmpty(), "Charge stack empty");
            helper.assertTrue(stack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get()), "Stack has no ending mana storage");
            helper.assertValueEqual((Object)((ManaStorage)stack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).getManaStored(essenceItem.getSource()), (Object)(before + essenceItem.getEssenceType().getManaEquivalent()), "Final mana load not as expected");
            helper.succeed();
        });
    }
}

