/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.tiles;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AbstractManaFontTest
extends AbstractBaseTest {
    public Collection<TestFunction> font_siphoned_by_wand(String templateName) {
        ImmutableMap testParams1 = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get()).put((Object)"modular_wand", (Object)ItemsPM.MODULAR_WAND.get()).put((Object)"modular_staff", (Object)ItemsPM.MODULAR_STAFF.get()).build();
        Map<String, AbstractManaFontBlock> testParams2 = AbstractManaFontBlock.getAll().stream().collect(Collectors.toMap(b -> Services.BLOCKS_REGISTRY.getKey(b).getPath(), b -> b));
        return TestUtils.createDualParameterizedTestFunctions("font_drained_by_wand", templateName, testParams1, testParams2, (helper, wandItem, block) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper, true);
            ItemStack wandStack = IHasWandComponents.setWandComponents(wandItem.getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE);
            IWand wand = AbstractManaFontTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack not a wand as expected");
            player.setItemInHand(InteractionHand.MAIN_HAND, wandStack);
            BlockPos fontPos = BlockPos.ZERO;
            helper.setBlock(fontPos, (Block)block);
            helper.assertBlockState(fontPos, state -> state.is((Block)block), () -> "Font not placed correctly");
            AbstractManaFontTileEntity fontTile = (AbstractManaFontTileEntity)helper.getBlockEntity(fontPos);
            fontTile.setMana(fontTile.getManaCapacity());
            Sources.getAll().forEach(s -> helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)s), (Object)0, "Initial wand mana for " + String.valueOf(s.getId())));
            helper.assertValueEqual((Object)fontTile.getMana(), (Object)fontTile.getManaCapacity(), "Initial font mana");
            fontTile.doSiphon(wandStack, (Level)helper.getLevel(), (Player)player, player.getEyePosition());
            int expectedSiphon = wand.getSiphonAmount(wandStack);
            Sources.getAll().forEach(s -> {
                int expectedMana = s.equals(block.getSource()) ? expectedSiphon : 0;
                helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)s), (Object)expectedMana, "Final wand mana for " + String.valueOf(s.getId()));
            });
            int fontCentimanaCapacity = fontTile.getManaCapacity();
            int actualCentimana = fontTile.getMana();
            helper.assertValueEqual((Object)actualCentimana, (Object)(fontCentimanaCapacity - expectedSiphon), "Final font mana");
            helper.succeed();
        });
    }

    public Collection<TestFunction> fonts_recharge(String templateName) {
        Map<String, AbstractManaFontBlock> testParams = AbstractManaFontBlock.getAll().stream().collect(Collectors.toMap(b -> Services.BLOCKS_REGISTRY.getKey(b).getPath(), b -> b));
        return TestUtils.createParameterizedTestFunctions("fonts_recharge", templateName, testParams, (helper, block) -> {
            BlockPos fontPos = BlockPos.ZERO;
            helper.setBlock(fontPos, (Block)block);
            helper.assertBlockState(fontPos, state -> state.is((Block)block), () -> "Font not placed correctly");
            AbstractManaFontTileEntity fontTile = (AbstractManaFontTileEntity)helper.getBlockEntity(fontPos);
            fontTile.setMana(0);
            helper.assertValueEqual((Object)fontTile.getMana(), (Object)0, "Initial font mana");
            fontTile.doRecharge();
            helper.assertValueEqual((Object)fontTile.getMana(), (Object)fontTile.getManaRechargedPerTick(), "Final font mana");
        });
    }
}

