/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.tiles;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.ManaBatteryBlock;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.menus.ManaBatteryMenu;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaBatteryTileEntity;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AbstractManaBatteryTest
extends AbstractBaseTest {
    private Map<String, ItemStack> getChargeableTestParams() {
        return ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"warded_armor", (Object)ItemsPM.BASIC_WARDING_MODULE.get().applyWard(ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance())).build();
    }

    private Map<String, ItemStack> getUnchargeableTestParams() {
        return ImmutableMap.builder().put((Object)"stick", (Object)Items.STICK.getDefaultInstance()).put((Object)"earth_shard", (Object)ItemsPM.ESSENCE_DUST_EARTH.get().getDefaultInstance()).put((Object)"unwarded_armor", (Object)ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance()).build();
    }

    private Map<String, ManaBatteryBlock> getBatteryTestParams() {
        return ImmutableMap.builder().put((Object)"mana_nexus", (Object)BlocksPM.MANA_NEXUS.get()).put((Object)"mana_singularity", (Object)BlocksPM.MANA_SINGULARITY.get()).put((Object)"creative_mana_singularity", (Object)BlocksPM.MANA_SINGULARITY_CREATIVE.get()).build();
    }

    public Collection<TestFunction> mana_battery_can_have_its_menu_opened(String templateName) {
        Map<String, ManaBatteryBlock> testParams = this.getBatteryTestParams();
        return TestUtils.createParameterizedTestFunctions("", templateName, testParams, (helper, block) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            BlockPos pos = BlockPos.ZERO;
            helper.setBlock(pos, (Block)block);
            ManaBatteryTileEntity tile = (ManaBatteryTileEntity)helper.getBlockEntity(pos);
            Services.PLAYER.openMenu(player, tile, pos);
            AbstractManaBatteryTest.assertInstanceOf(helper, player.containerMenu, ManaBatteryMenu.class, "Menu not of expected type");
            helper.succeed();
        });
    }

    public Collection<TestFunction> mana_battery_output_allows_chargeable_items(String templateName) {
        Map<String, ManaBatteryBlock> blockParams = this.getBatteryTestParams();
        Map<String, ItemStack> testParams = this.getChargeableTestParams();
        return TestUtils.createDualParameterizedTestFunctions("mana_battery_output_allows_chargeable_items", templateName, blockParams, testParams, (helper, block, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewManaBattery((GameTestHelper)helper, (ManaBatteryBlock)block, Direction.NORTH);
            helper.assertTrue(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> mana_battery_output_does_not_allow_unchargeable_items(String templateName) {
        Map<String, ManaBatteryBlock> blockParams = this.getBatteryTestParams();
        Map<String, ItemStack> testParams = this.getUnchargeableTestParams();
        return TestUtils.createDualParameterizedTestFunctions("mana_battery_output_does_not_allow_unchargeable_items", templateName, blockParams, testParams, (helper, block, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewManaBattery((GameTestHelper)helper, (ManaBatteryBlock)block, Direction.NORTH);
            helper.assertFalse(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly valid for item handler");
            helper.succeed();
        });
    }

    private IItemHandlerPM getItemHandlerForNewManaBattery(GameTestHelper helper, ManaBatteryBlock block, Direction direction) {
        BlockPos pos = BlockPos.ZERO;
        helper.setBlock(pos, (Block)block);
        ManaBatteryTileEntity tile = (ManaBatteryTileEntity)helper.getBlockEntity(pos);
        IItemHandlerPM handler = tile.getRawItemHandler(direction);
        helper.assertFalse(handler == null, "No item handler found");
        return handler;
    }

    public Collection<TestFunction> mana_battery_input_allows_essence(String templateName) {
        Map<String, ManaBatteryBlock> blockParams = this.getBatteryTestParams();
        Map<String, Item> essenceParams = EssenceItem.getAllEssences().stream().collect(Collectors.toMap(e -> Services.ITEMS_REGISTRY.getKey(e).getPath(), e -> e));
        return TestUtils.createDualParameterizedTestFunctions("mana_battery_input_allows_essence", templateName, blockParams, essenceParams, (helper, block, item) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewManaBattery((GameTestHelper)helper, (ManaBatteryBlock)block, Direction.UP);
            helper.assertTrue(handler.isItemValid(0, item.getDefaultInstance()), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> mana_battery_input_allows_wands(String templateName) {
        Map<String, ManaBatteryBlock> blockParams = this.getBatteryTestParams();
        ImmutableMap wandParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).build();
        return TestUtils.createDualParameterizedTestFunctions("mana_battery_input_allows_wands", templateName, blockParams, wandParams, (helper, block, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewManaBattery((GameTestHelper)helper, (ManaBatteryBlock)block, Direction.UP);
            helper.assertTrue(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> mana_battery_siphons_from_nearby_fonts(String templateName) {
        ImmutableMap blockParams = ImmutableMap.builder().put((Object)"mana_nexus", (Object)BlocksPM.MANA_NEXUS.get()).put((Object)"mana_singularity", (Object)BlocksPM.MANA_SINGULARITY.get()).build();
        Map<String, AbstractManaFontBlock> fontParams = AbstractManaFontBlock.getAll().stream().collect(Collectors.toMap(b -> Services.BLOCKS_REGISTRY.getKey(b).getPath(), b -> b));
        return TestUtils.createDualParameterizedTestFunctions("mana_battery_siphons_from_nearby_fonts", templateName, blockParams, fontParams, (helper, block, font) -> {
            BlockPos batteryPos = BlockPos.ZERO.north();
            helper.setBlock(batteryPos, (Block)block);
            ManaBatteryTileEntity batteryTile = (ManaBatteryTileEntity)helper.getBlockEntity(batteryPos);
            BlockPos fontPos = BlockPos.ZERO.east();
            helper.setBlock(fontPos, (Block)font);
            AbstractManaFontTileEntity fontTile = (AbstractManaFontTileEntity)helper.getBlockEntity(fontPos);
            int startFontMana = 1000;
            fontTile.setMana(1000);
            helper.assertValueEqual((Object)fontTile.getMana(), (Object)1000, "Before font mana");
            helper.assertTrue(batteryTile.getAllMana().isEmpty(), "Before battery mana not empty");
            int transferCap = batteryTile.getBatteryTransferCap();
            int expectedTransfer = Math.min(1000, transferCap);
            int expectedFontMana = 1000 - expectedTransfer + fontTile.getManaRechargedPerTick();
            SourceList expectedBatteryMana = SourceList.builder().with(font.getSource(), expectedTransfer).build();
            helper.succeedOnTickWhen(1, () -> {
                helper.assertValueEqual((Object)fontTile.getMana(), (Object)expectedFontMana, "After font mana");
                helper.assertValueEqual((Object)batteryTile.getAllMana(), (Object)expectedBatteryMana, "After battery mana");
            });
        });
    }
}

