/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.tiles;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.tiles.mana.AutoChargerTileEntity;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class AbstractAutoChargerTest
extends AbstractBaseTest {
    private Map<String, ItemStack> getChargeableTestParams() {
        return ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get().getDefaultInstance()).put((Object)"modular_wand", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"modular_staff", (Object)IHasWandComponents.setWandComponents(ItemsPM.MODULAR_STAFF.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE)).put((Object)"warded_armor", (Object)ItemsPM.BASIC_WARDING_MODULE.get().applyWard(ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance())).build();
    }

    private Map<String, ItemStack> getUnchargeableTestParams() {
        return ImmutableMap.builder().put((Object)"stick", (Object)Items.STICK.getDefaultInstance()).put((Object)"earth_shard", (Object)ItemsPM.ESSENCE_DUST_EARTH.get().getDefaultInstance()).put((Object)"unwarded_armor", (Object)ItemsPM.PRIMALITE_CHEST.get().getDefaultInstance()).build();
    }

    public Collection<TestFunction> auto_charger_output_allows_chargeable_items(String templateName) {
        Map<String, ItemStack> testParams = this.getChargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_output_allows_chargeable_items", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewAutoCharger((GameTestHelper)helper, BlockPos.ZERO, Direction.NORTH);
            helper.assertTrue(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly invalid for item handler");
            helper.succeed();
        });
    }

    public Collection<TestFunction> auto_charger_output_does_not_allow_unchargeable_items(String templateName) {
        Map<String, ItemStack> testParams = this.getUnchargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_output_does_not_allow_unchargeable_items", templateName, testParams, (helper, stack) -> {
            IItemHandlerPM handler = this.getItemHandlerForNewAutoCharger((GameTestHelper)helper, BlockPos.ZERO, Direction.NORTH);
            helper.assertFalse(handler.isItemValid(0, (ItemStack)stack), "Test stack unexpectedly valid for item handler");
            helper.succeed();
        });
    }

    private IItemHandlerPM getItemHandlerForNewAutoCharger(GameTestHelper helper, BlockPos pos, Direction face) {
        helper.setBlock(pos, (Block)BlocksPM.AUTO_CHARGER.get());
        AutoChargerTileEntity tile = (AutoChargerTileEntity)helper.getBlockEntity(pos);
        IItemHandlerPM handler = tile.getRawItemHandler(face);
        helper.assertFalse(handler == null, "No item handler found");
        return handler;
    }

    public Collection<TestFunction> auto_charger_can_have_chargeable_items_inserted(String templateName) {
        Map<String, ItemStack> testParams = this.getChargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_can_have_chargeable_items_inserted", templateName, testParams, (helper, stack) -> {
            ItemStack before = stack.copy();
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            BlockPos chargerPos = BlockPos.ZERO;
            IItemHandlerPM handler = this.getItemHandlerForNewAutoCharger((GameTestHelper)helper, chargerPos, Direction.UP);
            helper.assertTrue(handler.getStackInSlot(0).isEmpty(), "Charger has an item before use");
            BlockState chargerState = helper.getBlockState(chargerPos);
            BlockHitResult hitResult = new BlockHitResult(helper.absolutePos(chargerPos).getCenter(), Direction.UP, helper.absolutePos(chargerPos), true);
            ItemInteractionResult useResult = chargerState.useItemOn(stack, (Level)helper.getLevel(), (Player)player, InteractionHand.MAIN_HAND, hitResult);
            helper.assertTrue(useResult.consumesAction(), "Use action failed");
            helper.assertFalse(handler.getStackInSlot(0).isEmpty(), "Charger has no item after use");
            helper.assertTrue(handler.getStackInSlot(0).is(before.getItem()), "Charge item does not match initial stack");
            helper.succeed();
        });
    }

    public Collection<TestFunction> auto_charger_cannot_have_unchargeable_items_inserted(String templateName) {
        Map<String, ItemStack> testParams = this.getUnchargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_cannot_have_unchargeable_items_inserted", templateName, testParams, (helper, stack) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            BlockPos chargerPos = BlockPos.ZERO.north();
            IItemHandlerPM handler = this.getItemHandlerForNewAutoCharger((GameTestHelper)helper, chargerPos, Direction.UP);
            helper.assertTrue(handler.getStackInSlot(0).isEmpty(), "Charger has an item before use");
            BlockState chargerState = helper.getBlockState(chargerPos);
            BlockHitResult hitResult = new BlockHitResult(chargerPos.getCenter(), Direction.UP, chargerPos, true);
            ItemInteractionResult useResult = chargerState.useItemOn(stack, (Level)helper.getLevel(), (Player)player, InteractionHand.MAIN_HAND, hitResult);
            helper.assertFalse(useResult.consumesAction(), "Use action unexpectedly succeeded");
            helper.assertTrue(handler.getStackInSlot(0).isEmpty(), "Charger has item after use");
            helper.succeed();
        });
    }

    public Collection<TestFunction> auto_charger_can_have_chargeable_items_removed(String templateName) {
        Map<String, ItemStack> testParams = this.getChargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_can_have_chargeable_items_removed", templateName, testParams, (helper, stack) -> {
            ItemStack before = stack.copy();
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            BlockPos chargerPos = BlockPos.ZERO;
            IItemHandlerPM handler = this.getItemHandlerForNewAutoCharger((GameTestHelper)helper, chargerPos, Direction.UP);
            handler.setStackInSlot(0, (ItemStack)stack);
            helper.assertFalse(handler.getStackInSlot(0).isEmpty(), "Failed to set item in charger");
            BlockState chargerState = helper.getBlockState(chargerPos);
            BlockHitResult hitResult = new BlockHitResult(helper.absolutePos(chargerPos).getCenter(), Direction.UP, helper.absolutePos(chargerPos), true);
            ItemInteractionResult useResult = chargerState.useItemOn(ItemStack.EMPTY, (Level)helper.getLevel(), (Player)player, InteractionHand.MAIN_HAND, hitResult);
            helper.assertTrue(useResult.consumesAction(), "Use action failed");
            helper.assertTrue(handler.getStackInSlot(0).isEmpty(), "Charger has item after use");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).is(before.getItem()), "Hand item does not match initial stack");
            helper.succeed();
        });
    }

    public Collection<TestFunction> auto_charger_siphons_into_chargeable_items(String templateName) {
        Map<String, ItemStack> stackParams = this.getChargeableTestParams();
        return TestUtils.createParameterizedTestFunctions("auto_charger_siphons_into_chargeable_items", templateName, stackParams, (helper, baseStack) -> {
            ItemStack stack = baseStack.copy();
            BlockPos chargerPos = BlockPos.ZERO.north();
            helper.setBlock(chargerPos, (Block)BlocksPM.AUTO_CHARGER.get());
            AutoChargerTileEntity chargerTile = (AutoChargerTileEntity)helper.getBlockEntity(chargerPos);
            BlockPos fontPos = BlockPos.ZERO.east();
            helper.setBlock(fontPos, (Block)BlocksPM.ARTIFICIAL_FONT_EARTH.get());
            AbstractManaFontTileEntity fontTile = (AbstractManaFontTileEntity)helper.getBlockEntity(fontPos);
            int startFontMana = 1000;
            fontTile.setMana(1000);
            IItemHandlerPM handler = chargerTile.getRawItemHandler(Direction.NORTH);
            helper.assertFalse(handler == null, "No item handler found");
            handler.setStackInSlot(0, stack);
            ItemStack beforeStack = handler.getStackInSlot(0);
            helper.assertFalse(beforeStack.isEmpty(), "Stack not successfully inserted into charger");
            helper.assertTrue(beforeStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get()), "Before stack has no mana storage");
            helper.assertValueEqual((Object)((ManaStorage)beforeStack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).getManaStored(Sources.EARTH), (Object)0, "Before stack not initially empty");
            helper.assertValueEqual((Object)fontTile.getMana(), (Object)1000, "Before font mana not as expected");
            int expectedSiphonAmount = 100;
            helper.succeedOnTickWhen(1, () -> {
                ItemStack afterStack = handler.getStackInSlot(0);
                helper.assertFalse(afterStack.isEmpty(), "After stack empty");
                helper.assertTrue(afterStack.has(DataComponentsPM.CAPABILITY_MANA_STORAGE.get()), "After stack has no mana storage");
                int afterStackMana = ((ManaStorage)afterStack.getOrDefault(DataComponentsPM.CAPABILITY_MANA_STORAGE.get(), (Object)ManaStorage.EMPTY)).getManaStored(Sources.EARTH);
                int fontMana = fontTile.getMana();
                helper.assertValueEqual((Object)afterStackMana, (Object)100, "After stack mana total not as expected");
                helper.assertValueEqual((Object)fontMana, (Object)(900 + fontTile.getManaRechargedPerTick()), "After font mana not as expected");
            });
        });
    }
}

