/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.spells;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.AbstractWandItem;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadsPM;
import com.verdantartifice.primalmagick.common.spells.vehicles.TouchSpellVehicle;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AbstractWandSpellcastTest
extends AbstractBaseTest {
    private static final Map<String, SpellPayloadType<?>> TEST_PAYLOADS = ImmutableMap.builder().put((Object)"earth_damage", SpellPayloadsPM.EARTH_DAMAGE.get()).put((Object)"sea_damage", SpellPayloadsPM.FROST_DAMAGE.get()).put((Object)"sky_damage", SpellPayloadsPM.LIGHTNING_DAMAGE.get()).put((Object)"sun_damage", SpellPayloadsPM.SOLAR_DAMAGE.get()).put((Object)"moon_damage", SpellPayloadsPM.LUNAR_DAMAGE.get()).put((Object)"blood_damage", SpellPayloadsPM.BLOOD_DAMAGE.get()).put((Object)"infernal_damage", SpellPayloadsPM.FLAME_DAMAGE.get()).put((Object)"void_damage", SpellPayloadsPM.VOID_DAMAGE.get()).put((Object)"hallowed_damage", SpellPayloadsPM.HOLY_DAMAGE.get()).build();

    protected ItemStack getTestWand() {
        return IHasWandComponents.setWandComponents(ItemsPM.MODULAR_WAND.get().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE);
    }

    public Collection<TestFunction> damage_spells_deduct_mana_from_wand_and_award_expertise(String templateName) {
        return TestUtils.createParameterizedTestFunctions("damage_spells_deduct_mana_from_wand", templateName, TEST_PAYLOADS, (helper, payloadType) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper, true);
            Optional<Integer> expOpt = ExpertiseManager.getValue((Player)player, ResearchDisciplines.SORCERY);
            helper.assertTrue(expOpt.isPresent(), "Sorcery expertise not found");
            helper.assertValueEqual((Object)expOpt.get(), (Object)0, "Starting sorcery expertise");
            ItemStack wandStack = this.getTestWand();
            AbstractWandItem wand = AbstractWandSpellcastTest.assertInstanceOf(helper, wandStack.getItem(), AbstractWandItem.class, "Wand stack is not a wand as expected");
            Sources.getAll().forEach(s -> {
                int maxWandMana = wand.getMaxMana(wandStack, (Source)s);
                wand.addMana(wandStack, (Source)s, maxWandMana);
                helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)s), (Object)maxWandMana, "Starting wand mana for " + String.valueOf(s.getId()));
            });
            player.setItemInHand(InteractionHand.MAIN_HAND, wandStack);
            int spellPower = 3;
            int spellDuration = 3;
            AbstractSpellPayload payloadInstance = (AbstractSpellPayload)payloadType.instanceSupplier().get();
            SpellPackage spellPackage = SpellPackage.builder().name("Test Spell").vehicle().type(TouchSpellVehicle.INSTANCE).end().payload().type(payloadInstance).with(SpellPropertiesPM.POWER.get(), 3).with(SpellPropertiesPM.DURATION.get(), 3).end().build();
            helper.assertTrue(wand.addSpell(wandStack, spellPackage), "Spell was not added to the wand");
            helper.assertTrue(wand.setActiveSpellIndex(wandStack, 0), "Spell was not set to active");
            InteractionResultHolder<ItemStack> result = wand.use((Level)helper.getLevel(), (Player)player, InteractionHand.MAIN_HAND);
            helper.assertTrue(result.getResult().consumesAction(), "Wand use result was not a success");
            SourceList spellCost = spellPackage.getManaCost();
            Sources.getAll().forEach(s -> {
                int maxWandMana = wand.getMaxMana(wandStack, (Source)s);
                int consumedCentimana = spellCost.getAmount((Source)s);
                int finalCost = wand.getModifiedCost(wandStack, (Player)player, (Source)s, consumedCentimana, (HolderLookup.Provider)helper.getLevel().registryAccess());
                int expectedCentimana = maxWandMana - finalCost;
                helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)s), (Object)expectedCentimana, "Final wand mana for " + String.valueOf(s.getId()));
            });
            int expectedExpertise = spellCost.getManaSize() / 100;
            expOpt = ExpertiseManager.getValue((Player)player, ResearchDisciplines.SORCERY);
            helper.assertTrue(expOpt.isPresent(), "Final sorcery expertise not found");
            helper.assertValueEqual((Object)expOpt.get(), (Object)expectedExpertise, "Final sorcery expertise");
            helper.succeed();
        });
    }
}

