/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.research;

import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ExpertiseRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemStackRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemTagRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.KnowledgeRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.OrRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.QuorumRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.StatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.VanillaCustomStatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.VanillaItemUsedStatRequirement;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.CommonTags;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractResearchRequirementsTest
extends AbstractBaseTest {
    public void research_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ResearchRequirement req = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.FIRST_STEPS));
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.FIRST_STEPS);
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }

    public void knowledge_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        KnowledgeRequirement req = new KnowledgeRequirement(KnowledgeType.OBSERVATION, 5);
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, 5 * KnowledgeType.OBSERVATION.getProgression());
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }

    public void item_stack_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStackRequirement req = new ItemStackRequirement(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        player.getInventory().add(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }

    public void item_tag_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemTagRequirement req = new ItemTagRequirement(CommonTags.Items.INGOTS_IRON, 1);
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        player.getInventory().add(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }

    public void stat_requirement(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        StatRequirement req = new StatRequirement(StatsPM.MANA_SIPHONED, 2);
        helper.assertFalse(req.isMetBy((Player)player), "Baseline expectation failed");
        StatsManager.setValue((Player)player, StatsPM.MANA_SIPHONED, 2);
        helper.assertTrue(req.isMetBy((Player)player), "Requirement not met");
        helper.succeed();
    }

    public void expertise_requirement(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        ExpertiseRequirement req = new ExpertiseRequirement(ResearchDisciplines.MANAWEAVING, ResearchTier.EXPERT, 12);
        helper.assertFalse(req.isMetBy((Player)player), "Baseline expectation failed");
        ResearchManager.forceGrantWithAllParents((Player)player, ResearchEntries.UNLOCK_MANAWEAVING);
        ExpertiseManager.setValue((Player)player, new ResearchDisciplineKey(ResearchDisciplines.MANAWEAVING), 12);
        helper.assertTrue(req.isMetBy((Player)player), "Requirement not met");
        helper.succeed();
    }

    public void vanilla_item_used_stat_requirement(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        VanillaItemUsedStatRequirement req = new VanillaItemUsedStatRequirement(Items.SNOWBALL, 1);
        helper.assertFalse(req.isMetBy((Player)player), "Baseline expectation failed");
        BlockPos pos = new BlockPos(2, 2, 2);
        player.setPos(Vec3.atBottomCenterOf((Vec3i)helper.absolutePos(pos)));
        ItemStack stack = new ItemStack((ItemLike)Items.SNOWBALL);
        stack.use((Level)helper.getLevel(), (Player)player, InteractionHand.MAIN_HAND);
        helper.assertTrue(req.isMetBy((Player)player), "Requirement not met");
        helper.succeed();
    }

    public void vanilla_custom_stat_requirement(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        VanillaCustomStatRequirement req = new VanillaCustomStatRequirement(Stats.JUMP, 1, null);
        helper.assertFalse(req.isMetBy((Player)player), "Baseline expectation failed");
        player.jumpFromGround();
        helper.assertTrue(req.isMetBy((Player)player), "Requirement not met");
        helper.succeed();
    }

    public void and_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        AndRequirement req = new AndRequirement(new ResearchRequirement(new ResearchEntryKey(ResearchEntries.FIRST_STEPS)), new KnowledgeRequirement(KnowledgeType.OBSERVATION, 5), new ItemStackRequirement(new ItemStack((ItemLike)Items.IRON_INGOT)));
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.FIRST_STEPS);
        helper.assertFalse(req.isMetBy(player), "Partial expectation 1 failed");
        player.getInventory().add(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertFalse(req.isMetBy(player), "Partial expectation 2 failed");
        ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, 5 * KnowledgeType.OBSERVATION.getProgression());
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }

    public void or_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        OrRequirement req = new OrRequirement(new ResearchRequirement(new ResearchEntryKey(ResearchEntries.FIRST_STEPS)), new KnowledgeRequirement(KnowledgeType.OBSERVATION, 5), new ItemStackRequirement(new ItemStack((ItemLike)Items.IRON_INGOT)));
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.FIRST_STEPS);
        helper.assertTrue(req.isMetBy(player), "Partial expectation 1 failed");
        ResearchManager.forceRevokeWithAllChildren(player, ResearchEntries.FIRST_STEPS);
        player.getInventory().add(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertTrue(req.isMetBy(player), "Partial expectation 2 failed");
        player.getInventory().clearContent();
        ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, 5 * KnowledgeType.OBSERVATION.getProgression());
        helper.assertTrue(req.isMetBy(player), "Partial expectation 3 failed");
        helper.succeed();
    }

    public void quorum_requirement(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        QuorumRequirement req = new QuorumRequirement(2, new ResearchRequirement(new ResearchEntryKey(ResearchEntries.FIRST_STEPS)), new KnowledgeRequirement(KnowledgeType.OBSERVATION, 5), new ItemStackRequirement(new ItemStack((ItemLike)Items.IRON_INGOT)));
        helper.assertFalse(req.isMetBy(player), "Baseline expectation failed");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.FIRST_STEPS);
        helper.assertFalse(req.isMetBy(player), "Partial expectation 1 failed");
        player.getInventory().add(new ItemStack((ItemLike)Items.IRON_INGOT));
        helper.assertTrue(req.isMetBy(player), "Requirement not met");
        helper.succeed();
    }
}

