/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.items;

import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractWandManaTest
extends AbstractBaseTest {
    protected static final Map<String, Source> SOURCE_TEST_PARAMS = Sources.streamSorted().collect(Collectors.toMap(source -> source.getId().getPath(), source -> source));

    protected abstract Item getTestWandItem();

    protected ItemStack getTestWand() {
        return IHasWandComponents.setWandComponents(this.getTestWandItem().getDefaultInstance(), WandCore.HEARTWOOD, WandCap.IRON, WandGem.APPRENTICE);
    }

    protected String makeTestName(String testNameInfix) {
        return Objects.requireNonNull(Services.ITEMS_REGISTRY.getKey(this.getTestWandItem())).getPath() + "." + testNameInfix;
    }

    public Collection<TestFunction> wand_can_get_and_add_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)source), (Object)0, "Wand is not empty as expected");
            helper.assertValueEqual((Object)wand.addMana(wandStack, (Source)source, 1), (Object)0, "Failed to add centimana to wand");
            helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)source), (Object)1, "Wand mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_can_get_and_add_real_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            helper.assertTrue(wand.getMana(wandStack, (Source)source) == 0, "Wand is not empty as expected");
            helper.assertTrue(wand.addMana(wandStack, (Source)source, 100) == 0, "Failed to add real mana to wand");
            helper.assertTrue(wand.getMana(wandStack, (Source)source) == 100, "Wand mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_cannot_add_too_much_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int maxCentimana = wand.getMaxMana(wandStack, (Source)source);
            int attemptedRealMana = 100000;
            int attemptedCentimana = 100 * attemptedRealMana;
            int expectedCentimana = attemptedCentimana - maxCentimana;
            int actualMana = wand.addMana(wandStack, (Source)source, attemptedCentimana);
            helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)source), (Object)maxCentimana, "Wand mana total");
            helper.assertValueEqual((Object)actualMana, (Object)expectedCentimana, "Wand overfill");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_can_get_all_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> wand.addMana(wandStack, (Source)s, 100));
            SourceList.Builder sourceListBuilder = SourceList.builder();
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> sourceListBuilder.with((Source)s, 100));
            SourceList sourceList = sourceListBuilder.build();
            helper.assertTrue(wand.getAllMana(wandStack).equals(sourceList), "Wand mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_can_consume_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int startingRealMana = 10;
            int startingCentimana = 1000;
            int consumedCentimana = 100;
            int finalCost = wand.getModifiedCost(wandStack, (Player)player, (Source)source, 100, (HolderLookup.Provider)helper.getLevel().registryAccess());
            int expectedCentimana = 1000 - finalCost;
            helper.assertTrue(wand.addMana(wandStack, (Source)source, 1000) == 0, "Failed to add real mana to wand");
            helper.assertTrue(wand.consumeMana(wandStack, (Player)player, (Source)source, 100, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Failed to consume mana from wand");
            int actual = wand.getMana(wandStack, (Source)source);
            helper.assertValueEqual((Object)actual, (Object)expectedCentimana, "Mana total for " + String.valueOf(source.getId()));
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_cannot_consume_more_mana_than_it_has(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            helper.assertTrue(wand.addMana(wandStack, (Source)source, 100) == 0, "Failed to add real mana to wand");
            helper.assertFalse(wand.consumeMana(wandStack, (Player)player, (Source)source, 200, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Consumption of maan succeeded when it shouldn't have");
            helper.assertTrue(wand.getMana(wandStack, (Source)source) == 100, "Wand mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_can_consume_multiple_types_of_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int startingRealMana = 10;
            int startingCentimana = 1000;
            int consumedCentimana = 100;
            int finalCost = wand.getModifiedCost(wandStack, (Player)player, (Source)source, 100, (HolderLookup.Provider)helper.getLevel().registryAccess());
            int expectedCentimana = 1000 - finalCost;
            Sources.getAll().forEach(s -> helper.assertTrue(wand.addMana(wandStack, (Source)s, 1000) == 0, "Failed to add real mana to wand for " + String.valueOf(s.getId())));
            SourceList.Builder sourceListBuilder = SourceList.builder();
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> sourceListBuilder.with((Source)s, 100));
            SourceList sourceList = sourceListBuilder.build();
            helper.assertTrue(wand.consumeMana(wandStack, (Player)player, sourceList, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Failed to consume mana from wand");
            Sources.getAll().forEach(s -> {
                int expected = s.equals(source) ? 1000 : expectedCentimana;
                int actual = wand.getMana(wandStack, (Source)s);
                helper.assertValueEqual((Object)actual, (Object)expected, "Mana total for " + String.valueOf(s.getId()));
            });
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_cannot_consume_more_mana_than_it_has_with_multiple_types(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            Sources.getAll().forEach(s -> wand.addMana(wandStack, (Source)s, 100));
            SourceList.Builder sourceListBuilder = SourceList.builder();
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> sourceListBuilder.with((Source)s, 500));
            SourceList sourceList = sourceListBuilder.build();
            helper.assertFalse(wand.consumeMana(wandStack, (Player)player, sourceList, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Mana consumption succeeded when it shouldn't have");
            Sources.getAll().forEach(s -> helper.assertTrue(wand.getMana(wandStack, (Source)source) == 100, "Mana total is not as expected"));
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_can_remove_mana_raw(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            boolean startingRealMana = true;
            int startingCentimana = 100;
            int removedCentimana = 10;
            int expectedCentimana = 90;
            helper.assertTrue(wand.addMana(wandStack, (Source)source, 100) == 0, "Failed to add mana to wand");
            helper.assertTrue(wand.removeManaRaw(wandStack, (Source)source, 10), "Failed to remove mana from wand");
            helper.assertTrue(wand.getMana(wandStack, (Source)source) == 90, "Wand mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_cannot_remove_more_raw_mana_than_it_has(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            helper.assertTrue(wand.addMana(wandStack, (Source)source, 100) == 0, "Failed to add mana to wand");
            helper.assertFalse(wand.removeManaRaw(wandStack, (Source)source, 200), "Mana removal succeeded when it shouldn't have");
            helper.assertTrue(wand.getMana(wandStack, (Source)source) == 100, "Mana total is not as expected");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_contains_mana(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int startingRealMana = 10;
            int startingCentimana = 1000;
            double costModifier = 1.0 + (double)wand.getTotalCostModifier(wandStack, (Player)player, (Source)source, (HolderLookup.Provider)helper.getLevel().registryAccess()) / 100.0;
            int exactCentimana = (int)(1000.0 * costModifier);
            int lessCentimana = exactCentimana - 10;
            int greaterCentimana = exactCentimana + 10;
            int overflow = wand.addMana(wandStack, (Source)source, 1000);
            helper.assertTrue(overflow == 0, "Failed to add real mana to wand, overflow is " + overflow);
            helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)source), (Object)1000, "Mana total for source " + String.valueOf(source.getId()));
            helper.assertTrue(wand.containsMana(wandStack, (Player)player, (Source)source, lessCentimana, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Contains returned false for less than held");
            helper.assertTrue(wand.containsMana(wandStack, (Player)player, (Source)source, exactCentimana, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Contains returned false for exact held");
            helper.assertFalse(wand.containsMana(wandStack, (Player)player, (Source)source, greaterCentimana, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Contains returned true for greater than held");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_contains_mana_list(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int startingRealMana = 10;
            int startingCentimana = 1000;
            double costModifier = 1.0 + (double)wand.getTotalCostModifier(wandStack, (Player)player, (Source)source, (HolderLookup.Provider)helper.getLevel().registryAccess()) / 100.0;
            int modifiedCentimana = (int)(1000.0 * costModifier);
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> wand.addMana(wandStack, (Source)s, 1000));
            SourceList.Builder greenBuilder = SourceList.builder();
            Sources.stream().filter(s -> !s.equals(source)).forEach(s -> greenBuilder.with((Source)s, modifiedCentimana));
            SourceList greenList = greenBuilder.build();
            helper.assertTrue(wand.containsMana(wandStack, (Player)player, greenList, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Contains returned false for green list");
            SourceList.Builder redBuilder = SourceList.builder();
            Sources.getAll().forEach(s -> redBuilder.with((Source)s, modifiedCentimana));
            SourceList redList = redBuilder.build();
            helper.assertFalse(wand.containsMana(wandStack, (Player)player, redList, (HolderLookup.Provider)helper.getLevel().registryAccess()), "Contains returned true for red list");
            helper.succeed();
        });
    }

    public Collection<TestFunction> wand_contains_mana_raw(String testName, String templateName) {
        return TestUtils.createParameterizedTestFunctions(testName, templateName, SOURCE_TEST_PARAMS, (helper, source) -> {
            ItemStack wandStack = this.getTestWand();
            IWand wand = AbstractWandManaTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand stack is not a wand as expected");
            int startingRealMana = 10;
            int exactCentimana = 1000;
            int lessCentimana = 999;
            int greaterCentimana = 1001;
            int overflow = wand.addMana(wandStack, (Source)source, 1000);
            helper.assertTrue(overflow == 0, "Failed to add mana to wand, overflow is " + overflow);
            helper.assertTrue(wand.containsManaRaw(wandStack, (Source)source, 999), "Contains returned false for less than held");
            helper.assertTrue(wand.containsManaRaw(wandStack, (Source)source, 1000), "Contains returned false for exact held");
            helper.assertFalse(wand.containsManaRaw(wandStack, (Source)source, 1001), "Contains returned true for greater than held");
            helper.succeed();
        });
    }
}

