/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.items;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AbstractDispenserTest
extends AbstractBaseTest {
    public Collection<TestFunction> mana_arrows_fired_from_dispenser(String templateName) {
        Map<String, ManaArrowItem> testParams = ManaArrowItem.getManaArrows().stream().collect(Collectors.toMap(a -> a.getSource().getId().getPath(), a -> a));
        return TestUtils.createParameterizedTestFunctions("mana_arrows_fired_from_dispenser", templateName, testParams, (helper, arrow) -> {
            BlockPos dispenserPos = BlockPos.ZERO;
            helper.setBlock(dispenserPos, (BlockState)Blocks.DISPENSER.defaultBlockState().setValue((Property)DispenserBlock.FACING, (Comparable)Direction.NORTH));
            BlockPos buttonPos = dispenserPos.south();
            helper.setBlock(buttonPos, (BlockState)Blocks.OAK_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.NORTH));
            DispenserBlockEntity dispenserEntity = (DispenserBlockEntity)helper.getBlockEntity(dispenserPos);
            dispenserEntity.insertItem(new ItemStack((ItemLike)arrow));
            helper.assertBlockState(dispenserPos, state -> (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED) == false, () -> "Dispenser triggered before expected");
            helper.pressButton(buttonPos);
            helper.assertBlockState(dispenserPos, state -> (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED), () -> "Dispenser was not triggered as expected");
            BlockPos expectedArrowPos = dispenserPos.north();
            helper.succeedWhen(() -> {
                helper.assertItemEntityNotPresent((Item)arrow, expectedArrowPos, 1.0);
                helper.assertEntitiesPresent(EntityTypesPM.MANA_ARROW.get(), expectedArrowPos, 1, 1.0);
                helper.getEntities(EntityTypesPM.MANA_ARROW.get(), expectedArrowPos, 1.0).forEach(e -> helper.assertTrue(e.getSource().equals(arrow.getSource()), "Arrow entity source is not as expected: " + String.valueOf(e.getSource())));
            });
        });
    }
}

