/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.items;

import com.google.common.collect.BiMap;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;

public class AbstractBeeswaxTest
extends AbstractBaseTest {
    private static final Map<String, WaxableBlock> TEST_PARAMS = ((BiMap)HoneycombItem.WAXABLES.get()).entrySet().stream().collect(Collectors.toMap(e -> BuiltInRegistries.BLOCK.getKey((Object)((Block)e.getKey())).getPath(), e -> new WaxableBlock((Block)e.getKey(), (Block)e.getValue())));

    public Collection<TestFunction> apply_beeswax_directly(String templateName) {
        return TestUtils.createParameterizedTestFunctions("apply_beeswax_directly", templateName, TEST_PARAMS, (helper, waxable) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemsPM.BEESWAX.get()));
            helper.setBlock(BlockPos.ZERO, waxable.waxOff());
            UseOnContext context = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(BlockPos.ZERO.getCenter(), Direction.DOWN, helper.absolutePos(BlockPos.ZERO), true));
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem().useOn(context).indicateItemUse(), "Beeswax use did not succeed");
            helper.succeedIf(() -> helper.assertBlockState(BlockPos.ZERO, state -> state.is(waxable.waxOn()), () -> "Waxed block not found as expected"));
        });
    }

    public Collection<TestFunction> apply_beeswax_via_crafting(String templateName) {
        return TestUtils.createParameterizedTestFunctions("apply_beeswax_via_crafting", templateName, TEST_PARAMS, (helper, waxable) -> {
            CraftingInput craftingInput = CraftingInput.of((int)2, (int)1, List.of(new ItemStack((ItemLike)ItemsPM.BEESWAX.get()), new ItemStack((ItemLike)waxable.waxOff())));
            Optional outputOpt = helper.getLevel().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, (Level)helper.getLevel());
            helper.succeedIf(() -> {
                helper.assertTrue(outputOpt.isPresent(), "No recipe found");
                helper.assertTrue(((CraftingRecipe)((RecipeHolder)outputOpt.get()).value()).getResultItem((HolderLookup.Provider)helper.getLevel().registryAccess()).is(waxable.waxOn().asItem()), "Recipe output not as expected");
            });
        });
    }

    private record WaxableBlock(Block waxOff, Block waxOn) {
    }
}

