/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.ftux;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class AbstractFtuxTest
extends AbstractBaseTest {
    public Collection<TestFunction> font_discovery_tests(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"earth", (Object)((Block)BlocksPM.ANCIENT_FONT_EARTH.get())).put((Object)"sea", (Object)((Block)BlocksPM.ANCIENT_FONT_SEA.get())).put((Object)"sky", (Object)((Block)BlocksPM.ANCIENT_FONT_SKY.get())).put((Object)"sun", (Object)((Block)BlocksPM.ANCIENT_FONT_SUN.get())).put((Object)"moon", (Object)((Block)BlocksPM.ANCIENT_FONT_MOON.get())).build();
        return TestUtils.createParameterizedTestFunctions("font_discovery_tests", templateName, testParams, (helper, block) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper, true);
            player.setPos(Vec3.atBottomCenterOf((Vec3i)helper.absolutePos(BlockPos.ZERO)));
            helper.assertFalse(ResearchManager.isResearchComplete((Player)player, ResearchEntries.FOUND_SHRINE), "Found Shrine research already present on new player");
            BlockPos fontPos = new BlockPos(1, 1, 1);
            helper.setBlock(fontPos, block);
            helper.assertBlockState(fontPos, state -> state.is(block), () -> "Test font not found!");
            helper.succeedWhen(() -> {
                helper.assertTrue(ResearchManager.isResearchComplete((Player)player, ResearchEntries.FOUND_SHRINE), "Found Shrine research not complete");
                helper.getLevel().getServer().getPlayerList().remove(player);
            });
        });
    }

    public void sleeping_after_shrine_grants_dream(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.assertTrue(ResearchManager.completeResearch(player, ResearchEntries.FOUND_SHRINE), "Failed to grant prerequisite research");
        helper.assertFalse(ResearchManager.isResearchComplete(player, ResearchEntries.GOT_DREAM), "Created player already marked as having had the dream");
        helper.assertTrue(player.getInventory().isEmpty(), "Fresh player inventory is not empty");
        BlockPos bedPos = new BlockPos(2, 2, 2);
        TestUtils.placeBed(helper, bedPos);
        helper.setNight();
        player.startSleepInBed(helper.absolutePos(bedPos));
        player.stopSleeping();
        helper.succeedWhen(() -> {
            helper.assertTrue(ResearchManager.isResearchComplete(player, ResearchEntries.GOT_DREAM), "Got Dream research not complete");
            NonNullList<ItemStack> stacks = InventoryUtils.find(player, ItemTagsPM.STATIC_BOOKS);
            helper.assertTrue(stacks.size() == 1, "No potential Dream Journals found");
            helper.assertTrue(stacks.stream().anyMatch(stack -> StaticBookItem.getBookId(stack).filter(id -> BooksPM.DREAM_JOURNAL.equals(id)).isPresent() && StaticBookItem.getBookLanguageId(stack).filter(id -> BookLanguagesPM.DEFAULT.equals(id)).isPresent() && StaticBookItem.getAuthor(stack).equals((Object)player.getName())), "Dream Journal components are not a match to expected");
        });
    }

    public Collection<TestFunction> mundane_wand_crafting_tests(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"earth", (Object)ItemsPM.ESSENCE_DUST_EARTH.get()).put((Object)"sea", (Object)ItemsPM.ESSENCE_DUST_SEA.get()).put((Object)"sky", (Object)ItemsPM.ESSENCE_DUST_SKY.get()).put((Object)"sun", (Object)ItemsPM.ESSENCE_DUST_SUN.get()).put((Object)"moon", (Object)ItemsPM.ESSENCE_DUST_MOON.get()).build();
        return TestUtils.createParameterizedTestFunctions("mundane_wand_crafting_tests", templateName, testParams, (helper, dust) -> {
            CraftingInput container = CraftingInput.of((int)2, (int)1, List.of(new ItemStack((ItemLike)Items.STICK), new ItemStack((ItemLike)dust)));
            Optional recipe = helper.getLevel().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)container, (Level)helper.getLevel());
            helper.assertTrue(recipe.isPresent(), "Recipe not found when expected");
            helper.assertTrue(((CraftingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)helper.getLevel().registryAccess()).is((Item)ItemsPM.MUNDANE_WAND.get()), "Recipe result does not match expectations");
            helper.succeed();
        });
    }

    public void transform_abort_gives_hint(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.assertTrue(ResearchManager.completeResearch(player, ResearchEntries.GOT_DREAM), "Failed to grant prerequisite research");
        helper.assertFalse(ResearchManager.isResearchComplete(player, ResearchEntries.WAND_TRANSFORM_HINT), "Newly created player already has sought research");
        ItemStack wandStack = new ItemStack((ItemLike)ItemsPM.MUNDANE_WAND.get());
        Item wandItem = wandStack.getItem();
        player.setItemInHand(InteractionHand.MAIN_HAND, wandStack);
        BlockPos pos = new BlockPos(1, 1, 1);
        helper.setBlock(pos, Blocks.BOOKSHELF);
        helper.assertBlockPresent(Blocks.BOOKSHELF, pos);
        helper.assertItemEntityNotPresent((Item)ItemsPM.GRIMOIRE.get(), pos, 1.0);
        BlockPos posAbs = helper.absolutePos(pos);
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)posAbs), Direction.UP, posAbs, false);
        UseOnContext useContext = new UseOnContext(player, InteractionHand.MAIN_HAND, blockHitResult);
        helper.assertTrue(Services.ITEMS.onItemUseFirst(wandItem, wandStack, useContext).equals((Object)InteractionResult.SUCCESS), "Failed to start using wand on block");
        int remainingTicks = wandItem.getUseDuration(wandStack, (LivingEntity)player);
        wandItem.releaseUsing(wandStack, (Level)helper.getLevel(), (LivingEntity)player, remainingTicks);
        helper.assertTrue(ResearchManager.isResearchComplete(player, ResearchEntries.WAND_TRANSFORM_HINT), "Sought research not found");
        helper.succeed();
    }

    public void transform_without_dream_does_nothing(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack wandStack = new ItemStack((ItemLike)ItemsPM.MUNDANE_WAND.get());
        Item wandItem = wandStack.getItem();
        player.setItemInHand(InteractionHand.MAIN_HAND, wandStack);
        BlockPos pos = new BlockPos(1, 1, 1);
        helper.setBlock(pos, Blocks.BOOKSHELF);
        helper.assertBlockPresent(Blocks.BOOKSHELF, pos);
        helper.assertItemEntityNotPresent((Item)ItemsPM.GRIMOIRE.get(), pos, 1.0);
        BlockPos posAbs = helper.absolutePos(pos);
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)posAbs), Direction.UP, posAbs, false);
        UseOnContext useContext = new UseOnContext(player, InteractionHand.MAIN_HAND, blockHitResult);
        helper.assertTrue(Services.ITEMS.onItemUseFirst(wandItem, wandStack, useContext).equals((Object)InteractionResult.PASS), "Failed to start using wand on block");
        MutableInt remainingTicks = new MutableInt(41);
        helper.onEachTick(() -> wandItem.onUseTick((Level)helper.getLevel(), (LivingEntity)player, wandStack, remainingTicks.decrementAndGet()));
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.BOOKSHELF, pos);
            helper.assertItemEntityNotPresent((Item)ItemsPM.GRIMOIRE.get(), pos, 1.0);
        });
    }

    public void transform_grimoire(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.assertTrue(ResearchManager.completeResearch(player, ResearchEntries.GOT_DREAM), "Failed to grant prerequisite research");
        ItemStack wandStack = new ItemStack((ItemLike)ItemsPM.MUNDANE_WAND.get());
        Item wandItem = wandStack.getItem();
        player.setItemInHand(InteractionHand.MAIN_HAND, wandStack);
        BlockPos pos = new BlockPos(1, 1, 1);
        helper.setBlock(pos, Blocks.BOOKSHELF);
        helper.assertBlockPresent(Blocks.BOOKSHELF, pos);
        helper.assertItemEntityNotPresent((Item)ItemsPM.GRIMOIRE.get(), pos, 1.0);
        BlockPos posAbs = helper.absolutePos(pos);
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)posAbs), Direction.UP, posAbs, false);
        UseOnContext useContext = new UseOnContext(player, InteractionHand.MAIN_HAND, blockHitResult);
        helper.assertTrue(Services.ITEMS.onItemUseFirst(wandItem, wandStack, useContext).equals((Object)InteractionResult.SUCCESS), "Failed to start using wand on block");
        MutableInt remainingTicks = new MutableInt(wandItem.getUseDuration(wandStack, (LivingEntity)player));
        helper.onEachTick(() -> wandItem.onUseTick((Level)helper.getLevel(), (LivingEntity)player, wandStack, remainingTicks.decrementAndGet()));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.BOOKSHELF, pos);
            helper.assertItemEntityPresent((Item)ItemsPM.GRIMOIRE.get(), pos, 1.0);
        });
    }
}

