/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.enchantments;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.loot.LootModifiers;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AbstractRitualEnchantmentTest
extends AbstractBaseTest {
    public Collection<TestFunction> essence_thief(String templateName) {
        Map<String, Integer> testParams = IntStream.rangeClosed(1, 4).boxed().collect(Collectors.toMap(i -> "level" + i, i -> i));
        return TestUtils.createParameterizedTestFunctions("essence_thief", templateName, testParams, (helper, enchLevel) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack swordStack = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
            Holder.Reference enchantment = helper.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentsPM.ESSENCE_THIEF);
            swordStack.enchant((Holder)enchantment, enchLevel.intValue());
            player.setItemInHand(InteractionHand.MAIN_HAND, swordStack);
            Cow target = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, BlockPos.ZERO);
            LootParams lootParams = new LootParams.Builder(helper.getLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ENCHANTMENT_LEVEL, enchLevel).withParameter(LootContextParams.ORIGIN, (Object)target.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)player.damageSources().playerAttack((Player)player)).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).create(LootContextParamSets.ENCHANTED_DAMAGE);
            LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
            ObjectArrayList initialLoot = new ObjectArrayList();
            ObjectArrayList<ItemStack> actualLoot = LootModifiers.essenceThief((ObjectArrayList<ItemStack>)initialLoot, lootContext);
            helper.assertTrue(actualLoot.size() == 1, "Modified loot does not contain exactly one item");
            ItemStack stack = (ItemStack)actualLoot.getFirst();
            helper.assertTrue(stack.getCount() == 1, "Modified loot stack does not have a count of one");
            EssenceItem essenceItem = AbstractRitualEnchantmentTest.assertInstanceOf(helper, stack.getItem(), EssenceItem.class, "Loot item is not essence");
            EssenceType expectedEssenceType = switch (enchLevel) {
                case 1 -> EssenceType.DUST;
                case 2 -> EssenceType.SHARD;
                case 3 -> EssenceType.CRYSTAL;
                case 4 -> EssenceType.CLUSTER;
                default -> throw new IllegalStateException("Unexpected value: " + enchLevel);
            };
            helper.assertTrue(essenceItem.getEssenceType().equals((Object)expectedEssenceType), "Modified loot essence is not of expected grade");
            helper.assertTrue(essenceItem.getSource().equals(Sources.BLOOD), "Modified loot essence is not of expected source");
            helper.succeed();
        });
    }
}

