/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.enchantments;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class AbstractCasterEnchantingTest
extends AbstractBaseTest {
    public Collection<TestFunction> caster_enchanting_tests(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"mundane_wand", (Object)ItemsPM.MUNDANE_WAND.get()).put((Object)"modular_wand", (Object)ItemsPM.MODULAR_WAND.get()).put((Object)"modular_staff", (Object)ItemsPM.MODULAR_STAFF.get()).build();
        return TestUtils.createParameterizedTestFunctions("caster_enchanting_tests", templateName, testParams, (helper, item) -> {
            Optional possibleEnchantsOpt = helper.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
            helper.assertTrue(possibleEnchantsOpt.isPresent(), "No possible enchantments found for table");
            ItemStack casterStack = new ItemStack((ItemLike)item);
            if (item instanceof IHasWandComponents) {
                IHasWandComponents hasComponents = (IHasWandComponents)item;
                hasComponents.setWandCore(casterStack, WandCore.PRIMAL);
                hasComponents.setWandCap(casterStack, WandCap.HEXIUM);
                hasComponents.setWandGem(casterStack, WandGem.WIZARD);
            }
            List enchList = EnchantmentHelper.selectEnchantment((RandomSource)helper.getLevel().random, (ItemStack)casterStack, (int)30, (Stream)((HolderSet.Named)possibleEnchantsOpt.get()).stream());
            helper.assertFalse(enchList.isEmpty(), "No enchantments found for caster stack");
            helper.succeed();
        });
    }
}

