/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.crafting;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.RunecarvingTableMenu;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.tiles.crafting.RunecarvingTableTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractRunecarvingTest
extends AbstractBaseTest {
    public void craft_works(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        ResearchManager.forceGrantWithAllParents((Player)player, ResearchEntries.BASIC_RUNEWORKING);
        helper.assertTrue(ExpertiseManager.getValue((Player)player, ResearchDisciplines.RUNEWORKING).orElse(-1) == 0, "Expected starting expertise is not zero for test player");
        BlockPos tablePos = new BlockPos(1, 1, 1);
        helper.setBlock(tablePos, (Block)BlocksPM.RUNECARVING_TABLE.get());
        helper.assertBlockPresent((Block)BlocksPM.RUNECARVING_TABLE.get(), tablePos);
        BlockEntity baseTile = helper.getBlockEntity(tablePos);
        RunecarvingTableTileEntity tile = AbstractRunecarvingTest.assertInstanceOf(helper, baseTile, RunecarvingTableTileEntity.class, "Block entity not of expected type");
        tile.setItem(0, 0, new ItemStack((ItemLike)Items.STONE_SLAB));
        helper.assertTrue(tile.getItem(0, 0).is(Items.STONE_SLAB), "Stone slab material not properly set");
        tile.setItem(0, 1, new ItemStack((ItemLike)Items.LAPIS_LAZULI));
        helper.assertTrue(tile.getItem(0, 1).is(Items.LAPIS_LAZULI), "Lapis lazuli material not properly set");
        Services.PLAYER.openMenu(player, tile, tablePos);
        RunecarvingTableMenu menu = AbstractRunecarvingTest.assertInstanceOf(helper, player.containerMenu, RunecarvingTableMenu.class, "Menu not of expected type");
        helper.assertTrue(menu.getRecipeListSize() == 1, "Recipe list not as expected in runecarving menu");
        helper.assertTrue(menu.clickMenuButton((Player)player, 0), "Recipe selection failed");
        ItemStack output = menu.quickMoveStack((Player)player, 2);
        helper.assertTrue(output.is(ItemsPM.RUNE_UNATTUNED.get()), "Output item not of expected type");
        helper.assertTrue(tile.getItem(0, 0).isEmpty(), "Stone slab material stack not empty");
        helper.assertTrue(tile.getItem(0, 1).isEmpty(), "Lapis lazuli material stack not empty");
        helper.assertTrue(ExpertiseManager.getValue((Player)player, ResearchDisciplines.RUNEWORKING).orElse(-1) == 5, "Final expertise is not as expected for test player");
        helper.succeed();
    }
}

