/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.crafting;

import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import java.util.List;
import java.util.Optional;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AbstractCraftingRequirementsTest
extends AbstractBaseTest {
    public void arcane_recipe(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        CraftingInput container = CraftingInput.of((int)3, (int)1, List.of(new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)ItemsPM.REFINED_SALT.get()), new ItemStack((ItemLike)ItemsPM.ESSENCE_DUST_EARTH.get())));
        Optional recipe = helper.getLevel().getRecipeManager().getRecipeFor(RecipeTypesPM.ARCANE_CRAFTING.get(), (RecipeInput)container, (Level)helper.getLevel());
        helper.assertTrue(recipe.isPresent(), "Recipe not found when expected");
        Optional reqOpt = ((IArcaneRecipe)((RecipeHolder)recipe.get()).value()).getRequirement();
        helper.assertTrue(reqOpt.isPresent(), "Recipe requirement not found when expected");
        helper.assertFalse(((AbstractRequirement)reqOpt.get()).isMetBy(player), "Player meets requirement without research");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.MANA_SALTS);
        helper.assertTrue(((AbstractRequirement)reqOpt.get()).isMetBy(player), "Player does not meet requirement after being granted required research");
        helper.succeed();
    }

    public void ritual_recipe(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        CraftingInput container = CraftingInput.of((int)3, (int)1, List.of(new ItemStack((ItemLike)Items.APPLE), new ItemStack((ItemLike)Items.HONEY_BOTTLE), new ItemStack((ItemLike)ItemsPM.MANA_SALTS.get())));
        Optional recipe = helper.getLevel().getRecipeManager().getRecipeFor(RecipeTypesPM.RITUAL.get(), (RecipeInput)container, (Level)helper.getLevel());
        helper.assertTrue(recipe.isPresent(), "Recipe not found when expected");
        Optional reqOpt = ((IRitualRecipe)((RecipeHolder)recipe.get()).value()).getRequirement();
        helper.assertTrue(reqOpt.isPresent(), "Recipe requirement not found when expected");
        helper.assertFalse(((AbstractRequirement)reqOpt.get()).isMetBy(player), "Player meets requirement without research");
        ResearchManager.forceGrantWithAllParents(player, ResearchEntries.MANAFRUIT);
        helper.assertTrue(((AbstractRequirement)reqOpt.get()).isMetBy(player), "Player does not meet requirement after being granted required research");
        helper.succeed();
    }
}

