/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.crafting;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.crafting.AbstractCalcinatorTileEntity;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AbstractCalcinatorTest
extends AbstractBaseTest {
    public void calcinator_works(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        ResearchManager.forceGrantWithAllParents((Player)player, ResearchEntries.BASIC_ALCHEMY);
        AffinityManager.getInstance().setCachedItemResult(new ItemStack((ItemLike)Items.COBBLESTONE), CompletableFuture.completedFuture(SourceList.builder().withEarth(5).build()));
        BlockPos calcinatorPos = new BlockPos(1, 1, 1);
        helper.setBlock(calcinatorPos, (Block)BlocksPM.CALCINATOR_BASIC.get());
        helper.assertBlockPresent((Block)BlocksPM.CALCINATOR_BASIC.get(), calcinatorPos);
        AbstractCalcinatorTileEntity calcinator = AbstractCalcinatorTest.assertInstanceOf(helper, helper.getBlockEntity(calcinatorPos), AbstractCalcinatorTileEntity.class, "Block entity was not a calcinator");
        calcinator.setTileOwner((Player)player);
        calcinator.setItem(0, 0, new ItemStack((ItemLike)Items.COBBLESTONE));
        helper.assertTrue(calcinator.getItem(0, 0).is(Items.COBBLESTONE), "Input cobblestone not set correctly");
        calcinator.setItem(1, 0, new ItemStack((ItemLike)Items.CHARCOAL));
        helper.assertTrue(calcinator.getItem(1, 0).is(Items.CHARCOAL), "Input fuel not set correctly");
        for (int index = 0; index < 9; ++index) {
            helper.assertTrue(calcinator.getItem(2, index).isEmpty(), "Output slot " + index + " is not empty before calcination");
        }
        calcinator.doCalcination();
        helper.assertTrue(calcinator.getItem(0, 0).isEmpty(), "Input item stack not empty after calcination");
        ItemStack outputStack = calcinator.getItem(2, 0);
        helper.assertTrue(outputStack.is((Item)ItemsPM.ESSENCE_DUST_EARTH.get()), "Output is not Earth Dust as expected");
        helper.assertTrue(outputStack.getCount() == 1, "Output stack count is not one as expected");
        helper.succeed();
    }

    public void calcinator_works_without_player_present(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, false);
        ResearchManager.forceGrantWithAllParents((Player)player, ResearchEntries.BASIC_ALCHEMY);
        AffinityManager.getInstance().setCachedItemResult(new ItemStack((ItemLike)Items.COBBLESTONE), CompletableFuture.completedFuture(SourceList.builder().withEarth(5).build()));
        BlockPos calcinatorPos = new BlockPos(1, 1, 1);
        helper.setBlock(calcinatorPos, (Block)BlocksPM.CALCINATOR_BASIC.get());
        helper.assertBlockPresent((Block)BlocksPM.CALCINATOR_BASIC.get(), calcinatorPos);
        AbstractCalcinatorTileEntity calcinator = AbstractCalcinatorTest.assertInstanceOf(helper, helper.getBlockEntity(calcinatorPos), AbstractCalcinatorTileEntity.class, "Block entity was not a calcinator");
        calcinator.setTileOwner((Player)player);
        calcinator.setItem(0, 0, new ItemStack((ItemLike)Items.COBBLESTONE));
        helper.assertTrue(calcinator.getItem(0, 0).is(Items.COBBLESTONE), "Input cobblestone not set correctly");
        calcinator.setItem(1, 0, new ItemStack((ItemLike)Items.CHARCOAL));
        helper.assertTrue(calcinator.getItem(1, 0).is(Items.CHARCOAL), "Input fuel not set correctly");
        for (int index = 0; index < 9; ++index) {
            helper.assertTrue(calcinator.getItem(2, index).isEmpty(), "Output slot " + index + " is not empty before calcination");
        }
        calcinator.doCalcination();
        helper.assertTrue(calcinator.getItem(0, 0).isEmpty(), "Input item stack not empty after calcination");
        ItemStack outputStack = calcinator.getItem(2, 0);
        helper.assertTrue(outputStack.is((Item)ItemsPM.ESSENCE_DUST_EARTH.get()), "Output is not Earth Dust as expected");
        helper.assertTrue(outputStack.getCount() == 1, "Output stack count is not one as expected");
        helper.succeed();
    }
}

