/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.crafting;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.ArcaneWorkbenchMenu;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class AbstractArcaneWorkbenchTest
extends AbstractBaseTest {
    public void arcane_workbench_craft_works(final GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        ResearchManager.forceGrantWithAllParents((Player)player, ResearchEntries.MANA_SALTS);
        helper.assertTrue(ExpertiseManager.getValue((Player)player, ResearchDisciplines.MANAWEAVING).orElse(-1) == 0, "Expected starting expertise is not zero for test player");
        final BlockPos tablePos = new BlockPos(1, 1, 1);
        helper.setBlock(tablePos, (Block)BlocksPM.ARCANE_WORKBENCH.get());
        helper.assertBlockPresent((Block)BlocksPM.ARCANE_WORKBENCH.get(), tablePos);
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                return new ArcaneWorkbenchMenu(windowId, inv, ContainerLevelAccess.create((Level)helper.getLevel(), (BlockPos)helper.absolutePos(tablePos)));
            }

            @NotNull
            public Component getDisplayName() {
                return Component.literal((String)"Arcane Workbench");
            }
        };
        player.openMenu(menuProvider);
        ArcaneWorkbenchMenu menu = AbstractArcaneWorkbenchTest.assertInstanceOf(helper, player.containerMenu, ArcaneWorkbenchMenu.class, "Menu not of expected type");
        ((Slot)menu.getSlots().get(1)).safeInsert(new ItemStack((ItemLike)Items.REDSTONE));
        ((Slot)menu.getSlots().get(2)).safeInsert(new ItemStack((ItemLike)ItemsPM.REFINED_SALT.get()));
        ((Slot)menu.getSlots().get(3)).safeInsert(new ItemStack((ItemLike)ItemsPM.ESSENCE_DUST_EARTH.get()));
        ItemStack wandStack = ItemsPM.MUNDANE_WAND.get().getDefaultInstance();
        IWand wand = AbstractArcaneWorkbenchTest.assertInstanceOf(helper, wandStack.getItem(), IWand.class, "Wand not of expected type");
        Sources.getAll().forEach(s -> {
            int maxCentimana = wand.getMaxMana(wandStack, (Source)s);
            wand.addMana(wandStack, (Source)s, maxCentimana);
            helper.assertValueEqual((Object)wand.getMana(wandStack, (Source)s), (Object)maxCentimana, "Wand starting mana for " + String.valueOf(s.getId()));
        });
        helper.assertFalse(wand.getAllMana(wandStack).isEmpty(), "Wand mana is empty after adding mana");
        ((Slot)menu.getSlots().get(10)).safeInsert(wandStack);
        ItemStack slottedWandStack = ((Slot)menu.getSlots().get(10)).getItem();
        helper.assertFalse(wand.getAllMana(slottedWandStack).isEmpty(), "Wand mana is empty before taking recipe output");
        ItemStack output = menu.quickMoveStack((Player)player, 0);
        helper.assertTrue(output.is(ItemsPM.MANA_SALTS.get()), "Output item not of expected type");
        helper.assertFalse(wand.getAllMana(slottedWandStack).isEmpty(), "Wand mana is empty after taking recipe output");
        helper.assertFalse(((Slot)menu.getSlots().get(1)).hasItem(), "Redstone material stack not empty");
        helper.assertFalse(((Slot)menu.getSlots().get(2)).hasItem(), "Salt material stack not empty");
        helper.assertFalse(((Slot)menu.getSlots().get(3)).hasItem(), "Essence material stack not empty");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.EARTH), (Object)2000, "Wand remaining earth mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.SEA), (Object)2000, "Wand remaining sea mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.SKY), (Object)2000, "Wand remaining sky mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.SUN), (Object)2000, "Wand remaining sun mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.MOON), (Object)2000, "Wand remaining moon mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.BLOOD), (Object)2500, "Wand remaining blood mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.INFERNAL), (Object)2500, "Wand remaining infernal mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.VOID), (Object)2500, "Wand remaining void mana");
        helper.assertValueEqual((Object)wand.getMana(slottedWandStack, Sources.HALLOWED), (Object)2500, "Wand remaining hallowed mana");
        helper.assertTrue(ExpertiseManager.getValue((Player)player, ResearchDisciplines.MANAWEAVING).orElse(-1) == 5, "Final expertise is not as expected for test player");
        helper.succeed();
    }
}

