/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test.attunements;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.attunements.AttunementAttributeModifiers;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.events.CombatEvents;
import com.verdantartifice.primalmagick.common.events.PlayerEvents;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.ModularWandItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.AbstractBaseTest;
import com.verdantartifice.primalmagick.test.TestRandomSource;
import com.verdantartifice.primalmagick.test.TestUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableFloat;

public class AbstractAttunementTest
extends AbstractBaseTest {
    public void beforeDayBatch(ServerLevel level) {
        level.setDayTime(6000L);
        level.tick(() -> true);
    }

    public void beforeNightBatch(ServerLevel level) {
        level.setDayTime(18000L);
        level.tick(() -> true);
    }

    public Collection<TestFunction> minor_attunement_gives_mana_discount(String templateName) {
        Map<String, Source> testParams = Sources.streamSorted().collect(Collectors.toMap(source -> source.getId().getPath(), source -> source));
        return TestUtils.createParameterizedTestFunctions("minor_attunement_gives_mana_discount", templateName, testParams, (helper, source) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            ItemStack wandStack = new ItemStack((ItemLike)ItemsPM.MODULAR_WAND.get());
            ModularWandItem wandItem = AbstractAttunementTest.assertInstanceOf(helper, wandStack.getItem(), ModularWandItem.class, "Wand is not of the expected type");
            wandItem.setWandCore(wandStack, WandCore.HEARTWOOD);
            wandItem.setWandCap(wandStack, WandCap.GOLD);
            wandItem.setWandGem(wandStack, WandGem.ADEPT);
            Sources.streamSorted().forEach(s -> {
                int actual = wandItem.getTotalCostModifier(wandStack, (Player)player, (Source)s, (HolderLookup.Provider)helper.getLevel().registryAccess());
                helper.assertTrue(actual == 20, "Base wand cost modifier is not as expected for source " + String.valueOf(s.getId()));
            });
            AttunementManager.setAttunement((Player)player, source, AttunementType.PERMANENT, AttunementThreshold.MINOR.getValue());
            Sources.streamSorted().forEach(s -> {
                int expected = s.equals(source) ? 25 : 20;
                int actual = wandItem.getTotalCostModifier(wandStack, (Player)player, (Source)s, (HolderLookup.Provider)helper.getLevel().registryAccess());
                helper.assertTrue(actual == expected, "Final wand cost modifier is not as expected for source " + String.valueOf(s.getId()) + ": " + actual);
            });
            helper.succeed();
        });
    }

    public void lesser_earth_attunement_gives_haste_modifier(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.getAttributes().hasModifier(Attributes.ATTACK_SPEED, AttunementAttributeModifiers.EARTH_LESSER_ID), "Player has unexpected attribute modifier");
        AttunementManager.setAttunement((Player)player, Sources.EARTH, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        helper.assertTrue(player.getAttributes().hasModifier(Attributes.ATTACK_SPEED, AttunementAttributeModifiers.EARTH_LESSER_ID), "Player does not have expected attribute modifier");
        helper.succeed();
    }

    public void greater_earth_attunement_gives_step_height_modifier(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.getAttributes().hasModifier(Attributes.STEP_HEIGHT, AttunementAttributeModifiers.EARTH_GREATER_ID), "Player has unexpected attribute modifier");
        AttunementManager.setAttunement((Player)player, Sources.EARTH, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        PlayerEvents.applyAttunementBuffs(player);
        helper.assertTrue(player.getAttributes().hasModifier(Attributes.STEP_HEIGHT, AttunementAttributeModifiers.EARTH_GREATER_ID), "Player does not have expected attribute modifier");
        helper.succeed();
    }

    public void lesser_sea_attunement_gives_increased_swim_speed(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.getAttributes().hasModifier(Services.ATTRIBUTES.swimSpeed(), AttunementAttributeModifiers.SEA_LESSER_ID), "Player has unexpected attribute modifier");
        AttunementManager.setAttunement((Player)player, Sources.SEA, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        helper.assertTrue(player.getAttributes().hasModifier(Services.ATTRIBUTES.swimSpeed(), AttunementAttributeModifiers.SEA_LESSER_ID), "Player does not have expected attribute modifier");
        helper.succeed();
    }

    public void greater_sea_attunement_gives_water_breathing(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.hasEffect(MobEffects.WATER_BREATHING), "Player has unexpected effect");
        AttunementManager.setAttunement((Player)player, Sources.SEA, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        PlayerEvents.applyAttunementBuffs(player);
        helper.assertTrue(player.hasEffect(MobEffects.WATER_BREATHING), "Player does not have expected effect");
        helper.succeed();
    }

    public void lesser_sky_attunement_gives_movement_speed_modifier(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.getAttributes().hasModifier(Attributes.MOVEMENT_SPEED, AttunementAttributeModifiers.SKY_LESSER_ID), "Player has unexpected attribute modifier");
        AttunementManager.setAttunement((Player)player, Sources.SKY, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        helper.assertTrue(player.getAttributes().hasModifier(Attributes.MOVEMENT_SPEED, AttunementAttributeModifiers.SKY_LESSER_ID), "Player does not have expected attribute modifier");
        helper.succeed();
    }

    public void lesser_sky_attunement_reduces_fall_damage_taken(GameTestHelper helper) {
        float expectedDamage = 8.0f;
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.hurt(player.damageSources().fall(), 8.0f);
        float actualDamage = player.getMaxHealth() - player.getHealth();
        helper.assertTrue(actualDamage == 8.0f, "Player did not take expected damage without attunement: " + actualDamage);
        player.setHealth(player.getMaxHealth());
        AttunementManager.setAttunement(player, Sources.SKY, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        player.hurt(player.damageSources().fall(), 8.0f);
        actualDamage = player.getMaxHealth() - player.getHealth();
        helper.assertTrue(actualDamage < 8.0f, "Player did not take reduced damage with attunement: " + actualDamage);
        helper.succeed();
    }

    public void greater_sky_attunement_increases_jump_strength(GameTestHelper helper) {
        ServerPlayer player1 = this.makeMockServerPlayer(helper);
        double expectedJumpStrength = player1.getAttributeValue(Attributes.JUMP_STRENGTH);
        player1.jumpFromGround();
        helper.assertTrue(player1.getDeltaMovement().y() == expectedJumpStrength, "Player did not have expected starting jump strength");
        player1.discard();
        ServerPlayer player2 = this.makeMockServerPlayer(helper);
        AttunementManager.setAttunement((Player)player2, Sources.SKY, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        player2.jumpFromGround();
        helper.assertTrue(player2.getDeltaMovement().y() > expectedJumpStrength, "Player did not have boosted jump strength as expected");
        helper.succeed();
    }

    public void lesser_sun_attunement_regenerates_food_during_day(GameTestHelper helper) {
        int startFood = 6;
        int endFood = 7;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.setDayTime(0);
        helper.getLevel().tick(() -> true);
        player.getFoodData().setFoodLevel(6);
        helper.assertTrue(player.getFoodData().getFoodLevel() == 6, "Player does not have expected food without attunement");
        AttunementManager.setAttunement((Player)player, Sources.SUN, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        PlayerEvents.handlePhotosynthesis(player);
        int actualFood = player.getFoodData().getFoodLevel();
        helper.assertTrue(actualFood == 7, "Player does not have expected food with attunement: " + actualFood);
        helper.succeed();
    }

    public void lesser_sun_attunement_does_not_regenerate_food_during_night(GameTestHelper helper) {
        int startFood = 6;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.setNight();
        helper.getLevel().tick(() -> true);
        player.getFoodData().setFoodLevel(6);
        helper.assertTrue(player.getFoodData().getFoodLevel() == 6, "Player does not have expected food without attunement");
        AttunementManager.setAttunement((Player)player, Sources.SUN, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        PlayerEvents.handlePhotosynthesis(player);
        helper.assertTrue(player.getFoodData().getFoodLevel() == 6, "Player does not have expected food with attunement");
        helper.succeed();
    }

    public void greater_sun_attunement_does_not_drop_glow_fields_during_day(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        BlockPos playerPos = player.blockPosition();
        TestRandomSource rng = TestRandomSource.builder().setDouble(0.0).build();
        LogUtils.getLogger().warn("Block light level before attunement during day: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        helper.assertFalse(helper.getLevel().getBlockState(playerPos).is((Block)BlocksPM.GLOW_FIELD.get()), "Glow field present when it shouldn't be before attunement");
        AttunementManager.setAttunement((Player)player, Sources.SUN, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        LogUtils.getLogger().warn("Block light level after attunement during day: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        PlayerEvents.handleLightDrop(player, rng);
        LogUtils.getLogger().warn("Block light level after light drop during day: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        helper.assertFalse(helper.getLevel().getBlockState(playerPos).is((Block)BlocksPM.GLOW_FIELD.get()), "Glow field present when it shouldn't be after attunement");
        helper.succeed();
    }

    public void greater_sun_attunement_drops_glow_fields_during_night(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        BlockPos playerPos = player.blockPosition();
        TestRandomSource rng = TestRandomSource.builder().setDouble(0.0).build();
        LogUtils.getLogger().warn("Block light level before attunement during night: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        helper.assertFalse(helper.getLevel().getBlockState(playerPos).is((Block)BlocksPM.GLOW_FIELD.get()), "Glow field present when it shouldn't be before attunement");
        AttunementManager.setAttunement((Player)player, Sources.SUN, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        LogUtils.getLogger().warn("Block light level after attunement during night: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        PlayerEvents.handleLightDrop(player, rng);
        LogUtils.getLogger().warn("Block light level after light drop during night: {}", (Object)helper.getLevel().getBrightness(LightLayer.BLOCK, playerPos));
        helper.assertTrue(helper.getLevel().getBlockState(playerPos).is((Block)BlocksPM.GLOW_FIELD.get()), "Glow field missing after attunement");
        helper.succeed();
    }

    public void lesser_moon_attunement_grants_invisibility_chance_on_hurt(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        TestRandomSource rng = TestRandomSource.builder().setDouble(0.0).setGaussian(1.0).build();
        CombatEvents.grantInvisibilityOnHurt((Player)player, (Level)helper.getLevel(), rng);
        helper.assertFalse(player.hasEffect(MobEffects.INVISIBILITY), "Player has invisibility when they shouldn't");
        AttunementManager.setAttunement((Player)player, Sources.MOON, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        CombatEvents.grantInvisibilityOnHurt((Player)player, (Level)helper.getLevel(), rng);
        helper.assertTrue(player.hasEffect(MobEffects.INVISIBILITY), "Player does not have invisibility with attunement");
        helper.succeed();
    }

    public void greater_moon_attunement_grants_night_vision(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(player.hasEffect(MobEffects.NIGHT_VISION), "Player has unexpected effect");
        AttunementManager.setAttunement((Player)player, Sources.MOON, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        PlayerEvents.applyAttunementBuffs(player);
        helper.assertTrue(player.hasEffect(MobEffects.NIGHT_VISION), "Player does not have expected effect");
        helper.succeed();
    }

    public void lesser_blood_attunement_inflicts_bleeding(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        Cow target = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, player.position());
        MutableFloat damage1 = new MutableFloat(2.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage1).getValue(), arg_0 -> ((MutableFloat)damage1).setValue(arg_0));
        helper.assertFalse(target.hasEffect(Objects.requireNonNull(EffectsPM.BLEEDING.getHolder())), "Target has effect before attunement");
        AttunementManager.setAttunement((Player)player, Sources.BLOOD, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        MutableFloat damage2 = new MutableFloat(2.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage2).getValue(), arg_0 -> ((MutableFloat)damage2).setValue(arg_0));
        helper.assertTrue(target.hasEffect(Objects.requireNonNull(EffectsPM.BLEEDING.getHolder())), "Target does not have effect after attunement");
        helper.succeed();
    }

    public void greater_blood_attunement_grants_chance_at_self_healing(GameTestHelper helper) {
        float startHealth = 5.0f;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        player.setHealth(5.0f);
        Cow target = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, player.position());
        MutableFloat damage1 = new MutableFloat(12.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage1).getValue(), arg_0 -> ((MutableFloat)damage1).setValue(arg_0));
        helper.assertTrue(player.getHealth() == 5.0f, "Player does not have expected health before attunement");
        AttunementManager.setAttunement((Player)player, Sources.BLOOD, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        MutableFloat damage2 = new MutableFloat(12.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage2).getValue(), arg_0 -> ((MutableFloat)damage2).setValue(arg_0));
        float expected = 6.0f;
        float actual = player.getHealth();
        helper.assertTrue(actual == 6.0f, "Player does not have expected health after attunement: " + actual);
        helper.succeed();
    }

    public void lesser_infernal_attunement_fires_hellish_chain_on_attack(GameTestHelper helper) {
        float damage = 4.0f;
        ServerPlayer player = this.makeMockServerPlayer(helper, true);
        Cow target1 = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, player.blockPosition().north());
        Cow target2 = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, player.blockPosition().west());
        CombatEvents.onAttack((LivingEntity)target1, player.damageSources().playerAttack((Player)player), 4.0f);
        helper.assertTrue(target2.getHealth() == target2.getMaxHealth(), "Secondary target hurt before attunement");
        AttunementManager.setAttunement((Player)player, Sources.INFERNAL, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        CombatEvents.onAttack((LivingEntity)target1, player.damageSources().playerAttack((Player)player), 4.0f);
        float expected = target2.getMaxHealth() - 2.0f;
        float actual = target2.getHealth();
        helper.assertTrue(expected == actual, "Secondary target not at expected health after attunement: " + actual);
        helper.succeed();
    }

    public Collection<TestFunction> greater_infernal_attunement_prevents_fire_damage(String templateName) {
        ImmutableMap testParams = ImmutableMap.builder().put((Object)"inFire", registryAccess -> new DamageSources(registryAccess).inFire()).put((Object)"onFire", registryAccess -> new DamageSources(registryAccess).onFire()).put((Object)"lava", registryAccess -> new DamageSources(registryAccess).lava()).put((Object)"hotFloor", registryAccess -> new DamageSources(registryAccess).hotFloor()).put((Object)"infernalSorcery", registryAccess -> DamageSourcesPM.sorcery(registryAccess, Sources.INFERNAL, null)).build();
        return TestUtils.createParameterizedTestFunctions("greater_infernal_attunement_prevents_fire_damage", templateName, testParams, (helper, func) -> {
            ServerPlayer player = this.makeMockServerPlayer((GameTestHelper)helper);
            DamageSource damageSource = (DamageSource)func.apply(helper.getLevel().registryAccess());
            helper.assertFalse(CombatEvents.onAttack((LivingEntity)player, damageSource, 5.0f), "Damage being cancelled before attunement");
            AttunementManager.setAttunement((Player)player, Sources.INFERNAL, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
            helper.assertTrue(CombatEvents.onAttack((LivingEntity)player, damageSource, 5.0f), "Damage not being cancelled after attunement");
            helper.succeed();
        });
    }

    public void lesser_void_attunement_reduces_damage_taken(GameTestHelper helper) {
        float startingDamage = 5.0f;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        Wolf attacker = (Wolf)helper.spawnWithNoFreeWill(EntityType.WOLF, player.position());
        MutableFloat damage1 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)player, player.damageSources().mobAttack((LivingEntity)attacker), () -> ((MutableFloat)damage1).getValue(), arg_0 -> ((MutableFloat)damage1).setValue(arg_0));
        helper.assertTrue(damage1.getValue().floatValue() == 5.0f, "Damage modified without attunement");
        AttunementManager.setAttunement((Player)player, Sources.VOID, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        MutableFloat damage2 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)player, player.damageSources().mobAttack((LivingEntity)attacker), () -> ((MutableFloat)damage2).getValue(), arg_0 -> ((MutableFloat)damage2).setValue(arg_0));
        float actual = damage2.getValue().floatValue();
        float expected = 4.5f;
        helper.assertTrue(4.5f == actual, "Damage not modified as expected after attunement");
        helper.succeed();
    }

    public void greater_void_attunement_increases_damage_dealt(GameTestHelper helper) {
        float startingDamage = 5.0f;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        Cow target = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, player.position());
        MutableFloat damage1 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage1).getValue(), arg_0 -> ((MutableFloat)damage1).setValue(arg_0));
        helper.assertTrue(damage1.getValue().floatValue() == 5.0f, "Damage modified without attunement");
        AttunementManager.setAttunement((Player)player, Sources.VOID, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        MutableFloat damage2 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage2).getValue(), arg_0 -> ((MutableFloat)damage2).setValue(arg_0));
        float actual = damage2.getValue().floatValue();
        float expected = 6.25f;
        helper.assertTrue(6.25f == actual, "Damage not modified as expected after attunement");
        helper.succeed();
    }

    public void lesser_hallowed_attunement_doubles_damage_dealt_to_undead(GameTestHelper helper) {
        float startingDamage = 5.0f;
        ServerPlayer player = this.makeMockServerPlayer(helper);
        Zombie target = (Zombie)helper.spawnWithNoFreeWill(EntityType.ZOMBIE, player.position());
        MutableFloat damage1 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage1).getValue(), arg_0 -> ((MutableFloat)damage1).setValue(arg_0));
        helper.assertTrue(damage1.getValue().floatValue() == 5.0f, "Damage modified without attunement");
        AttunementManager.setAttunement((Player)player, Sources.HALLOWED, AttunementType.PERMANENT, AttunementThreshold.LESSER.getValue());
        MutableFloat damage2 = new MutableFloat(5.0f);
        CombatEvents.onEntityHurt((LivingEntity)target, player.damageSources().playerAttack((Player)player), () -> ((MutableFloat)damage2).getValue(), arg_0 -> ((MutableFloat)damage2).setValue(arg_0));
        float actual = damage2.getValue().floatValue();
        float expected = 10.0f;
        helper.assertTrue(10.0f == actual, "Damage not modified as expected after attunement");
        helper.succeed();
    }

    public void greater_hallowed_attunement_prevents_death(GameTestHelper helper) {
        ServerPlayer player = this.makeMockServerPlayer(helper);
        helper.assertFalse(CombatEvents.onDeath((LivingEntity)player), "Death cancelled before attunement");
        helper.assertTrue(player.getActiveEffects().isEmpty(), "Player has unexpected effects before attunement");
        helper.assertTrue(Services.CAPABILITIES.cooldowns((Player)player).map(c -> c.getRemainingCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE)).orElse(0L) == 0L, "Player incurred a death save cooldown before attunement");
        AttunementManager.setAttunement((Player)player, Sources.HALLOWED, AttunementType.PERMANENT, AttunementThreshold.GREATER.getValue());
        helper.assertTrue(CombatEvents.onDeath((LivingEntity)player), "Death not cancelled after attunement");
        helper.assertTrue(player.hasEffect(MobEffects.REGENERATION), "Player missing regeneration effect after attunement");
        helper.assertTrue(player.hasEffect(MobEffects.ABSORPTION), "Player missing absorption effect after attunement");
        helper.assertTrue(player.hasEffect(Objects.requireNonNull(EffectsPM.WEAKENED_SOUL.getHolder())), "Player missing weakened soul effect after attunement");
        helper.assertTrue(Services.CAPABILITIES.cooldowns((Player)player).map(c -> c.getRemainingCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE)).orElse(0L) > 0L, "Player missing a death save cooldown after attunement");
        helper.succeed();
    }
}

