/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.test;

import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.test.TestOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.function.TriConsumer;

public class TestUtils {
    public static final String DEFAULT_BATCH = "defaultBatch";

    @Nullable
    private static String findPrefix(int stackDepth) {
        String callerClassName = StackWalker.getInstance().walk(s -> s.skip(stackDepth).findFirst()).map(f -> f.getClassName()).orElse(null);
        if (callerClassName != null) {
            try {
                Class<?> callerClass = Class.forName(callerClassName);
                return Services.TEST.getTestNamespace(callerClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private static String makeName(@Nullable String prefix, String group, String suffix) {
        return prefix == null ? String.join((CharSequence)".", group, suffix) : String.join((CharSequence)".", prefix, group, suffix);
    }

    private static String makeBatch(@Nullable String prefix, String batchName) {
        if (DEFAULT_BATCH.equals(batchName)) {
            return prefix == null ? batchName : prefix;
        }
        return prefix == null ? batchName : String.join((CharSequence)".", prefix, batchName);
    }

    public static TestFunction createTestFunction(String generatedGroupName, String nameSuffix, String templateName, Consumer<GameTestHelper> consumer) {
        return TestUtils.createTestFunctionInner(TestUtils.findPrefix(2), generatedGroupName, nameSuffix, TestOptions.builder(templateName).build(), consumer);
    }

    public static TestFunction createTestFunction(String generatedGroupName, String nameSuffix, TestOptions options, Consumer<GameTestHelper> consumer) {
        return TestUtils.createTestFunctionInner(TestUtils.findPrefix(2), generatedGroupName, nameSuffix, options, consumer);
    }

    private static TestFunction createTestFunctionInner(String prefix, String generatedGroupName, String nameSuffix, TestOptions options, Consumer<GameTestHelper> consumer) {
        String finalName = TestUtils.makeName(prefix, generatedGroupName, nameSuffix);
        String batch = TestUtils.makeBatch(prefix, options.batch());
        return new TestFunction(batch, finalName, options.template(), StructureUtils.getRotationForRotationSteps((int)options.rotationSteps()), options.timeoutTicks(), options.setupTicks(), options.required(), options.manualOnly(), options.requiredSuccesses(), options.attempts(), options.skyAccess(), consumer);
    }

    public static <T> Collection<TestFunction> createParameterizedTestFunctions(String generatedGroupName, String templateName, Map<String, T> params, BiConsumer<GameTestHelper, T> consumer) {
        return TestUtils.createParameterizedTestFunctionsInner(TestUtils.findPrefix(2), generatedGroupName, TestOptions.builder(templateName).build(), params, consumer);
    }

    public static <T> Collection<TestFunction> createParameterizedTestFunctions(String generatedGroupName, TestOptions options, Map<String, T> params, BiConsumer<GameTestHelper, T> consumer) {
        return TestUtils.createParameterizedTestFunctionsInner(TestUtils.findPrefix(2), generatedGroupName, options, params, consumer);
    }

    private static <T> Collection<TestFunction> createParameterizedTestFunctionsInner(String prefix, String generatedGroupName, TestOptions options, Map<String, T> params, BiConsumer<GameTestHelper, T> consumer) {
        ArrayList<TestFunction> retVal = new ArrayList<TestFunction>();
        params.forEach((name, param) -> retVal.add(TestUtils.createTestFunctionInner(prefix, generatedGroupName, name, options, helper -> consumer.accept((GameTestHelper)helper, (Object)param))));
        return retVal;
    }

    public static <T, U> Collection<TestFunction> createDualParameterizedTestFunctions(String generatedGroupName, String templateName, Map<String, T> params1, Map<String, U> params2, TriConsumer<GameTestHelper, T, U> consumer) {
        return TestUtils.createDualParameterizedTestFunctionsInner(TestUtils.findPrefix(2), generatedGroupName, TestOptions.builder(templateName).build(), params1, params2, consumer);
    }

    private static <T, U> Collection<TestFunction> createDualParameterizedTestFunctionsInner(String prefix, String generatedGroupName, TestOptions options, Map<String, T> params1, Map<String, U> params2, TriConsumer<GameTestHelper, T, U> consumer) {
        ArrayList<TestFunction> retVal = new ArrayList<TestFunction>();
        params1.forEach((name1, param1) -> params2.forEach((name2, param2) -> retVal.add(TestUtils.createTestFunctionInner(prefix, generatedGroupName, String.join((CharSequence)".", name1, name2), options, helper -> consumer.accept(helper, param1, param2)))));
        return retVal;
    }

    public static void placeBed(GameTestHelper helper, BlockPos bedPos) {
        helper.setBlock(bedPos, Blocks.BLUE_BED);
        BlockState footState = helper.getBlockState(bedPos);
        BlockPos headPos = bedPos.relative((Direction)footState.getValue((Property)BedBlock.FACING));
        helper.setBlock(headPos, (BlockState)footState.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD));
    }
}

