/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.platform.services.registries;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.registries.IRegistryItem;
import com.verdantartifice.primalmagick.common.tags.ITagValue;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface IRegistryService<R> {
    public void init();

    public <T extends R> IRegistryItem<R, T> register(String var1, Supplier<T> var2);

    @Nullable
    public R get(ResourceLocation var1);

    public Collection<R> getAll();

    public Set<ResourceLocation> getAllKeys();

    public Set<Map.Entry<ResourceKey<R>, R>> getEntries();

    public boolean containsKey(ResourceLocation var1);

    public Optional<ResourceKey<R>> getResourceKey(R var1);

    @Nullable
    default public ResourceLocation getKey(R value) {
        return this.getResourceKey(value).map(ResourceKey::location).orElse(null);
    }

    public Optional<Holder<R>> getHolder(ResourceKey<R> var1);

    public Optional<Holder<R>> getHolder(ResourceLocation var1);

    public Optional<Holder<R>> getHolder(R var1);

    public Codec<R> codec();

    public StreamCodec<RegistryFriendlyByteBuf, R> registryFriendlyStreamCodec();

    public StreamCodec<FriendlyByteBuf, R> friendlyStreamCodec();

    public ITagValue<R> getTag(TagKey<R> var1);

    public boolean tagExists(TagKey<R> var1);
}

