/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.platform.registries;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.registries.IRegistryItem;
import com.verdantartifice.primalmagick.common.registries.RegistryItemNeoforge;
import com.verdantartifice.primalmagick.common.tags.ITagValue;
import com.verdantartifice.primalmagick.common.tags.TagValueNeoforge;
import com.verdantartifice.primalmagick.platform.services.registries.IRegistryService;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

abstract class AbstractRegistryServiceNeoforge<R>
implements IRegistryService<R> {
    AbstractRegistryServiceNeoforge() {
    }

    protected abstract Supplier<DeferredRegister<R>> getDeferredRegisterSupplier();

    protected abstract Registry<R> getRegistry();

    @Override
    public void init() {
        this.getDeferredRegisterSupplier().get().register(PrimalMagick.getEventBus());
    }

    @Override
    public <T extends R> IRegistryItem<R, T> register(String name, Supplier<T> supplier) {
        return new RegistryItemNeoforge(this.getDeferredRegisterSupplier().get().register(name, supplier));
    }

    @Override
    @Nullable
    public R get(ResourceLocation id) {
        return (R)this.getRegistry().get(id);
    }

    @Override
    public Collection<R> getAll() {
        return this.getRegistry().stream().toList();
    }

    @Override
    public Set<ResourceLocation> getAllKeys() {
        return this.getRegistry().keySet();
    }

    @Override
    public Set<Map.Entry<ResourceKey<R>, R>> getEntries() {
        return this.getRegistry().entrySet();
    }

    @Override
    public boolean containsKey(ResourceLocation id) {
        return this.getRegistry().containsKey(id);
    }

    @Override
    public Optional<ResourceKey<R>> getResourceKey(R value) {
        return this.getRegistry().getResourceKey(value);
    }

    @Override
    public Optional<Holder<R>> getHolder(ResourceKey<R> key) {
        return this.getRegistry().getHolder(key).flatMap(Optional::of);
    }

    @Override
    public Optional<Holder<R>> getHolder(ResourceLocation loc) {
        return this.getRegistry().getHolder(loc).flatMap(Optional::of);
    }

    @Override
    public Optional<Holder<R>> getHolder(R value) {
        return this.getRegistry().getResourceKey(value).flatMap(this::getHolder);
    }

    @Override
    public Codec<R> codec() {
        return this.getRegistry().byNameCodec();
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, R> registryFriendlyStreamCodec() {
        return ByteBufCodecs.registry((ResourceKey)this.getRegistry().key());
    }

    @Override
    public StreamCodec<FriendlyByteBuf, R> friendlyStreamCodec() {
        return new StreamCodec<FriendlyByteBuf, R>(){

            public R decode(FriendlyByteBuf pBuffer) {
                ResourceLocation id = ResourceLocation.parse((String)Utf8String.read((ByteBuf)pBuffer, (int)Short.MAX_VALUE));
                return AbstractRegistryServiceNeoforge.this.getRegistry().get(id);
            }

            public void encode(FriendlyByteBuf pBuffer, R pValue) {
                ResourceLocation id = AbstractRegistryServiceNeoforge.this.getRegistry().getKey(pValue);
                Utf8String.write((ByteBuf)pBuffer, (CharSequence)id.toString(), (int)Short.MAX_VALUE);
            }
        };
    }

    @Override
    public ITagValue<R> getTag(TagKey<R> key) {
        return new TagValueNeoforge(this.getRegistry().getOrCreateTag(key));
    }

    @Override
    public boolean tagExists(TagKey<R> key) {
        return this.getRegistry().getTag(key).isPresent();
    }
}

