/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.platform;

import com.verdantartifice.primalmagick.common.capabilities.CapabilitiesNeoforge;
import com.verdantartifice.primalmagick.common.capabilities.IEntitySwappers;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPMNeoforge;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.platform.Services;
import com.verdantartifice.primalmagick.platform.services.ICapabilityService;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityServiceNeoforge
implements ICapabilityService {
    @Override
    public Optional<IPlayerKnowledge> knowledge(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerKnowledge)player.getData(CapabilitiesNeoforge.KNOWLEDGE));
    }

    @Override
    public Optional<IPlayerCooldowns> cooldowns(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerCooldowns)player.getData(CapabilitiesNeoforge.COOLDOWNS));
    }

    @Override
    public Optional<IPlayerStats> stats(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerStats)player.getData(CapabilitiesNeoforge.STATS));
    }

    @Override
    public Optional<IPlayerAttunements> attunements(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerAttunements)player.getData(CapabilitiesNeoforge.ATTUNEMENTS));
    }

    @Override
    public Optional<IPlayerCompanions> companions(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerCompanions)player.getData(CapabilitiesNeoforge.COMPANIONS));
    }

    @Override
    public Optional<IPlayerWard> ward(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerWard)player.getData(CapabilitiesNeoforge.WARD));
    }

    @Override
    public Optional<IPlayerLinguistics> linguistics(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerLinguistics)player.getData(CapabilitiesNeoforge.LINGUISTICS));
    }

    @Override
    public Optional<IPlayerArcaneRecipeBook> arcaneRecipeBook(Player player) {
        return player == null ? Optional.empty() : Optional.of((IPlayerArcaneRecipeBook)player.getData(CapabilitiesNeoforge.ARCANE_RECIPE_BOOK));
    }

    @Override
    public Optional<IEntitySwappers> swappers(Entity entity) {
        return entity == null ? Optional.empty() : Optional.of((IEntitySwappers)entity.getData(CapabilitiesNeoforge.ENTITY_SWAPPERS));
    }

    @Override
    public Optional<IItemHandlerPM> itemHandler(@NotNull Level level, @NotNull BlockPos pos, @Nullable Direction face) {
        IItemHandler neoforgeHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face);
        if (neoforgeHandler instanceof IItemHandlerPM) {
            IItemHandlerPM castHandler = (IItemHandlerPM)neoforgeHandler;
            return Optional.of(castHandler);
        }
        if (neoforgeHandler != null) {
            return Optional.of(new ItemStackHandlerPMNeoforge(neoforgeHandler, null));
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return Optional.ofNullable(Services.ITEM_HANDLERS.wrap(container, face));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IItemHandlerPM> itemHandler(AbstractTilePM tile, Direction face) {
        if (tile == null || tile.getLevel() == null) {
            return Optional.empty();
        }
        return this.itemHandler(tile.getLevel(), tile.getBlockPos(), face);
    }

    @Override
    public Optional<IManaStorage<?>> manaStorage(@NotNull Level level, @NotNull BlockPos pos, @Nullable Direction face) {
        IManaStorage cap = (IManaStorage)level.getCapability(CapabilitiesNeoforge.MANA_STORAGE, pos, null);
        return Optional.ofNullable(cap);
    }

    @Override
    public Optional<IManaStorage<?>> manaStorage(@Nullable AbstractTilePM tile, @Nullable Direction face) {
        if (tile == null || tile.getLevel() == null) {
            return Optional.empty();
        }
        return this.manaStorage(tile.getLevel(), tile.getBlockPos(), face);
    }
}

