/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.mixin;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.tags.DamageTypeTagsPM;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantedCountIncreaseFunction.class})
public abstract class EnchantedCountIncreaseFunctionMixin
extends LootItemConditionalFunction {
    @Shadow
    @Final
    private Holder<Enchantment> enchantment;
    @Shadow
    @Final
    private NumberProvider value;
    @Shadow
    @Final
    private int limit;

    @Shadow
    private boolean hasLimit() {
        return false;
    }

    protected EnchantedCountIncreaseFunctionMixin(List<LootItemCondition> pPredicates) {
        super(pPredicates);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onRun(ItemStack pStack, LootContext pContext, CallbackInfoReturnable<ItemStack> cir) {
        Object object;
        DamageSource damageSource = (DamageSource)pContext.getParamOrNull(LootContextParams.DAMAGE_SOURCE);
        if (this.enchantment.is(Enchantments.LOOTING) && damageSource != null && (damageSource.is(DamageTypeTagsPM.IS_SORCERY) || damageSource.is(DamageTypeTags.IS_PLAYER_ATTACK)) && (object = pContext.getParamOrNull(LootContextParams.ATTACKING_ENTITY)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            Holder.Reference treasureHolder = pContext.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentsPM.TREASURE);
            int enchantmentLevel = Math.max(EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)livingEntity), EnchantmentHelper.getEnchantmentLevel((Holder)treasureHolder, (LivingEntity)livingEntity));
            if (enchantmentLevel > 0) {
                float f = (float)enchantmentLevel * this.value.getFloat(pContext);
                pStack.grow(Math.round(f));
                if (this.hasLimit()) {
                    pStack.limitSize(this.limit);
                }
            }
            cir.setReturnValue((Object)pStack);
        }
    }
}

