/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.verdantartifice.primalmagick.common.crafting.ShapelessTagRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ShapelessTagRecipeBuilder {
    protected final RecipeCategory category;
    protected final TagKey<Item> resultTag;
    protected final int resultAmount;
    protected final NonNullList<Ingredient> ingredients = NonNullList.create();
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    protected String group;

    protected ShapelessTagRecipeBuilder(RecipeCategory category, TagKey<Item> resultTag, int resultAmount) {
        this.category = category;
        this.resultTag = resultTag;
        this.resultAmount = resultAmount;
    }

    public static ShapelessTagRecipeBuilder shapelessTagRecipe(RecipeCategory category, TagKey<Item> resultTag, int resultAmount) {
        return new ShapelessTagRecipeBuilder(category, resultTag, resultAmount);
    }

    public static ShapelessTagRecipeBuilder shapelessTagRecipe(RecipeCategory category, TagKey<Item> resultTag) {
        return ShapelessTagRecipeBuilder.shapelessTagRecipe(category, resultTag, 1);
    }

    public ShapelessTagRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int index = 0; index < quantity; ++index) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessTagRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ShapelessTagRecipeBuilder addIngredient(ItemLike item, int quantity) {
        return this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}), quantity);
    }

    public ShapelessTagRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public ShapelessTagRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.of(tag));
    }

    public ShapelessTagRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public ShapelessTagRecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    protected static CraftingBookCategory determineBookCategory(RecipeCategory category) {
        return switch (category) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        this.validate(id);
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        ShapelessTagRecipe recipe = new ShapelessTagRecipe(Objects.requireNonNullElse(this.group, ""), ShapelessTagRecipeBuilder.determineBookCategory(this.category), this.resultTag, this.resultAmount, this.ingredients);
        output.accept(id, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    protected void validate(ResourceLocation id) {
        if (this.resultTag == null) {
            throw new IllegalStateException("No result tag defined for shapeless tag recipe " + String.valueOf(id) + "!");
        }
        if (this.resultAmount <= 0) {
            throw new IllegalStateException("Invalid result amount " + this.resultAmount + " specified for shapeless tag recipe " + String.valueOf(id) + "!");
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for shapeless tag recipe " + String.valueOf(id) + "!");
        }
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

