/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.verdantartifice.primalmagick.common.crafting.RunecarvingRecipe;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchStageKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class RunecarvingRecipeBuilder {
    protected final ItemStack result;
    protected Ingredient ingredient1;
    protected Ingredient ingredient2;
    protected String group;
    protected final List<AbstractRequirement<?>> requirements = new ArrayList();
    protected Optional<Integer> baseExpertiseOverride = Optional.empty();
    protected Optional<Integer> bonusExpertiseOverride = Optional.empty();
    protected Optional<ResourceLocation> expertiseGroup = Optional.empty();
    protected Optional<ResearchDisciplineKey> disciplineOverride = Optional.empty();

    protected RunecarvingRecipeBuilder(ItemLike item, int count) {
        this.result = new ItemStack(item, count);
    }

    public static RunecarvingRecipeBuilder runecarvingRecipe(ItemLike item, int count) {
        return new RunecarvingRecipeBuilder(item, count);
    }

    public static RunecarvingRecipeBuilder runecarvingRecipe(ItemLike item) {
        return new RunecarvingRecipeBuilder(item, 1);
    }

    public RunecarvingRecipeBuilder firstIngredient(Ingredient ingredient) {
        this.ingredient1 = ingredient;
        return this;
    }

    public RunecarvingRecipeBuilder firstIngredient(ItemLike item) {
        return this.firstIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public RunecarvingRecipeBuilder firstIngredient(TagKey<Item> tag) {
        return this.firstIngredient(Ingredient.of(tag));
    }

    public RunecarvingRecipeBuilder secondIngredient(Ingredient ingredient) {
        this.ingredient2 = ingredient;
        return this;
    }

    public RunecarvingRecipeBuilder secondIngredient(ItemLike item) {
        return this.secondIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public RunecarvingRecipeBuilder secondIngredient(TagKey<Item> tag) {
        return this.secondIngredient(Ingredient.of(tag));
    }

    public RunecarvingRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public RunecarvingRecipeBuilder requirement(AbstractRequirement<?> requirement) {
        this.requirements.add(requirement);
        return this;
    }

    public RunecarvingRecipeBuilder requiredResearch(ResourceKey<ResearchEntry> research) {
        return this.requirement(new ResearchRequirement(new ResearchEntryKey(research)));
    }

    public RunecarvingRecipeBuilder requiredResearch(ResourceKey<ResearchEntry> research, int stage) {
        return this.requirement(new ResearchRequirement(new ResearchStageKey(research, stage)));
    }

    public RunecarvingRecipeBuilder expertise(int baseValue, int bonusValue) {
        this.baseExpertiseOverride = Optional.of(baseValue);
        this.bonusExpertiseOverride = Optional.of(bonusValue);
        return this;
    }

    public RunecarvingRecipeBuilder noExpertise() {
        return this.expertise(0, 0);
    }

    public RunecarvingRecipeBuilder expertiseTier(ResearchTier tier) {
        return this.expertise(tier.getDefaultExpertise(), tier.getDefaultBonusExpertise());
    }

    public RunecarvingRecipeBuilder expertiseGroup(ResourceLocation groupLoc) {
        this.expertiseGroup = Optional.ofNullable(groupLoc);
        return this;
    }

    public RunecarvingRecipeBuilder expertiseGroup(String groupName) {
        return this.expertiseGroup(ResourceUtils.loc(groupName));
    }

    public RunecarvingRecipeBuilder discipline(ResourceKey<ResearchDiscipline> rawDiscipline) {
        this.disciplineOverride = Optional.of(new ResearchDisciplineKey(rawDiscipline));
        return this;
    }

    protected Optional<AbstractRequirement<?>> getFinalRequirement() {
        if (this.requirements.isEmpty()) {
            return Optional.empty();
        }
        if (this.requirements.size() == 1) {
            return Optional.of(this.requirements.get(0));
        }
        return Optional.of(new AndRequirement(this.requirements));
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        this.validate(id);
        RunecarvingRecipe recipe = new RunecarvingRecipe(Objects.requireNonNullElse(this.group, ""), this.result, this.ingredient1, this.ingredient2, this.getFinalRequirement(), this.baseExpertiseOverride, this.bonusExpertiseOverride, this.expertiseGroup, this.disciplineOverride);
        output.accept(id, (Recipe)recipe, null);
    }

    public void build(RecipeOutput output, String save) {
        ResourceLocation id = Services.ITEMS_REGISTRY.getKey(this.result.getItem());
        ResourceLocation saveLoc = ResourceLocation.parse((String)save);
        if (saveLoc.equals((Object)id)) {
            throw new IllegalStateException("Runecarving Recipe " + save + " should remove its 'save' argument");
        }
        this.build(output, saveLoc);
    }

    public void build(RecipeOutput output) {
        this.build(output, Services.ITEMS_REGISTRY.getKey(this.result.getItem()));
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredient1 == null || this.ingredient1.isEmpty() || this.ingredient2 == null || this.ingredient2.isEmpty()) {
            throw new IllegalStateException("Missing ingredient for runecarving recipe " + String.valueOf(id) + "!");
        }
        if (this.requirements.isEmpty()) {
            throw new IllegalStateException("No requirement is defined for runecarving recipe " + String.valueOf(id) + "!");
        }
    }
}

