/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.verdantartifice.primalmagick.common.crafting.DissolutionRecipe;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import java.util.Objects;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class DissolutionRecipeBuilder {
    protected final ItemStack result;
    protected Ingredient ingredient;
    protected String group;
    protected SourceList manaCosts;

    protected DissolutionRecipeBuilder(ItemStack result) {
        this.result = result.copy();
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemStack result) {
        return new DissolutionRecipeBuilder(result);
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemLike item, int count) {
        return DissolutionRecipeBuilder.dissolutionRecipe(new ItemStack((ItemLike)item.asItem(), count));
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemLike item) {
        return DissolutionRecipeBuilder.dissolutionRecipe(item, 1);
    }

    public DissolutionRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public DissolutionRecipeBuilder ingredient(ItemLike item) {
        return this.ingredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public DissolutionRecipeBuilder ingredient(TagKey<Item> tag) {
        return this.ingredient(Ingredient.of(tag));
    }

    public DissolutionRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public DissolutionRecipeBuilder defaultManaCost() {
        return this.manaCost(SourceList.EMPTY.add(Sources.EARTH, 10));
    }

    public DissolutionRecipeBuilder manaCost(SourceList mana) {
        return this.centimanaCost(mana.multiply(100.0));
    }

    public DissolutionRecipeBuilder centimanaCost(SourceList centimana) {
        this.manaCosts = centimana.copy();
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for dissolution recipe " + String.valueOf(id) + "!");
        }
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        this.validate(id);
        DissolutionRecipe recipe = new DissolutionRecipe(Objects.requireNonNullElse(this.group, ""), this.result, this.ingredient, Objects.requireNonNullElse(this.manaCosts, SourceList.EMPTY));
        output.accept(id, (Recipe)recipe, null);
    }
}

