/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.verdantartifice.primalmagick.common.crafting.ShapedArcaneRecipe;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchStageKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.AndRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class ArcaneShapedRecipeBuilder {
    protected final ItemStack result;
    protected final List<String> patternRows = new ArrayList<String>();
    protected final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    protected String group;
    protected final List<AbstractRequirement<?>> requirements = new ArrayList();
    protected SourceList manaCosts;
    protected Optional<Integer> baseExpertiseOverride = Optional.empty();
    protected Optional<Integer> bonusExpertiseOverride = Optional.empty();
    protected Optional<ResourceLocation> expertiseGroup = Optional.empty();
    protected Optional<ResearchDisciplineKey> disciplineOverride = Optional.empty();

    protected ArcaneShapedRecipeBuilder(ItemLike result, int count) {
        this.result = new ItemStack(result, count);
    }

    public static ArcaneShapedRecipeBuilder arcaneShapedRecipe(ItemLike result, int count) {
        return new ArcaneShapedRecipeBuilder(result, count);
    }

    public static ArcaneShapedRecipeBuilder arcaneShapedRecipe(ItemLike result) {
        return ArcaneShapedRecipeBuilder.arcaneShapedRecipe(result, 1);
    }

    public ArcaneShapedRecipeBuilder key(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public ArcaneShapedRecipeBuilder key(Character symbol, ItemLike item) {
        return this.key(symbol, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public ArcaneShapedRecipeBuilder key(Character symbol, TagKey<Item> tag) {
        return this.key(symbol, Ingredient.of(tag));
    }

    public ArcaneShapedRecipeBuilder patternLine(String pattern) {
        if (!this.patternRows.isEmpty() && pattern.length() != this.patternRows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.patternRows.add(pattern);
        return this;
    }

    public ArcaneShapedRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public ArcaneShapedRecipeBuilder requirement(AbstractRequirement<?> requirement) {
        this.requirements.add(requirement);
        return this;
    }

    public ArcaneShapedRecipeBuilder requiredResearch(ResourceKey<ResearchEntry> research) {
        return this.requirement(new ResearchRequirement(new ResearchEntryKey(research)));
    }

    public ArcaneShapedRecipeBuilder requiredResearch(ResourceKey<ResearchEntry> research, int stage) {
        return this.requirement(new ResearchRequirement(new ResearchStageKey(research, stage)));
    }

    public ArcaneShapedRecipeBuilder manaCost(SourceList mana) {
        return this.centimanaCost(mana.multiply(100.0));
    }

    public ArcaneShapedRecipeBuilder centimanaCost(SourceList centimana) {
        this.manaCosts = centimana.copy();
        return this;
    }

    public ArcaneShapedRecipeBuilder expertise(int baseValue, int bonusValue) {
        this.baseExpertiseOverride = Optional.of(baseValue);
        this.bonusExpertiseOverride = Optional.of(bonusValue);
        return this;
    }

    public ArcaneShapedRecipeBuilder noExpertise() {
        return this.expertise(0, 0);
    }

    public ArcaneShapedRecipeBuilder expertiseTier(ResearchTier tier) {
        return this.expertise(tier.getDefaultExpertise(), tier.getDefaultBonusExpertise());
    }

    public ArcaneShapedRecipeBuilder expertiseGroup(ResourceLocation groupLoc) {
        this.expertiseGroup = Optional.ofNullable(groupLoc);
        return this;
    }

    public ArcaneShapedRecipeBuilder expertiseGroup(String groupName) {
        return this.expertiseGroup(ResourceUtils.loc(groupName));
    }

    public ArcaneShapedRecipeBuilder discipline(ResourceKey<ResearchDiscipline> rawDiscipline) {
        this.disciplineOverride = Optional.of(new ResearchDisciplineKey(rawDiscipline));
        return this;
    }

    protected Optional<AbstractRequirement<?>> getFinalRequirement() {
        if (this.requirements.isEmpty()) {
            return Optional.empty();
        }
        if (this.requirements.size() == 1) {
            return Optional.of(this.requirements.get(0));
        }
        return Optional.of(new AndRequirement(this.requirements));
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        ShapedRecipePattern pattern = this.validate(id);
        ShapedArcaneRecipe recipe = new ShapedArcaneRecipe(Objects.requireNonNullElse(this.group, ""), this.result, pattern, this.getFinalRequirement(), Objects.requireNonNullElse(this.manaCosts, SourceList.EMPTY), this.baseExpertiseOverride, this.bonusExpertiseOverride, this.expertiseGroup, this.disciplineOverride);
        output.accept(id, (Recipe)recipe, null);
    }

    public void build(RecipeOutput output, String save) {
        ResourceLocation id = Services.ITEMS_REGISTRY.getKey(this.result.getItem());
        ResourceLocation saveLoc = ResourceLocation.parse((String)save);
        if (saveLoc.equals((Object)id)) {
            throw new IllegalStateException("Arcane Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(output, saveLoc);
    }

    public void build(RecipeOutput output) {
        this.build(output, Services.ITEMS_REGISTRY.getKey(this.result.getItem()));
    }

    protected ShapedRecipePattern validate(ResourceLocation id) {
        if (this.requirements.isEmpty()) {
            throw new IllegalStateException("No requirement is defined for arcane shaped recipe " + String.valueOf(id) + "!");
        }
        if (this.patternRows.size() == 1 && this.patternRows.get(0).length() == 1) {
            throw new IllegalStateException("Arcane shaped recipe " + String.valueOf(id) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        return ShapedRecipePattern.of(this.key, this.patternRows);
    }
}

