/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.datagen.loot_tables.AbstractBlockLootTableProvider;
import java.util.OptionalInt;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BlockLootTables
extends AbstractBlockLootTableProvider {
    public BlockLootTables(HolderLookup.Provider registries) {
        super(registries);
    }

    @Override
    protected void generate() {
        this.registerEmptyLootTables();
        this.registerMarbleLootTables();
        this.registerEnchantedMarbleLootTables();
        this.registerSmokedMarbleLootTables();
        this.registerHallowedMarbleLootTables();
        this.registerSunwoodLootTables();
        this.registerMoonwoodLootTables();
        this.registerHallowoodLootTables();
        this.registerCropLootTables();
        this.registerInfusedStoneLootTables();
        this.registerSkyglassLootTables();
        this.registerRitualCandleLootTables();
        this.registerManaFontLootTables();
        this.registerBuddingGemLootTables();
        this.registerBasicTable(BlocksPM.ARCANE_WORKBENCH.get());
        this.registerBasicTable(BlocksPM.WAND_ASSEMBLY_TABLE.get());
        this.registerBasicTable(BlocksPM.WOOD_TABLE.get());
        this.registerBasicTable(BlocksPM.ANALYSIS_TABLE.get());
        this.registerBasicTable((Block)BlocksPM.ESSENCE_FURNACE.get());
        this.registerBasicTable((Block)BlocksPM.CALCINATOR_BASIC.get());
        this.registerBasicTable((Block)BlocksPM.CALCINATOR_ENCHANTED.get());
        this.registerBasicTable((Block)BlocksPM.CALCINATOR_FORBIDDEN.get());
        this.registerBasicTable((Block)BlocksPM.CALCINATOR_HEAVENLY.get());
        this.registerBasicTable(BlocksPM.WAND_INSCRIPTION_TABLE.get());
        this.registerBasicTable((Block)BlocksPM.SPELLCRAFTING_ALTAR.get());
        this.registerBasicTable((Block)BlocksPM.WAND_CHARGER.get());
        this.registerBasicTable((Block)BlocksPM.RESEARCH_TABLE.get());
        this.registerBasicTable((Block)BlocksPM.SUNLAMP.get());
        this.registerBasicTable((Block)BlocksPM.SPIRIT_LANTERN.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_ALTAR.get());
        this.registerBasicTable((Block)BlocksPM.OFFERING_PEDESTAL.get());
        this.registerBasicTable((Block)BlocksPM.INCENSE_BRAZIER.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_LECTERN.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_BELL.get());
        this.registerBasicTable((Block)BlocksPM.BLOODLETTER.get());
        this.registerBasicTable((Block)BlocksPM.SOUL_ANVIL.get());
        this.registerBasicTable((Block)BlocksPM.RUNIC_GRINDSTONE.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.HONEY_EXTRACTOR.get());
        this.registerBasicTable(BlocksPM.PRIMALITE_GOLEM_CONTROLLER.get());
        this.registerBasicTable(BlocksPM.HEXIUM_GOLEM_CONTROLLER.get());
        this.registerBasicTable(BlocksPM.HALLOWSTEEL_GOLEM_CONTROLLER.get());
        this.registerBasicTable((Block)BlocksPM.SANGUINE_CRUCIBLE.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.CONCOCTER.get());
        this.registerBasicTable((Block)BlocksPM.RUNECARVING_TABLE.get());
        this.registerBasicTable((Block)BlocksPM.RUNESCRIBING_ALTAR_BASIC.get());
        this.registerBasicTable((Block)BlocksPM.RUNESCRIBING_ALTAR_ENCHANTED.get());
        this.registerBasicTable((Block)BlocksPM.RUNESCRIBING_ALTAR_FORBIDDEN.get());
        this.registerBasicTable((Block)BlocksPM.RUNESCRIBING_ALTAR_HEAVENLY.get());
        this.registerBasicTable((Block)BlocksPM.CELESTIAL_HARP.get());
        this.registerBasicTable((Block)BlocksPM.ENTROPY_SINK.get());
        this.registerBasicTable((Block)BlocksPM.AUTO_CHARGER.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.ESSENCE_TRANSMUTER.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.DISSOLUTION_CHAMBER.get());
        this.registerBasicTable((Block)BlocksPM.ZEPHYR_ENGINE.get());
        this.registerBasicTable((Block)BlocksPM.VOID_TURBINE.get());
        this.registerBasicTable((Block)BlocksPM.ESSENCE_CASK_ENCHANTED.get());
        this.registerBasicTable((Block)BlocksPM.ESSENCE_CASK_FORBIDDEN.get());
        this.registerBasicTable((Block)BlocksPM.ESSENCE_CASK_HEAVENLY.get());
        this.registerBasicTable(BlocksPM.WAND_GLAMOUR_TABLE.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.INFERNAL_FURNACE.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.MANA_NEXUS.get());
        this.registerManaBearingDeviceTable((Block)BlocksPM.MANA_SINGULARITY.get());
        this.registerBasicTable((Block)BlocksPM.MANA_SINGULARITY_CREATIVE.get());
        this.registerBasicTable((Block)BlocksPM.SCRIBE_TABLE.get());
        this.registerBasicTable((Block)BlocksPM.MANA_RELAY_BASIC.get());
        this.registerBasicTable((Block)BlocksPM.MANA_RELAY_ENCHANTED.get());
        this.registerBasicTable((Block)BlocksPM.MANA_RELAY_FORBIDDEN.get());
        this.registerBasicTable((Block)BlocksPM.MANA_RELAY_HEAVENLY.get());
        this.registerBasicTable((Block)BlocksPM.MANA_INJECTOR_BASIC.get());
        this.registerBasicTable((Block)BlocksPM.MANA_INJECTOR_ENCHANTED.get());
        this.registerBasicTable((Block)BlocksPM.MANA_INJECTOR_FORBIDDEN.get());
        this.registerBasicTable((Block)BlocksPM.MANA_INJECTOR_HEAVENLY.get());
        this.registerBasicTable((Block)BlocksPM.DESALINATOR.get());
        this.registerBasicTable(BlocksPM.SALT_TRAIL.get());
        this.registerMultiGemOreTable(BlocksPM.ROCK_SALT_ORE.get(), ItemsPM.ROCK_SALT.get(), 3.0f, 4.0f);
        this.registerGemOreTable((Block)BlocksPM.QUARTZ_ORE.get(), Items.QUARTZ);
        this.registerBasicTable(BlocksPM.PRIMALITE_BLOCK.get());
        this.registerBasicTable(BlocksPM.HEXIUM_BLOCK.get());
        this.registerBasicTable(BlocksPM.HALLOWSTEEL_BLOCK.get());
        this.registerBasicTable(BlocksPM.IGNYX_BLOCK.get());
        this.registerBasicTable(BlocksPM.SALT_BLOCK.get());
        this.registerBasicTable((Block)BlocksPM.TREEFOLK_SPROUT.get());
        this.registerBasicTable(BlocksPM.ENDERWARD.get());
    }

    private void registerEmptyLootTables() {
        this.registerEmptyTable((Block)BlocksPM.ANCIENT_FONT_EARTH.get());
        this.registerEmptyTable((Block)BlocksPM.ANCIENT_FONT_SEA.get());
        this.registerEmptyTable((Block)BlocksPM.ANCIENT_FONT_SKY.get());
        this.registerEmptyTable((Block)BlocksPM.ANCIENT_FONT_SUN.get());
        this.registerEmptyTable((Block)BlocksPM.ANCIENT_FONT_MOON.get());
        this.registerEmptyTable(BlocksPM.GLOW_FIELD.get());
        this.registerEmptyTable(BlocksPM.SOUL_GLOW_FIELD.get());
        this.registerEmptyTable((Block)BlocksPM.CONSECRATION_FIELD.get());
    }

    private void registerMarbleLootTables() {
        this.registerBasicTable(BlocksPM.MARBLE_RAW.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_BRICK_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_BRICK_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_BRICK_WALL.get());
        this.registerBasicTable(BlocksPM.MARBLE_BRICKS.get());
        this.registerBasicTable(BlocksPM.MARBLE_CHISELED.get());
        this.registerBasicTable(BlocksPM.MARBLE_PILLAR.get());
        this.registerBasicTable(BlocksPM.MARBLE_RUNED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_WALL.get());
        this.registerBasicTable(BlocksPM.MARBLE_TILES.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_BOOKSHELF.get());
    }

    private void registerEnchantedMarbleLootTables() {
        this.registerBasicTable(BlocksPM.MARBLE_ENCHANTED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get());
        this.registerBasicTable(BlocksPM.MARBLE_ENCHANTED_BRICKS.get());
        this.registerBasicTable(BlocksPM.MARBLE_ENCHANTED_CHISELED.get());
        this.registerBasicTable(BlocksPM.MARBLE_ENCHANTED_PILLAR.get());
        this.registerBasicTable(BlocksPM.MARBLE_ENCHANTED_RUNED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_ENCHANTED_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_ENCHANTED_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_ENCHANTED_WALL.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_ENCHANTED_BOOKSHELF.get());
    }

    private void registerSmokedMarbleLootTables() {
        this.registerBasicTable(BlocksPM.MARBLE_SMOKED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_SMOKED_BRICK_WALL.get());
        this.registerBasicTable(BlocksPM.MARBLE_SMOKED_BRICKS.get());
        this.registerBasicTable(BlocksPM.MARBLE_SMOKED_CHISELED.get());
        this.registerBasicTable(BlocksPM.MARBLE_SMOKED_PILLAR.get());
        this.registerBasicTable(BlocksPM.MARBLE_SMOKED_RUNED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_SMOKED_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_SMOKED_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_SMOKED_WALL.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_SMOKED_BOOKSHELF.get());
    }

    private void registerHallowedMarbleLootTables() {
        this.registerBasicTable(BlocksPM.MARBLE_HALLOWED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get());
        this.registerBasicTable(BlocksPM.MARBLE_HALLOWED_BRICKS.get());
        this.registerBasicTable(BlocksPM.MARBLE_HALLOWED_CHISELED.get());
        this.registerBasicTable(BlocksPM.MARBLE_HALLOWED_PILLAR.get());
        this.registerBasicTable(BlocksPM.MARBLE_HALLOWED_RUNED.get());
        this.registerSlabTable((Block)BlocksPM.MARBLE_HALLOWED_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_HALLOWED_STAIRS.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_HALLOWED_WALL.get());
        this.registerBasicTable((Block)BlocksPM.MARBLE_HALLOWED_BOOKSHELF.get());
    }

    private void registerSunwoodLootTables() {
        this.registerPulsingLogTable((Block)BlocksPM.SUNWOOD_LOG.get());
        this.registerPulsingLogTable((Block)BlocksPM.STRIPPED_SUNWOOD_LOG.get());
        this.registerPulsingLogTable((Block)BlocksPM.SUNWOOD_WOOD.get());
        this.registerPulsingLogTable((Block)BlocksPM.STRIPPED_SUNWOOD_WOOD.get());
        this.registerLeavesTable(BlocksPM.SUNWOOD_LEAVES.get(), (Block)BlocksPM.SUNWOOD_SAPLING.get(), new float[]{0.1f, 0.125f, 0.16666667f, 0.2f});
        this.registerBasicTable((Block)BlocksPM.SUNWOOD_SAPLING.get());
        this.registerBasicTable(BlocksPM.SUNWOOD_PLANKS.get());
        this.registerSlabTable((Block)BlocksPM.SUNWOOD_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.SUNWOOD_STAIRS.get());
        this.registerBasicTable(BlocksPM.SUNWOOD_PILLAR.get());
        this.registerPottedPlant(BlocksPM.POTTED_SUNWOOD_SAPLING.get());
    }

    private void registerMoonwoodLootTables() {
        this.registerPulsingLogTable((Block)BlocksPM.MOONWOOD_LOG.get());
        this.registerPulsingLogTable((Block)BlocksPM.STRIPPED_MOONWOOD_LOG.get());
        this.registerPulsingLogTable((Block)BlocksPM.MOONWOOD_WOOD.get());
        this.registerPulsingLogTable((Block)BlocksPM.STRIPPED_MOONWOOD_WOOD.get());
        this.registerLeavesTable(BlocksPM.MOONWOOD_LEAVES.get(), (Block)BlocksPM.MOONWOOD_SAPLING.get(), new float[]{0.1f, 0.125f, 0.16666667f, 0.2f});
        this.registerBasicTable((Block)BlocksPM.MOONWOOD_SAPLING.get());
        this.registerBasicTable(BlocksPM.MOONWOOD_PLANKS.get());
        this.registerSlabTable((Block)BlocksPM.MOONWOOD_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.MOONWOOD_STAIRS.get());
        this.registerBasicTable(BlocksPM.MOONWOOD_PILLAR.get());
        this.registerPottedPlant(BlocksPM.POTTED_MOONWOOD_SAPLING.get());
    }

    private void registerHallowoodLootTables() {
        this.registerBasicTable((Block)BlocksPM.HALLOWOOD_LOG.get());
        this.registerBasicTable((Block)BlocksPM.STRIPPED_HALLOWOOD_LOG.get());
        this.registerBasicTable((Block)BlocksPM.HALLOWOOD_WOOD.get());
        this.registerBasicTable((Block)BlocksPM.STRIPPED_HALLOWOOD_WOOD.get());
        this.registerLeavesTable((Block)BlocksPM.HALLOWOOD_LEAVES.get(), (Block)BlocksPM.HALLOWOOD_SAPLING.get(), new float[]{0.15f, 0.1875f, 0.25f, 0.3f});
        this.registerBasicTable((Block)BlocksPM.HALLOWOOD_SAPLING.get());
        this.registerBasicTable(BlocksPM.HALLOWOOD_PLANKS.get());
        this.registerSlabTable((Block)BlocksPM.HALLOWOOD_SLAB.get());
        this.registerBasicTable((Block)BlocksPM.HALLOWOOD_STAIRS.get());
        this.registerBasicTable(BlocksPM.HALLOWOOD_PILLAR.get());
        this.registerPottedPlant(BlocksPM.POTTED_HALLOWOOD_SAPLING.get());
    }

    private void registerCropLootTables() {
        this.registerSplittingTable(BlocksPM.HYDROMELON.get(), ItemsPM.HYDROMELON_SLICE.get(), (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f), OptionalInt.of(9));
        this.registerLootTableBuilder((Block)BlocksPM.HYDROMELON_STEM.get(), b -> this.createStemDrops((Block)b, ItemsPM.HYDROMELON_SEEDS.get()));
        this.registerLootTableBuilder((Block)BlocksPM.ATTACHED_HYDROMELON_STEM.get(), b -> this.createAttachedStemDrops((Block)b, ItemsPM.HYDROMELON_SEEDS.get()));
        this.registerLootTableBuilder((Block)BlocksPM.BLOOD_ROSE.get(), b -> this.createSinglePropConditionTable((Block)b, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.registerLootTableBuilder((Block)BlocksPM.EMBERFLOWER.get(), b -> this.createSinglePropConditionTable((Block)b, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    private void registerInfusedStoneLootTables() {
        this.registerInfusedStoneTable(BlocksPM.INFUSED_STONE_EARTH.get(), ItemsPM.ESSENCE_DUST_EARTH.get());
        this.registerInfusedStoneTable(BlocksPM.INFUSED_STONE_SEA.get(), ItemsPM.ESSENCE_DUST_SEA.get());
        this.registerInfusedStoneTable(BlocksPM.INFUSED_STONE_SKY.get(), ItemsPM.ESSENCE_DUST_SKY.get());
        this.registerInfusedStoneTable(BlocksPM.INFUSED_STONE_SUN.get(), ItemsPM.ESSENCE_DUST_SUN.get());
        this.registerInfusedStoneTable(BlocksPM.INFUSED_STONE_MOON.get(), ItemsPM.ESSENCE_DUST_MOON.get());
    }

    private void registerSkyglassLootTables() {
        this.registerBasicTable((Block)BlocksPM.SKYGLASS.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_BLACK.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_BLUE.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_BROWN.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_CYAN.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_GRAY.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_GREEN.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_LIGHT_BLUE.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_LIGHT_GRAY.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_LIME.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_MAGENTA.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_ORANGE.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_PINK.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_PURPLE.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_RED.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_WHITE.get());
        this.registerBasicTable((Block)BlocksPM.STAINED_SKYGLASS_YELLOW.get());
        this.registerBasicTable(BlocksPM.SKYGLASS_PANE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_BLACK.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_BLUE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_BROWN.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_CYAN.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_GRAY.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_GREEN.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_LIME.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_MAGENTA.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_ORANGE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_PINK.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_PURPLE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_RED.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_WHITE.get());
        this.registerBasicTable(BlocksPM.STAINED_SKYGLASS_PANE_YELLOW.get());
    }

    private void registerRitualCandleLootTables() {
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_BLACK.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_BLUE.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_BROWN.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_CYAN.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_GRAY.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_GREEN.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_LIGHT_BLUE.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_LIGHT_GRAY.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_LIME.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_MAGENTA.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_ORANGE.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_PINK.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_PURPLE.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_RED.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_WHITE.get());
        this.registerBasicTable((Block)BlocksPM.RITUAL_CANDLE_YELLOW.get());
    }

    private void registerManaFontLootTables() {
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_EARTH.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_SEA.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_SKY.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_SUN.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_MOON.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_BLOOD.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_INFERNAL.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_VOID.get());
        this.registerBasicTable((Block)BlocksPM.ARTIFICIAL_FONT_HALLOWED.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_EARTH.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_SEA.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_SKY.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_SUN.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_MOON.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_BLOOD.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_INFERNAL.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_VOID.get());
        this.registerBasicTable((Block)BlocksPM.FORBIDDEN_FONT_HALLOWED.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_EARTH.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_SEA.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_SKY.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_SUN.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_MOON.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_BLOOD.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_INFERNAL.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_VOID.get());
        this.registerBasicTable((Block)BlocksPM.HEAVENLY_FONT_HALLOWED.get());
    }

    private void registerBuddingGemLootTables() {
        Holder.Reference fortuneHolder = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        this.registerLootTableBuilder(BlocksPM.SYNTHETIC_AMETHYST_CLUSTER.get(), arg_0 -> this.lambda$registerBuddingGemLootTables$4((Holder)fortuneHolder, arg_0));
        this.dropWhenSilkTouch(BlocksPM.LARGE_SYNTHETIC_AMETHYST_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.MEDIUM_SYNTHETIC_AMETHYST_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.SMALL_SYNTHETIC_AMETHYST_BUD.get());
        this.registerLootTableBuilder(BlocksPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_BLOCK)));
        this.registerLootTableBuilder(BlocksPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.FLAWED_BUDDING_AMETHYST_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.SYNTHETIC_DIAMOND_CLUSTER.get(), arg_0 -> this.lambda$registerBuddingGemLootTables$8((Holder)fortuneHolder, arg_0));
        this.dropWhenSilkTouch(BlocksPM.LARGE_SYNTHETIC_DIAMOND_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.MEDIUM_SYNTHETIC_DIAMOND_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.SMALL_SYNTHETIC_DIAMOND_BUD.get());
        this.registerLootTableBuilder(BlocksPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_BLOCK)));
        this.registerLootTableBuilder(BlocksPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.FLAWED_BUDDING_DIAMOND_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.SYNTHETIC_EMERALD_CLUSTER.get(), arg_0 -> this.lambda$registerBuddingGemLootTables$12((Holder)fortuneHolder, arg_0));
        this.dropWhenSilkTouch(BlocksPM.LARGE_SYNTHETIC_EMERALD_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.MEDIUM_SYNTHETIC_EMERALD_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.SMALL_SYNTHETIC_EMERALD_BUD.get());
        this.registerLootTableBuilder(BlocksPM.DAMAGED_BUDDING_EMERALD_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD_BLOCK)));
        this.registerLootTableBuilder(BlocksPM.CHIPPED_BUDDING_EMERALD_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.DAMAGED_BUDDING_EMERALD_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.FLAWED_BUDDING_EMERALD_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.CHIPPED_BUDDING_EMERALD_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.SYNTHETIC_QUARTZ_CLUSTER.get(), arg_0 -> this.lambda$registerBuddingGemLootTables$16((Holder)fortuneHolder, arg_0));
        this.dropWhenSilkTouch(BlocksPM.LARGE_SYNTHETIC_QUARTZ_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.MEDIUM_SYNTHETIC_QUARTZ_BUD.get());
        this.dropWhenSilkTouch(BlocksPM.SMALL_SYNTHETIC_QUARTZ_BUD.get());
        this.registerLootTableBuilder(BlocksPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ_BLOCK)));
        this.registerLootTableBuilder(BlocksPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get()))));
        this.registerLootTableBuilder(BlocksPM.FLAWED_BUDDING_QUARTZ_BLOCK.get(), b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get()))));
    }

    public static LootTableProvider.SubProviderEntry getSubProviderEntry() {
        return new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.BLOCK);
    }

    private /* synthetic */ LootTable.Builder lambda$registerBuddingGemLootTables$16(Holder fortuneHolder, Block b) {
        return this.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)fortuneHolder)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
    }

    private /* synthetic */ LootTable.Builder lambda$registerBuddingGemLootTables$12(Holder fortuneHolder, Block b) {
        return this.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)fortuneHolder)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
    }

    private /* synthetic */ LootTable.Builder lambda$registerBuddingGemLootTables$8(Holder fortuneHolder, Block b) {
        return this.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)fortuneHolder)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
    }

    private /* synthetic */ LootTable.Builder lambda$registerBuddingGemLootTables$4(Holder fortuneHolder, Block b) {
        return this.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)fortuneHolder)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
    }
}

