/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGameplayLootTableSubProvider
implements LootTableSubProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final HolderLookup.Provider registries;
    protected final Map<ResourceKey<LootTable>, LootTable.Builder> lootTables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
    protected final Set<ResourceKey<LootTable>> registeredLootTableTypes = new HashSet<ResourceKey<LootTable>>();
    protected final Supplier<Set<ResourceKey<LootTable>>> expectedTableSupplier;

    protected AbstractGameplayLootTableSubProvider(HolderLookup.Provider registries, Supplier<Set<ResourceKey<LootTable>>> expectedTableSupplier) {
        this.registries = registries;
        this.expectedTableSupplier = expectedTableSupplier;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pOutput) {
        this.addTables(pOutput);
        this.checkExpectations();
    }

    private void checkExpectations() {
        HashSet types = new HashSet(this.expectedTableSupplier.get());
        types.removeAll(this.registeredLootTableTypes);
        types.forEach(key -> LOGGER.warn("Missing gameplay loot table for {}", (Object)key.toString()));
    }

    protected void registerEmptyLootTable(ResourceKey<LootTable> loc) {
        this.registeredLootTableTypes.add(loc);
    }

    protected void registerLootTable(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> writer, ResourceKey<LootTable> loc, LootTable.Builder builder) {
        writer.accept(loc, builder);
        this.registeredLootTableTypes.add(loc);
    }

    protected abstract void addTables(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> var1);
}

