/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLogBlock;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBlockLootTableProvider
extends BlockLootSubProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Set<ResourceLocation> registeredBlocks = new HashSet<ResourceLocation>();

    public AbstractBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected abstract void generate();

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> writer) {
        super.generate(writer);
        this.checkExpectations();
    }

    protected Iterable<Block> getKnownBlocks() {
        return Services.BLOCKS_REGISTRY.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals("primalmagick")).map(Map.Entry::getValue).toList();
    }

    private void registerLootTableBuilder(Block block, LootTable.Builder builder) {
        this.registeredBlocks.add(Services.BLOCKS_REGISTRY.getKey(block));
        this.add(block, builder);
    }

    protected void registerLootTableBuilder(Block block, Function<Block, LootTable.Builder> builderGenerator) {
        this.registerLootTableBuilder(block, builderGenerator.apply(block));
    }

    protected void registerEmptyTable(Block block) {
        this.registeredBlocks.add(Services.BLOCKS_REGISTRY.getKey(block));
    }

    protected void registerBasicTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).when(ExplosionCondition.survivesExplosion());
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerSlabTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()));
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerLeavesTable(Block leavesBlock, Block saplingBlock, float[] saplingFortuneChances) {
        Holder.Reference fortuneHolder = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        float[] stickFortuneChances = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        AnyOfCondition.Builder shearsOrSilkTouch = Services.ITEM_ABILITIES.makeShearsDigLootCondition().or(this.hasSilkTouch());
        LootPoolEntryContainer.Builder saplingEntryBuilder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)saplingBlock).when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortuneHolder, (float[])saplingFortuneChances));
        LootPoolEntryContainer.Builder leavesEntryBuilder = LootItem.lootTableItem((ItemLike)leavesBlock).when((LootItemCondition.Builder)shearsOrSilkTouch);
        LootPool.Builder saplingAndLeavesPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)leavesEntryBuilder.otherwise(saplingEntryBuilder));
        LootPoolEntryContainer.Builder stickEntryBuilder = LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortuneHolder, (float[])stickFortuneChances));
        LootPool.Builder stickPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(shearsOrSilkTouch.invert()).add(stickEntryBuilder);
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(saplingAndLeavesPool).withPool(stickPool);
        this.registerLootTableBuilder(leavesBlock, tableBuilder);
    }

    protected void registerInfusedStoneTable(Block stoneBlock, Item dustItem) {
        LootPoolEntryContainer.Builder dustEntryBuilder = LootItem.lootTableItem((ItemLike)dustItem).when(ExplosionCondition.survivesExplosion());
        LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)stoneBlock).when(this.hasSilkTouch())).otherwise(dustEntryBuilder));
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(poolBuilder);
        this.registerLootTableBuilder(stoneBlock, tableBuilder);
    }

    protected void registerGemOreTable(Block oreBlock, Item gemItem) {
        Holder.Reference fortuneHolder = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        LootPoolSingletonContainer.Builder gemEntryBuilder = LootItem.lootTableItem((ItemLike)gemItem).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)fortuneHolder)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)oreBlock).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)gemEntryBuilder)));
        this.registerLootTableBuilder(oreBlock, tableBuilder);
    }

    protected void registerMultiGemOreTable(Block oreBlock, Item gemItem, float minGems, float maxGems) {
        Holder.Reference fortuneHolder = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        LootPoolSingletonContainer.Builder gemEntryBuilder = LootItem.lootTableItem((ItemLike)gemItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minGems, (float)maxGems))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortuneHolder)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)oreBlock).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)gemEntryBuilder)));
        this.registerLootTableBuilder(oreBlock, tableBuilder);
    }

    protected void registerManaBearingDeviceTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponentsPM.CAPABILITY_MANA_STORAGE.get()))).when(ExplosionCondition.survivesExplosion());
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerPulsingLogTable(Block block) {
        LootPool.Builder logBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).when(ExplosionCondition.survivesExplosion());
        LootPool.Builder pulseBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsPM.HEARTWOOD.get()))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AbstractPhasingLogBlock.PULSING, true)));
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(logBuilder).withPool(pulseBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerSplittingTable(Block block, Item splitItem, NumberProvider splitCount, OptionalInt maxWithFortune) {
        Holder.Reference fortuneHolder = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)splitItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)splitCount));
        if (maxWithFortune.isPresent()) {
            builder = builder.apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortuneHolder)).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)maxWithFortune.getAsInt())));
        }
        builder = builder.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)builder)));
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerPottedPlant(FlowerPotBlock block) {
        this.registeredBlocks.add(Services.BLOCKS_REGISTRY.getKey(block));
        this.dropPottedContents((Block)block);
    }

    private void checkExpectations() {
        Set<ResourceLocation> blocks = Services.BLOCKS_REGISTRY.getAllKeys().stream().filter(loc -> loc.getNamespace().equals("primalmagick")).collect(Collectors.toSet());
        blocks.removeAll(this.registeredBlocks);
        blocks.forEach(key -> LOGGER.warn("Missing block loot table for {}", (Object)key.toString()));
    }
}

