/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_modifiers;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.loot.conditions.MatchBlockTag;
import com.verdantartifice.primalmagick.common.loot.modifiers.AddItemModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.BloodNotesModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.BloodyFleshModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.BonusNuggetModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.BountyFarmingModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.BountyFishingModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.EssenceThiefModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.FourLeafCloverModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.GuillotineModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.RelicFragmentsModifier;
import com.verdantartifice.primalmagick.common.loot.modifiers.ReplaceItemModifier;
import com.verdantartifice.primalmagick.common.tags.BlockExtensionTags;
import com.verdantartifice.primalmagick.common.tags.BlockTagsPM;
import com.verdantartifice.primalmagick.common.tags.CommonTags;
import com.verdantartifice.primalmagick.common.tags.EntityTypeTagsPM;
import com.verdantartifice.primalmagick.common.tags.ItemExtensionTags;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class LootModifierProviderNeoforge
extends GlobalLootModifierProvider {
    public LootModifierProviderNeoforge(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, "primalmagick");
    }

    protected void start() {
        HolderLookup.RegistryLookup enchLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.add("bloody_flesh", (IGlobalLootModifier)new BloodyFleshModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.5f, (float)0.1f).build()}, EntityTypeTagsPM.DROPS_BLOODY_FLESH), new ICondition[0]);
        this.add("bounty_farming", (IGlobalLootModifier)new BountyFarmingModifier(new LootItemCondition[]{MatchBlockTag.builder(BlockTagsPM.BOUNTY_CROPS).build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchLookup.getOrThrow(EnchantmentsPM.BOUNTY), MinMaxBounds.Ints.atLeast((int)1)))))).build()}, 0.25f), new ICondition[0]);
        this.add("bounty_fishing", (IGlobalLootModifier)new BountyFishingModifier(new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FishingHookPredicate.inOpenWater((boolean)true))).build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchLookup.getOrThrow(EnchantmentsPM.BOUNTY), MinMaxBounds.Ints.atLeast((int)1)))))).build()}, 0.25f), new ICondition[0]);
        this.add("lucky_strike", (IGlobalLootModifier)new BonusNuggetModifier(new LootItemCondition[]{MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchLookup.getOrThrow(EnchantmentsPM.LUCKY_STRIKE), MinMaxBounds.Ints.atLeast((int)1)))))).build()}, (Map<TagKey<Block>, TagKey<Item>>)ImmutableMap.builder().put(CommonTags.Blocks.ORES_IRON, CommonTags.Items.NUGGETS_IRON).put(CommonTags.Blocks.ORES_GOLD, CommonTags.Items.NUGGETS_GOLD).put(CommonTags.Blocks.ORES_QUARTZ, ItemExtensionTags.NUGGETS_QUARTZ).put(CommonTags.Blocks.ORES_COPPER, ItemExtensionTags.NUGGETS_COPPER).put(BlockExtensionTags.ORES_TIN, ItemExtensionTags.NUGGETS_TIN).put(BlockExtensionTags.ORES_LEAD, ItemExtensionTags.NUGGETS_LEAD).put(BlockExtensionTags.ORES_SILVER, ItemExtensionTags.NUGGETS_SILVER).put(BlockExtensionTags.ORES_URANIUM, ItemExtensionTags.NUGGETS_URANIUM).build(), 0.5f), new ICondition[0]);
        this.add("blood_notes_high", (IGlobalLootModifier)new BloodNotesModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.DROPS_BLOOD_NOTES_HIGH), new ICondition[0]);
        this.add("blood_notes_low", (IGlobalLootModifier)new BloodNotesModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.25f, (float)0.25f).build()}, EntityTypeTagsPM.DROPS_BLOOD_NOTES_LOW), new ICondition[0]);
        this.add("relic_fragments_high", (IGlobalLootModifier)new RelicFragmentsModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.DROPS_RELIC_FRAGMENTS_HIGH, 3, 5), new ICondition[0]);
        this.add("relic_fragments_low", (IGlobalLootModifier)new RelicFragmentsModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.1f, (float)0.05f).build()}, EntityTypeTagsPM.DROPS_RELIC_FRAGMENTS_LOW, 1, 1), new ICondition[0]);
        this.add("four_leaf_clover_short_grass", (IGlobalLootModifier)new FourLeafCloverModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.SHORT_GRASS).build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.004f, (float)0.003f).build()}), new ICondition[0]);
        this.add("four_leaf_clover_tall_grass", (IGlobalLootModifier)new FourLeafCloverModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.TALL_GRASS).build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.004f, (float)0.003f).build()}), new ICondition[0]);
        this.add("humming_artifact_abandoned_mineshaft", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.ABANDONED_MINESHAFT.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.6f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_ancient_city", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.ANCIENT_CITY.location()).build(), LootItemRandomChanceCondition.randomChance((float)1.0f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_bastion_treasure", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.BASTION_TREASURE.location()).build(), LootItemRandomChanceCondition.randomChance((float)1.0f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_buried_treasure", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.BURIED_TREASURE.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.8f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_desert_pyramid", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.DESERT_PYRAMID.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.6f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_end_city_treasure", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.END_CITY_TREASURE.location()).build(), LootItemRandomChanceCondition.randomChance((float)1.0f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_igloo_chest", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.IGLOO_CHEST.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.6f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_jungle_temple", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.JUNGLE_TEMPLE.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.6f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_nether_fortress", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.NETHER_BRIDGE.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.8f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_pillager_outpost", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.PILLAGER_OUTPOST.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.8f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_shipwreck_treasure", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.SHIPWRECK_TREASURE.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.6f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_simple_dungeon", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.SIMPLE_DUNGEON.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.4f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_stronghold_library", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.STRONGHOLD_LIBRARY.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.8f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_underwater_ruin_big", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.UNDERWATER_RUIN_BIG.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.8f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("humming_artifact_woodland_mansion", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.WOODLAND_MANSION.location()).build(), LootItemRandomChanceCondition.randomChance((float)1.0f).build()}, ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()), new ICondition[0]);
        this.add("essence_thief", (IGlobalLootModifier)new EssenceThiefModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build(), LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.1f, (float)0.05f).build()}), new ICondition[0]);
        this.add("guillotine_zombie_head", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_ZOMBIE_HEAD, Items.ZOMBIE_HEAD, 0.1f), new ICondition[0]);
        this.add("guillotine_skeleton_skull", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_SKELETON_SKULL, Items.SKELETON_SKULL, 0.1f), new ICondition[0]);
        this.add("guillotine_creeper_head", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_CREEPER_HEAD, Items.CREEPER_HEAD, 0.1f), new ICondition[0]);
        this.add("guillotine_dragon_head", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_DRAGON_HEAD, Items.DRAGON_HEAD, 0.1f), new ICondition[0]);
        this.add("guillotine_wither_skeleton_skull", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_WITHER_SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, 0.1f), new ICondition[0]);
        this.add("guillotine_piglin_head", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_PIGLIN_HEAD, Items.PIGLIN_HEAD, 0.1f), new ICondition[0]);
        this.add("guillotine_player_head", (IGlobalLootModifier)new GuillotineModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build()}, EntityTypeTagsPM.GUILLOTINE_PLAYER_HEAD, Items.PLAYER_HEAD, 0.1f), new ICondition[0]);
        this.add("lore_fragment_desert_well_archaeology", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.1f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_desert_pyramid_archaeology", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.1f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_trail_ruins_archaeology_common", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.02f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_trail_ruins_archaeology_rare", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.1f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_ocean_ruin_warm_archaeology", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.1f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_ocean_ruin_cold_archaeology", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY.location()).build(), LootItemRandomChanceCondition.randomChance((float)0.1f).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get()), new ICondition[0]);
        this.add("lore_fragment_underwater_ruin_small_chest", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.UNDERWATER_RUIN_SMALL.location()).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get(), UniformInt.of((int)1, (int)3)), new ICondition[0]);
        this.add("lore_fragment_underwater_ruin_big_chest", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.UNDERWATER_RUIN_BIG.location()).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get(), UniformInt.of((int)2, (int)6)), new ICondition[0]);
        this.add("lore_fragment_desert_pyramid_chest", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.DESERT_PYRAMID.location()).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get(), UniformInt.of((int)2, (int)6)), new ICondition[0]);
        this.add("lore_fragment_jungle_temple_chest", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.JUNGLE_TEMPLE.location()).build()}, ItemsPM.LORE_TABLET_FRAGMENT.get(), UniformInt.of((int)2, (int)6)), new ICondition[0]);
    }
}

