/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.linguistics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.datagen.linguistics.IFinishedGrid;
import com.verdantartifice.primalmagick.datagen.linguistics.IFinishedGridNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GridDefinitionBuilder {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final ResourceLocation key;
    protected ResourceKey<BookLanguage> bookLanguage;
    protected Vector2ic startPos;
    protected final List<IFinishedGridNode> nodes = new ArrayList<IFinishedGridNode>();
    protected final HolderLookup.Provider lookupProvider;

    protected GridDefinitionBuilder(@Nonnull ResourceLocation key, HolderLookup.Provider lookupProvider) {
        this.key = key;
        this.lookupProvider = lookupProvider;
    }

    public static GridDefinitionBuilder grid(@Nonnull ResourceLocation key, HolderLookup.Provider lookupProvider) {
        return new GridDefinitionBuilder(key, lookupProvider);
    }

    public static GridDefinitionBuilder grid(@Nonnull String keyNamespace, @Nonnull String keyPath, HolderLookup.Provider lookupProvider) {
        return GridDefinitionBuilder.grid(ResourceLocation.fromNamespaceAndPath((String)keyNamespace, (String)keyPath), lookupProvider);
    }

    public static GridDefinitionBuilder grid(@Nonnull String keyPath, HolderLookup.Provider lookupProvider) {
        return GridDefinitionBuilder.grid(ResourceUtils.loc(keyPath), lookupProvider);
    }

    public GridDefinitionBuilder language(@Nullable ResourceKey<BookLanguage> lang) {
        this.bookLanguage = lang;
        return this;
    }

    public GridDefinitionBuilder startPos(Vector2ic pos) {
        this.startPos = pos;
        return this;
    }

    public GridDefinitionBuilder startPos(int x, int y) {
        return this.startPos((Vector2ic)new Vector2i(x, y));
    }

    public GridDefinitionBuilder node(IFinishedGridNode node) {
        this.nodes.add(node);
        return this;
    }

    private void validate(ResourceLocation id) {
        int expected;
        if (this.key == null) {
            throw new IllegalStateException("No key for linguistics grid " + id.toString());
        }
        if (this.bookLanguage == null) {
            throw new IllegalStateException("No language for linguistics grid " + id.toString());
        }
        if (this.startPos == null) {
            throw new IllegalStateException("No start position for linguistics grid " + id.toString());
        }
        if (this.startPos.x() < 0 || this.startPos.x() > 7) {
            throw new IllegalStateException("Out of bounds start position X-coordinate for linguistics grid " + id.toString() + "; must be between 0 and 7");
        }
        if (this.startPos.y() < 0 || this.startPos.y() > 7) {
            throw new IllegalStateException("Out of bounds start position Y-coordinate for linguistics grid " + id.toString() + "; must be between 0 and 7");
        }
        HashSet nodePositions = new HashSet();
        this.nodes.forEach(node -> {
            Vector2ic pos = node.getPosition();
            if (!nodePositions.add(pos)) {
                throw new IllegalStateException("Duplicate node position (" + pos.x() + "," + pos.y() + ") for linguistics grid " + id.toString());
            }
        });
        if (!nodePositions.contains(this.startPos)) {
            throw new IllegalStateException("Start position not among defined nodes for linguistics grid " + id.toString());
        }
        Holder.Reference langHolder = this.lookupProvider.lookupOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getOrThrow(this.bookLanguage);
        int total = this.nodes.stream().map(IFinishedGridNode::getReward).map(r -> r.getComprehensionPoints(this.bookLanguage.location())).mapToInt(o -> o.orElse(0)).sum();
        if (total != (expected = ((BookLanguage)langHolder.value()).complexity())) {
            throw new IllegalStateException("Comprehension mismatch for linguistics grid " + id.toString() + "; expected " + expected + ", got " + total);
        }
    }

    public void build(Consumer<IFinishedGrid> consumer) {
        this.build(consumer, this.key);
    }

    public void build(Consumer<IFinishedGrid> consumer, String name) {
        this.build(consumer, ResourceLocation.parse((String)name));
    }

    public void build(Consumer<IFinishedGrid> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(new Result(this.key, this.bookLanguage.location(), this.startPos, this.nodes));
    }

    public static class Result
    implements IFinishedGrid {
        protected final ResourceLocation key;
        protected final ResourceLocation bookLanguage;
        protected final Vector2ic startPos;
        protected final List<IFinishedGridNode> nodes;

        public Result(ResourceLocation key, ResourceLocation bookLanguage, Vector2ic startPos, List<IFinishedGridNode> nodes) {
            this.key = key;
            this.bookLanguage = bookLanguage;
            this.startPos = startPos;
            this.nodes = nodes;
        }

        @Override
        public ResourceLocation getId() {
            return this.key;
        }

        @Override
        public void serialize(JsonObject json) {
            json.addProperty("key", this.key.toString());
            json.addProperty("language", this.bookLanguage.toString());
            json.addProperty("start_x", (Number)this.startPos.x());
            json.addProperty("start_y", (Number)this.startPos.y());
            JsonArray nodesArray = new JsonArray();
            this.nodes.forEach(node -> nodesArray.add((JsonElement)node.getNodeJson()));
            json.add("nodes", (JsonElement)nodesArray);
        }
    }
}

