/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang.builders;

import com.verdantartifice.primalmagick.datagen.lang.builders.AbstractLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentLanguageBuilder
extends AbstractLanguageBuilder<ResourceKey<Enchantment>, EnchantmentLanguageBuilder> {
    public EnchantmentLanguageBuilder(ResourceKey<Enchantment> enchKey, Consumer<ILanguageBuilder> untracker, BiConsumer<String, String> adder) {
        super(enchKey, () -> Util.makeDescriptionId((String)"enchantment", (ResourceLocation)enchKey.location()), untracker, adder);
    }

    @Override
    public String getBuilderKey() {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)this.getBaseRegistryKey()).toString();
    }

    @Override
    protected ResourceLocation getBaseRegistryKey(ResourceKey<Enchantment> base) {
        return Objects.requireNonNull(base).location();
    }

    public EnchantmentLanguageBuilder description(String value) {
        this.add(this.getKey("desc"), value);
        return this;
    }

    public EnchantmentLanguageBuilder fullRuneText(String value) {
        this.add(this.getKey("rune_enchantment", "text"), value);
        return this;
    }

    public EnchantmentLanguageBuilder partialRuneText(String value) {
        this.add(this.getKey("rune_enchantment", "partial_text"), value);
        return this;
    }
}

