/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang.builders;

import com.verdantartifice.primalmagick.datagen.lang.builders.AbstractLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockLanguageBuilder
extends AbstractLanguageBuilder<Block, BlockLanguageBuilder> {
    public BlockLanguageBuilder(Block block, Consumer<ILanguageBuilder> untracker, BiConsumer<String, String> adder) {
        super(block, () -> ((Block)block).getDescriptionId(), untracker, adder);
    }

    @Override
    public String getBuilderKey() {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.getBaseRegistryKey()).toString();
    }

    @Override
    protected ResourceLocation getBaseRegistryKey(Block base) {
        return Objects.requireNonNull(Services.BLOCKS_REGISTRY.getKey(base));
    }

    public BlockLanguageBuilder tooltip(String value) {
        this.add(this.getKey("tooltip"), value);
        return this;
    }

    public BlockLanguageBuilder tooltip(String ... values) {
        int index = 1;
        for (String value : values) {
            this.add(this.getKey("tooltip", Integer.toString(index++)), value);
        }
        return this;
    }
}

