/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.items;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.armor.RobeArmorItem;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.common.items.entities.PixieHouseItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.food.AmbrosiaItem;
import com.verdantartifice.primalmagick.common.items.misc.AttunementShacklesItem;
import com.verdantartifice.primalmagick.common.items.misc.HummingArtifactItem;
import com.verdantartifice.primalmagick.common.items.misc.PixieItemNeoforge;
import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.items.misc.SanguineCoreItem;
import com.verdantartifice.primalmagick.common.items.tools.ManaOrbItem;
import com.verdantartifice.primalmagick.common.items.tools.SpelltomeItem;
import com.verdantartifice.primalmagick.common.items.wands.StaffCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCapItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandGemItem;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.datagen.items.ItemModelBuilderPMNeoforge;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProviderPMNeoforge
extends ModelProvider<ItemModelBuilderPMNeoforge> {
    private static final List<ResourceKey<TrimMaterial>> SUPPORTED_TRIMS = ImmutableList.builder().add((Object[])new ResourceKey[]{TrimMaterials.AMETHYST, TrimMaterials.COPPER, TrimMaterials.DIAMOND, TrimMaterials.EMERALD, TrimMaterials.GOLD, TrimMaterials.IRON, TrimMaterials.LAPIS, TrimMaterials.NETHERITE, TrimMaterials.QUARTZ, TrimMaterials.REDSTONE}).build();
    private final CompletableFuture<HolderLookup.Provider> lookupProviderFuture;

    public ItemModelProviderPMNeoforge(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper exFileHelper) {
        super(output, "primalmagick", "item", ItemModelBuilderPMNeoforge::new, exFileHelper);
        this.lookupProviderFuture = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.lookupProviderFuture.thenApply(p -> {
            this.clear();
            this.registerModels((HolderLookup.Provider)p);
            return p;
        })).thenCompose(p -> this.generateAll(cache));
    }

    public void clear() {
        super.clear();
    }

    public CompletableFuture<?> generateAll(CachedOutput cache) {
        return super.generateAll(cache);
    }

    public String getName() {
        return "Item Models: " + this.modid;
    }

    protected void registerModels() {
    }

    protected void registerModels(HolderLookup.Provider lookupProvider) {
        this.basicItem(ItemsPM.HYDROMELON_SEEDS.get());
        this.basicItem(ItemsPM.HYDROMELON_SLICE.get());
        this.itemWithParent(ItemsPM.SALTED_BAKED_POTATO.get(), Items.BAKED_POTATO);
        this.itemWithParent(ItemsPM.SALTED_COOKED_BEEF.get(), Items.COOKED_BEEF);
        this.itemWithParent(ItemsPM.SALTED_COOKED_CHICKEN.get(), Items.COOKED_CHICKEN);
        this.itemWithParent(ItemsPM.SALTED_COOKED_COD.get(), Items.COOKED_COD);
        this.itemWithParent(ItemsPM.SALTED_COOKED_MUTTON.get(), Items.COOKED_MUTTON);
        this.itemWithParent(ItemsPM.SALTED_COOKED_PORKCHOP.get(), Items.COOKED_PORKCHOP);
        this.itemWithParent(ItemsPM.SALTED_COOKED_RABBIT.get(), Items.COOKED_RABBIT);
        this.itemWithParent(ItemsPM.SALTED_COOKED_SALMON.get(), Items.COOKED_SALMON);
        this.itemWithParent(ItemsPM.SALTED_BEETROOT_SOUP.get(), Items.BEETROOT_SOUP);
        this.itemWithParent(ItemsPM.SALTED_MUSHROOM_STEW.get(), Items.MUSHROOM_STEW);
        this.itemWithParent(ItemsPM.SALTED_RABBIT_STEW.get(), Items.RABBIT_STEW);
        this.basicItem(ItemsPM.IRON_GRIT.get());
        this.basicItem(ItemsPM.GOLD_GRIT.get());
        this.basicItem(ItemsPM.COPPER_GRIT.get());
        this.basicItem(ItemsPM.SALT_PINCH.get());
        this.basicItem(ItemsPM.PRIMALITE_INGOT.get());
        this.basicItem(ItemsPM.HEXIUM_INGOT.get());
        this.basicItem(ItemsPM.HALLOWSTEEL_INGOT.get());
        this.basicItem(ItemsPM.PRIMALITE_NUGGET.get());
        this.basicItem(ItemsPM.HEXIUM_NUGGET.get());
        this.basicItem(ItemsPM.HALLOWSTEEL_NUGGET.get());
        this.basicItem(ItemsPM.QUARTZ_NUGGET.get());
        this.basicItem(ItemsPM.ENERGIZED_AMETHYST.get());
        this.basicItem(ItemsPM.ENERGIZED_DIAMOND.get());
        this.basicItem(ItemsPM.ENERGIZED_EMERALD.get());
        this.basicItem(ItemsPM.ENERGIZED_QUARTZ.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_SWORD.get());
        this.tridentItem(ItemsPM.PRIMALITE_TRIDENT.get());
        this.bowItem(ItemsPM.PRIMALITE_BOW.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_AXE.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_HOE.get());
        this.fishingRodItem(ItemsPM.PRIMALITE_FISHING_ROD.get());
        this.shieldItem(ItemsPM.PRIMALITE_SHIELD.get(), this.blockTexture(BlocksPM.PRIMALITE_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.HEXIUM_SWORD.get());
        this.tridentItem(ItemsPM.HEXIUM_TRIDENT.get());
        this.bowItem(ItemsPM.HEXIUM_BOW.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_AXE.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_HOE.get());
        this.fishingRodItem(ItemsPM.HEXIUM_FISHING_ROD.get());
        this.shieldItem(ItemsPM.HEXIUM_SHIELD.get(), this.blockTexture(BlocksPM.HEXIUM_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_SWORD.get());
        this.tridentItem(ItemsPM.HALLOWSTEEL_TRIDENT.get());
        this.bowItem(ItemsPM.HALLOWSTEEL_BOW.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_AXE.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_HOE.get());
        this.fishingRodItem(ItemsPM.HALLOWSTEEL_FISHING_ROD.get());
        this.shieldItem(ItemsPM.HALLOWSTEEL_SHIELD.get(), this.blockTexture(BlocksPM.HALLOWSTEEL_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.FORBIDDEN_SWORD.get());
        this.tridentItem(ItemsPM.FORBIDDEN_TRIDENT.get());
        this.bowItem(ItemsPM.FORBIDDEN_BOW.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_AXE.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_HOE.get());
        this.fishingRodItem(ItemsPM.PRIMAL_FISHING_ROD.get());
        this.spelltomeItem(ItemsPM.SPELLTOME_APPRENTICE.get());
        this.spelltomeItem(ItemsPM.SPELLTOME_ADEPT.get());
        this.spelltomeItem(ItemsPM.SPELLTOME_WIZARD.get());
        this.spelltomeItem(ItemsPM.SPELLTOME_ARCHMAGE.get());
        this.manaOrbItem(ItemsPM.MANA_ORB_APPRENTICE.get());
        this.manaOrbItem(ItemsPM.MANA_ORB_ADEPT.get());
        this.manaOrbItem(ItemsPM.MANA_ORB_WIZARD.get());
        this.manaOrbItem(ItemsPM.MANA_ORB_ARCHMAGE.get());
        ManaArrowItem.getManaArrows().forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_mana_arrow")));
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_FEET.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.PRIMALITE_HEAD.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.PRIMALITE_CHEST.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.PRIMALITE_LEGS.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.PRIMALITE_FEET.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HEXIUM_HEAD.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HEXIUM_CHEST.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HEXIUM_LEGS.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HEXIUM_FEET.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HALLOWSTEEL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HALLOWSTEEL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HALLOWSTEEL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims(ItemsPM.HALLOWSTEEL_FEET.get(), lookupProvider);
        this.basicItem(ItemsPM.GRIMOIRE.get());
        this.basicItem(ItemsPM.CREATIVE_GRIMOIRE.get());
        this.basicItem(ItemsPM.MAGNIFYING_GLASS.get());
        this.basicItem(ItemsPM.ALCHEMICAL_WASTE.get());
        this.basicItem(ItemsPM.BLOODY_FLESH.get());
        this.basicItem(ItemsPM.HALLOWED_ORB.get());
        this.basicItem(ItemsPM.HEARTWOOD.get());
        this.basicItem(ItemsPM.ENCHANTED_INK.get());
        this.basicItem(ItemsPM.ENCHANTED_INK_AND_QUILL.get());
        this.basicItem(ItemsPM.SEASCRIBE_PEN.get());
        this.basicItem(ItemsPM.ROCK_SALT.get());
        this.basicItem(ItemsPM.EARTHSHATTER_HAMMER.get());
        this.basicItem(ItemsPM.MANA_PRISM.get());
        this.basicItem(ItemsPM.TALLOW.get());
        this.basicItem(ItemsPM.BEESWAX.get());
        this.basicItem(ItemsPM.MANA_SALTS.get());
        this.basicItem(ItemsPM.MANAFRUIT.get());
        this.basicItem(ItemsPM.INCENSE_STICK.get());
        this.basicItem(ItemsPM.SOUL_GEM.get());
        this.basicItem(ItemsPM.SOUL_GEM_SLIVER.get());
        this.basicItem(ItemsPM.SPELLCLOTH.get());
        this.basicItem(ItemsPM.HEXWEAVE.get());
        this.basicItem(ItemsPM.SAINTSWOOL.get());
        this.basicItem(ItemsPM.MAGITECH_PARTS_BASIC.get());
        this.basicItem(ItemsPM.MAGITECH_PARTS_ENCHANTED.get());
        this.basicItem(ItemsPM.MAGITECH_PARTS_FORBIDDEN.get());
        this.basicItem(ItemsPM.MAGITECH_PARTS_HEAVENLY.get());
        this.dyeableItem(ItemsPM.FLYING_CARPET.get(), DyeColor.WHITE);
        this.basicItem(ItemsPM.DREAM_VISION_TALISMAN.get());
        this.basicItem(ItemsPM.IGNYX.get());
        this.basicItem(ItemsPM.DOWSING_ROD.get());
        this.basicItem(ItemsPM.FOUR_LEAF_CLOVER.get());
        this.basicItem(ItemsPM.RECALL_STONE.get());
        this.basicItem((Item)ItemsPM.RUNIC_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        this.basicItem(ItemsPM.BASIC_WARDING_MODULE.get());
        this.basicItem(ItemsPM.GREATER_WARDING_MODULE.get());
        this.basicItem(ItemsPM.SUPREME_WARDING_MODULE.get());
        this.pixieHouseItem(ItemsPM.PIXIE_HOUSE.get(), this.blockTexture(Blocks.OAK_LOG));
        this.basicItem(ItemsPM.OBSERVATION_NOTES.get());
        this.basicItem(ItemsPM.THEORY_NOTES.get());
        this.basicItem(ItemsPM.MYSTICAL_RELIC.get());
        this.basicItem(ItemsPM.MYSTICAL_RELIC_FRAGMENT.get());
        this.basicItem(ItemsPM.BLOOD_NOTES.get());
        this.basicItem(ItemsPM.SHEEP_TOME.get());
        EssenceItem.getAllEssences().forEach(this::basicItem);
        this.basicItem(ItemsPM.RUNE_UNATTUNED.get());
        RuneItem.getAllRunes().forEach(this::basicItem);
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.BASIC).forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_ambrosia")));
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.GREATER).forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_ambrosia_greater")));
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.SUPREME).forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_ambrosia_supreme")));
        AttunementShacklesItem.getAllShackles().forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_attunement_shackles")));
        this.basicItem(ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get());
        HummingArtifactItem.getAllHummingArtifacts().forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_humming_artifact")));
        this.itemWithParent(ItemsPM.SANGUINE_CORE_BLANK.get(), ResourceUtils.loc("item/template_sanguine_core"));
        SanguineCoreItem.getAllCores().forEach(item -> this.itemWithParent((Item)item, ResourceUtils.loc("item/template_sanguine_core")));
        this.basicItem(ItemsPM.SKYGLASS_FLASK.get());
        this.itemWithOverlay(ItemsPM.CONCOCTION.get());
        this.basicItem(ItemsPM.BOMB_CASING.get());
        this.itemWithOverlay(ItemsPM.ALCHEMICAL_BOMB.get());
        this.basicItem(ItemsPM.SPELL_SCROLL_BLANK.get());
        this.basicItem(ItemsPM.SPELL_SCROLL_FILLED.get());
        WandCoreItem.getAllCores().forEach(this::basicItem);
        StaffCoreItem.getAllCores().forEach(this::basicItem);
        WandCapItem.getAllCaps().forEach(this::basicItem);
        WandGemItem.getAllGems().forEach(this::basicItem);
        this.spawnEggItem(ItemsPM.TREEFOLK_SPAWN_EGG.get());
        this.spawnEggItem(ItemsPM.PRIMALITE_GOLEM_SPAWN_EGG.get());
        this.spawnEggItem(ItemsPM.HEXIUM_GOLEM_SPAWN_EGG.get());
        this.spawnEggItem(ItemsPM.HALLOWSTEEL_GOLEM_SPAWN_EGG.get());
        PixieItemNeoforge.getAllPixies().forEach(this::pixieItem);
        this.basicItem(ItemsPM.STATIC_BOOK.get());
        this.basicItem(ItemsPM.STATIC_BOOK_UNCOMMON.get());
        this.basicItem(ItemsPM.STATIC_BOOK_RARE.get());
        this.itemWithParent((Item)ItemsPM.STATIC_TABLET.get(), ItemsPM.MYSTICAL_RELIC.get());
        this.itemWithParent(ItemsPM.LORE_TABLET_FRAGMENT.get(), ItemsPM.MYSTICAL_RELIC_FRAGMENT.get());
        this.itemWithParent((Item)ItemsPM.LORE_TABLET_DIRTY.get(), ItemsPM.MYSTICAL_RELIC.get());
        this.itemWithParent((Item)ItemsPM.TICK_STICK.get(), Items.STICK);
    }

    private ResourceLocation key(Item item) {
        return Objects.requireNonNull(Services.ITEMS_REGISTRY.getKey(item));
    }

    private ResourceLocation key(Block block) {
        return Objects.requireNonNull(Services.BLOCKS_REGISTRY.getKey(block));
    }

    private ItemModelBuilderPMNeoforge builder(Item item) {
        return this.builder(this.key(item));
    }

    private ItemModelBuilderPMNeoforge builder(ResourceLocation loc) {
        return (ItemModelBuilderPMNeoforge)this.getBuilder(loc.toString());
    }

    private ResourceLocation defaultModelLoc(Item item) {
        return this.key(item).withPrefix("item/");
    }

    private ModelFile existingModel(ResourceLocation modelLoc) {
        return new ModelFile.ExistingModelFile(modelLoc, this.existingFileHelper);
    }

    private ModelFile uncheckedModel(ResourceLocation modelLoc) {
        return new ModelFile.UncheckedModelFile(modelLoc);
    }

    private ResourceLocation blockTexture(Block block) {
        return this.key(block).withPrefix("block/");
    }

    public ItemModelBuilderPMNeoforge basicItem(Item item) {
        ResourceLocation key = this.key(item);
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(key).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("item/" + key.getPath())));
    }

    private ItemModelBuilderPMNeoforge itemWithParent(Item item, Item parent) {
        return this.itemWithParent(item, this.defaultModelLoc(parent));
    }

    private ItemModelBuilderPMNeoforge itemWithParent(Item item, ResourceLocation parent) {
        return (ItemModelBuilderPMNeoforge)this.builder(item).parent(this.existingModel(parent));
    }

    private ItemModelBuilderPMNeoforge handheldItem(Item item) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(item).parent(this.existingModel(ResourceLocation.withDefaultNamespace((String)"item/handheld")))).texture("layer0", this.defaultModelLoc(item));
    }

    private ItemModelBuilderPMNeoforge tridentItem(TridentItem item) {
        ItemModelBuilderPMNeoforge throwingModel = this.tridentThrowingModel(item);
        ItemModelBuilderPMNeoforge inHandModel = this.tridentInHandModel(item, (ModelFile)throwingModel);
        return this.basicItem((Item)item).override().predicate(ResourceLocation.withDefaultNamespace((String)"throwing"), 0.0f).model((ModelFile)inHandModel).end().override().predicate(ResourceLocation.withDefaultNamespace((String)"throwing"), 1.0f).model((ModelFile)throwingModel).end();
    }

    private ItemModelBuilderPMNeoforge tridentInHandModel(TridentItem item, ModelFile throwingModel) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(this.key((Item)item).withSuffix("_in_hand")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", this.defaultModelLoc((Item)item))).override().predicate(ResourceLocation.withDefaultNamespace((String)"throwing"), 1.0f).model(throwingModel).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(11.0f, 17.0f, -2.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(3.0f, 17.0f, 12.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.GUI).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().end();
    }

    private ItemModelBuilderPMNeoforge tridentThrowingModel(TridentItem item) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(this.key((Item)item).withSuffix("_throwing")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", this.defaultModelLoc((Item)item))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, 9.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, -7.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.GUI).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().end();
    }

    private ItemModelBuilderPMNeoforge bowItem(BowItem item) {
        ResourceLocation pulling = ResourceLocation.withDefaultNamespace((String)"pulling");
        ResourceLocation pull = ResourceLocation.withDefaultNamespace((String)"pull");
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.defaultModelLoc((Item)item))).override().predicate(pulling, 1.0f).model((ModelFile)this.bowPullingModel(item, 0)).end().override().predicate(pulling, 1.0f).predicate(pull, 0.65f).model((ModelFile)this.bowPullingModel(item, 1)).end().override().predicate(pulling, 1.0f).predicate(pull, 0.9f).model((ModelFile)this.bowPullingModel(item, 2)).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().end();
    }

    private ItemModelBuilderPMNeoforge bowPullingModel(BowItem item, int stage) {
        ResourceLocation stageKey = this.key((Item)item).withSuffix("_pulling_" + stage);
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(stageKey).parent(this.uncheckedModel(this.defaultModelLoc((Item)item)))).texture("layer0", stageKey.withPrefix("item/"));
    }

    private ItemModelBuilderPMNeoforge fishingRodItem(FishingRodItem item) {
        return ((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld_rod"))).texture("layer0", this.defaultModelLoc((Item)item))).override().predicate(ResourceLocation.withDefaultNamespace((String)"cast"), 1.0f).model((ModelFile)this.fishingRodCastModel(item)).end();
    }

    private ItemModelBuilderPMNeoforge fishingRodCastModel(FishingRodItem item) {
        ResourceLocation castKey = this.key((Item)item).withSuffix("_cast");
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(castKey).parent(this.uncheckedModel(this.defaultModelLoc((Item)item)))).texture("layer0", castKey.withPrefix("item/"));
    }

    private ItemModelBuilderPMNeoforge shieldItem(ShieldItem item, ResourceLocation particleTexture) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", particleTexture)).override().predicate(ResourceLocation.withDefaultNamespace((String)"blocking"), 1.0f).model((ModelFile)this.shieldBlockingModel(item, particleTexture)).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(10.0f, 6.0f, -4.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(10.0f, 6.0f, 12.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, 5.0f).translation(-10.0f, 2.0f, -10.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 180.0f, 5.0f).translation(10.0f, 0.0f, -10.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 4.0f, 2.0f).scale(0.25f).end().end();
    }

    private ItemModelBuilderPMNeoforge shieldBlockingModel(ShieldItem item, ResourceLocation particleTexture) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(this.key((Item)item).withSuffix("_blocking")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", particleTexture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(45.0f, 135.0f, 0.0f).translation(3.51f, 11.0f, -2.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(45.0f, 135.0f, 0.0f).translation(13.51f, 3.0f, 5.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, -5.0f).translation(-15.0f, 5.0f, -11.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 180.0f, -5.0f).translation(5.0f, 5.0f, -11.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().end();
    }

    private ItemModelBuilderPMNeoforge spelltomeItem(SpelltomeItem item) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(item).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(8.0f, 6.0f, -6.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, -90.0f, 0.0f).translation(-8.0f, 6.0f, -6.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(180.0f, 140.0f, -45.0f).translation(4.0f, -4.0f, 9.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(180.0f, -40.0f, 45.0f).translation(-9.0f, -3.0f, -5.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 5.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-5.0f, 8.0f, -8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(2.0f, 4.0f, 2.0f).scale(0.25f).end().end();
    }

    private ItemModelBuilderPMNeoforge manaOrbItem(ManaOrbItem item) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(item).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(8.0f, 8.0f, -6.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, -90.0f, 0.0f).translation(-8.0f, 8.0f, -6.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -20.0f, 0.0f).translation(15.0f, 8.0f, 2.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, -20.0f, 0.0f).translation(-2.0f, 8.0f, -7.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(4.0f, 2.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-8.0f, 6.0f, -8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(2.0f, 2.0f, 2.0f).scale(0.45f).end().end();
    }

    private ItemModelBuilderPMNeoforge armorItemWithTrims(ArmorItem item, HolderLookup.Provider lookupProvider) {
        return this.armorItemWithTrims(item, SUPPORTED_TRIMS, lookupProvider);
    }

    private ItemModelBuilderPMNeoforge armorItemWithTrims(ArmorItem item, List<ResourceKey<TrimMaterial>> trimKeys, HolderLookup.Provider lookupProvider) {
        return this.armorItemWithTrims(item, trimKeys.stream().map(key -> this.getTrimMaterial((ResourceKey<TrimMaterial>)key, lookupProvider)).toList());
    }

    private ItemModelBuilderPMNeoforge armorItemWithTrims(ArmorItem item, List<Holder<TrimMaterial>> trims) {
        return this.armorItemWithTrims(item, this.getArmorTrimOverlay(item), trims);
    }

    private ItemModelBuilderPMNeoforge armorItemWithTrims(ArmorItem item, ResourceLocation trimOverlayLoc, List<Holder<TrimMaterial>> trims) {
        ResourceLocation trimType = ResourceLocation.withDefaultNamespace((String)"trim_type");
        ItemModelBuilderPMNeoforge builder = this.basicItem((Item)item);
        List sortedTrims = trims.stream().sorted((m1, m2) -> Float.compare(((TrimMaterial)m1.value()).itemModelIndex(), ((TrimMaterial)m2.value()).itemModelIndex())).toList();
        for (Holder trim : sortedTrims) {
            builder = builder.override().predicate(trimType, ((TrimMaterial)trim.value()).itemModelIndex()).model((ModelFile)this.trimmedArmorModel(item, trimOverlayLoc, (Holder<TrimMaterial>)trim)).end();
        }
        return builder;
    }

    private ItemModelBuilderPMNeoforge trimmedArmorModel(ArmorItem item, ResourceLocation trimOverlayLoc, Holder<TrimMaterial> trim) {
        String palatteSuffix = this.getArmorTrimColorPaletteSuffix(trim, (Holder<ArmorMaterial>)item.getMaterial());
        return ((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(this.key((Item)item).withSuffix("_" + palatteSuffix + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.defaultModelLoc((Item)item))).palattedTexture("layer1", trimOverlayLoc, palatteSuffix);
    }

    private ResourceLocation getArmorTrimOverlay(ArmorItem item) {
        if (item instanceof RobeArmorItem) {
            return switch (item.getEquipmentSlot()) {
                case EquipmentSlot.HEAD -> ResourceUtils.loc("trims/items/robe_head_trim");
                case EquipmentSlot.CHEST -> ResourceUtils.loc("trims/items/robe_chest_trim");
                case EquipmentSlot.LEGS -> ResourceUtils.loc("trims/items/robe_legs_trim");
                case EquipmentSlot.FEET -> ResourceUtils.loc("trims/items/robe_feet_trim");
                default -> throw new IllegalArgumentException("Invalid armor type for trim overlay detection");
            };
        }
        return switch (item.getEquipmentSlot()) {
            case EquipmentSlot.HEAD -> ResourceLocation.withDefaultNamespace((String)"trims/items/helmet_trim");
            case EquipmentSlot.CHEST -> ResourceLocation.withDefaultNamespace((String)"trims/items/chestplate_trim");
            case EquipmentSlot.LEGS -> ResourceLocation.withDefaultNamespace((String)"trims/items/leggings_trim");
            case EquipmentSlot.FEET -> ResourceLocation.withDefaultNamespace((String)"trims/items/boots_trim");
            default -> throw new IllegalArgumentException("Invalid armor type for trim overlay detection");
        };
    }

    private Holder<TrimMaterial> getTrimMaterial(ResourceKey<TrimMaterial> key, HolderLookup.Provider lookupProvider) {
        return lookupProvider.lookupOrThrow(Registries.TRIM_MATERIAL).getOrThrow(key);
    }

    private String getArmorTrimColorPaletteSuffix(Holder<TrimMaterial> trimMaterial, Holder<ArmorMaterial> armorMaterial) {
        Map map = ((TrimMaterial)trimMaterial.value()).overrideArmorMaterials();
        return map.containsKey(armorMaterial) ? (String)map.get(armorMaterial) : ((TrimMaterial)trimMaterial.value()).assetName();
    }

    private ItemModelBuilderPMNeoforge itemWithOverlay(Item item) {
        ResourceLocation texture = this.defaultModelLoc(item);
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture.withSuffix("_overlay"))).texture("layer1", texture);
    }

    private ItemModelBuilderPMNeoforge spawnEggItem(SpawnEggItem item) {
        return this.itemWithParent((Item)item, ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
    }

    private void pixieItem(PixieItemNeoforge item) {
        this.itemWithParent((Item)item, ResourceUtils.loc("item/template_pixie"));
        ((ItemModelBuilderPMNeoforge)this.getBuilder(this.key((Item)item).withPrefix("drained_").toString())).parent(this.existingModel(ResourceUtils.loc("item/template_drained_pixie")));
    }

    private ItemModelBuilderPMNeoforge dyeableItem(Item item, DyeColor defaultColor) {
        ResourceLocation key = this.key(item);
        ItemModelBuilderPMNeoforge builder = (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(key).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("item/" + key.getPath() + "_" + defaultColor.getName())));
        List<DyeColor> sortedColors = Stream.of(DyeColor.values()).sorted((c1, c2) -> Integer.compare(c1.getId(), c2.getId())).toList();
        for (DyeColor color : sortedColors) {
            builder = builder.override().predicate(ResourceUtils.loc("color"), (float)color.getId() / 16.0f).model((ModelFile)this.dyedItemModel(item, color)).end();
        }
        return builder;
    }

    private ItemModelBuilderPMNeoforge dyedItemModel(Item item, DyeColor color) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(this.key(item).withSuffix("_" + color.getName())).parent(this.existingModel(this.defaultModelLoc(item)))).texture("layer0", this.defaultModelLoc(item).withSuffix("_" + color.getName()));
    }

    private ItemModelBuilderPMNeoforge pixieHouseItem(PixieHouseItem item, ResourceLocation particleTexture) {
        return (ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)((ItemModelBuilderPMNeoforge)this.builder(item).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", particleTexture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(6.0f, 12.0f, -3.75f).scale(0.7f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(6.0f, 12.0f, 5.75f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 5.0f).translation(7.0f, 7.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 0.0f, 5.0f).translation(-2.0f, 7.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 4.0f, 2.0f).scale(0.25f).end().end();
    }
}

