/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.blocks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.crafting.AbstractCalcinatorBlock;
import com.verdantartifice.primalmagick.common.blocks.crafting.ConcocterBlock;
import com.verdantartifice.primalmagick.common.blocks.crafting.RunescribingAltarBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.EssenceCaskBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.SanguineCrucibleBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.SunlampBlock;
import com.verdantartifice.primalmagick.common.blocks.golems.AbstractEnchantedGolemControllerBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.ManaInjectorBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.ManaRelayBlock;
import com.verdantartifice.primalmagick.common.blocks.misc.CarvedBookshelfBlock;
import com.verdantartifice.primalmagick.common.blocks.misc.PillarBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.BloodletterBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.IncenseBrazierBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.RitualCandleBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.SoulAnvilBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLeavesBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLogBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingPillarBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingSlabBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingStairsBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderPMNeoforge
extends BlockStateProvider {
    protected static final ResourceLocation SOLID = ResourceLocation.withDefaultNamespace((String)"solid");
    protected static final ResourceLocation CUTOUT = ResourceLocation.withDefaultNamespace((String)"cutout");
    protected static final ResourceLocation CUTOUT_MIPPED = ResourceLocation.withDefaultNamespace((String)"cutout_mipped");
    protected static final ResourceLocation TRANSLUCENT = ResourceLocation.withDefaultNamespace((String)"translucent");

    public BlockStateProviderPMNeoforge(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "primalmagick", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_RAW.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_SLAB.get(), BlocksPM.MARBLE_RAW.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_RAW.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_WALL.get(), this.blockTexture(BlocksPM.MARBLE_RAW.get()));
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_BRICKS.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_BRICK_SLAB.get(), BlocksPM.MARBLE_BRICKS.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_BRICK_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_BRICKS.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_BRICK_WALL.get(), this.blockTexture(BlocksPM.MARBLE_BRICKS.get()));
        this.pillarBlockWithItem(BlocksPM.MARBLE_PILLAR.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_CHISELED.get());
        this.cubeColumnBlockWithItem(BlocksPM.MARBLE_RUNED.get(), this.blockTexture(BlocksPM.MARBLE_RAW.get()));
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_TILES.get());
        this.carvedBookshelfBlockWithItem(BlocksPM.MARBLE_BOOKSHELF.get(), BlocksPM.MARBLE_RAW.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_ENCHANTED.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_ENCHANTED_SLAB.get(), BlocksPM.MARBLE_ENCHANTED.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_ENCHANTED_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_ENCHANTED_WALL.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED.get()));
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_ENCHANTED_BRICKS.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get(), BlocksPM.MARBLE_ENCHANTED_BRICKS.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED_BRICKS.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED_BRICKS.get()));
        this.pillarBlockWithItem(BlocksPM.MARBLE_ENCHANTED_PILLAR.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_ENCHANTED_CHISELED.get());
        this.cubeColumnBlockWithItem(BlocksPM.MARBLE_ENCHANTED_RUNED.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED.get()));
        this.carvedBookshelfBlockWithItem(BlocksPM.MARBLE_ENCHANTED_BOOKSHELF.get(), BlocksPM.MARBLE_ENCHANTED.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_SMOKED.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_SMOKED_SLAB.get(), BlocksPM.MARBLE_SMOKED.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_SMOKED_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_SMOKED_WALL.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED.get()));
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_SMOKED_BRICKS.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get(), BlocksPM.MARBLE_SMOKED_BRICKS.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED_BRICKS.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_SMOKED_BRICK_WALL.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED_BRICKS.get()));
        this.pillarBlockWithItem(BlocksPM.MARBLE_SMOKED_PILLAR.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_SMOKED_CHISELED.get());
        this.cubeColumnBlockWithItem(BlocksPM.MARBLE_SMOKED_RUNED.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED.get()));
        this.carvedBookshelfBlockWithItem(BlocksPM.MARBLE_SMOKED_BOOKSHELF.get(), BlocksPM.MARBLE_SMOKED.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_HALLOWED.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_HALLOWED_SLAB.get(), BlocksPM.MARBLE_HALLOWED.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_HALLOWED_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_HALLOWED_WALL.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED.get()));
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_HALLOWED_BRICKS.get());
        this.slabBlockWithItem(BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get(), BlocksPM.MARBLE_HALLOWED_BRICKS.get());
        this.stairsBlockWithItem(BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED_BRICKS.get()));
        this.wallBlockWithItem(BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED_BRICKS.get()));
        this.pillarBlockWithItem(BlocksPM.MARBLE_HALLOWED_PILLAR.get());
        this.simpleCubeBlockWithItem(BlocksPM.MARBLE_HALLOWED_CHISELED.get());
        this.cubeColumnBlockWithItem(BlocksPM.MARBLE_HALLOWED_RUNED.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED.get()));
        this.carvedBookshelfBlockWithItem(BlocksPM.MARBLE_HALLOWED_BOOKSHELF.get(), BlocksPM.MARBLE_HALLOWED.get());
        this.phasingLogBlockWithItem(BlocksPM.SUNWOOD_LOG.get());
        this.phasingLogBlockWithItem(BlocksPM.STRIPPED_SUNWOOD_LOG.get());
        this.phasingWoodBlockWithItem(BlocksPM.SUNWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.SUNWOOD_LOG.get()));
        this.phasingWoodBlockWithItem(BlocksPM.STRIPPED_SUNWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.STRIPPED_SUNWOOD_LOG.get()));
        this.phasingLeavesBlockWithItem(BlocksPM.SUNWOOD_LEAVES.get());
        this.saplingBlockWithPotAndItem((Block)BlocksPM.SUNWOOD_SAPLING.get(), BlocksPM.POTTED_SUNWOOD_SAPLING.get());
        this.phasingCubeBlockWithItem(BlocksPM.SUNWOOD_PLANKS.get());
        this.phasingSlabBlockWithItem(BlocksPM.SUNWOOD_SLAB.get(), BlocksPM.SUNWOOD_PLANKS.get());
        this.phasingStairsBlockWithItem(BlocksPM.SUNWOOD_STAIRS.get(), this.blockTexture(BlocksPM.SUNWOOD_PLANKS.get()));
        this.phasingPillarBlockWithItem(BlocksPM.SUNWOOD_PILLAR.get());
        this.phasingLogBlockWithItem(BlocksPM.MOONWOOD_LOG.get());
        this.phasingLogBlockWithItem(BlocksPM.STRIPPED_MOONWOOD_LOG.get());
        this.phasingWoodBlockWithItem(BlocksPM.MOONWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.MOONWOOD_LOG.get()));
        this.phasingWoodBlockWithItem(BlocksPM.STRIPPED_MOONWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.STRIPPED_MOONWOOD_LOG.get()));
        this.phasingLeavesBlockWithItem(BlocksPM.MOONWOOD_LEAVES.get());
        this.saplingBlockWithPotAndItem((Block)BlocksPM.MOONWOOD_SAPLING.get(), BlocksPM.POTTED_MOONWOOD_SAPLING.get());
        this.phasingCubeBlockWithItem(BlocksPM.MOONWOOD_PLANKS.get());
        this.phasingSlabBlockWithItem(BlocksPM.MOONWOOD_SLAB.get(), BlocksPM.MOONWOOD_PLANKS.get());
        this.phasingStairsBlockWithItem(BlocksPM.MOONWOOD_STAIRS.get(), this.blockTexture(BlocksPM.MOONWOOD_PLANKS.get()));
        this.phasingPillarBlockWithItem(BlocksPM.MOONWOOD_PILLAR.get());
        this.logBlockWithItem(BlocksPM.HALLOWOOD_LOG.get());
        this.logBlockWithItem(BlocksPM.STRIPPED_HALLOWOOD_LOG.get());
        this.woodBlockWithItem(BlocksPM.HALLOWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.HALLOWOOD_LOG.get()));
        this.woodBlockWithItem(BlocksPM.STRIPPED_HALLOWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.STRIPPED_HALLOWOOD_LOG.get()));
        this.leavesBlockWithItem(BlocksPM.HALLOWOOD_LEAVES.get());
        this.saplingBlockWithPotAndItem((Block)BlocksPM.HALLOWOOD_SAPLING.get(), BlocksPM.POTTED_HALLOWOOD_SAPLING.get());
        this.simpleCubeBlockWithItem(BlocksPM.HALLOWOOD_PLANKS.get());
        this.slabBlockWithItem(BlocksPM.HALLOWOOD_SLAB.get(), BlocksPM.HALLOWOOD_PLANKS.get());
        this.stairsBlockWithItem(BlocksPM.HALLOWOOD_STAIRS.get(), this.blockTexture(BlocksPM.HALLOWOOD_PLANKS.get()));
        this.pillarBlockWithItem(BlocksPM.HALLOWOOD_PILLAR.get());
        this.cubeColumnBlockWithItem(BlocksPM.HYDROMELON.get());
        this.stemBlock((Block)BlocksPM.HYDROMELON_STEM.get());
        this.attachedStemBlock((Block)BlocksPM.ATTACHED_HYDROMELON_STEM.get(), this.blockTexture((Block)BlocksPM.HYDROMELON_STEM.get()));
        this.tallCrossBlockWithItem((Block)BlocksPM.BLOOD_ROSE.get());
        this.tallExistingBlockWithItem((Block)BlocksPM.EMBERFLOWER.get(), this.blockTexture((Block)BlocksPM.EMBERFLOWER.get()).withSuffix("_front"));
        this.simpleCubeBlockWithItem(BlocksPM.INFUSED_STONE_EARTH.get());
        this.simpleCubeBlockWithItem(BlocksPM.INFUSED_STONE_SEA.get());
        this.simpleCubeBlockWithItem(BlocksPM.INFUSED_STONE_SKY.get());
        this.simpleCubeBlockWithItem(BlocksPM.INFUSED_STONE_SUN.get());
        this.simpleCubeBlockWithItem(BlocksPM.INFUSED_STONE_MOON.get());
        this.directionalCrossBlockWithItem(BlocksPM.SYNTHETIC_AMETHYST_CLUSTER.get());
        this.directionalCrossBlockWithItem(BlocksPM.LARGE_SYNTHETIC_AMETHYST_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.MEDIUM_SYNTHETIC_AMETHYST_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.SMALL_SYNTHETIC_AMETHYST_BUD.get());
        this.simpleCubeBlockWithItem(BlocksPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.FLAWED_BUDDING_AMETHYST_BLOCK.get());
        this.directionalCrossBlockWithItem(BlocksPM.SYNTHETIC_DIAMOND_CLUSTER.get());
        this.directionalCrossBlockWithItem(BlocksPM.LARGE_SYNTHETIC_DIAMOND_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.MEDIUM_SYNTHETIC_DIAMOND_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.SMALL_SYNTHETIC_DIAMOND_BUD.get());
        this.simpleCubeBlockWithItem(BlocksPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.FLAWED_BUDDING_DIAMOND_BLOCK.get());
        this.directionalCrossBlockWithItem(BlocksPM.SYNTHETIC_EMERALD_CLUSTER.get());
        this.directionalCrossBlockWithItem(BlocksPM.LARGE_SYNTHETIC_EMERALD_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.MEDIUM_SYNTHETIC_EMERALD_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.SMALL_SYNTHETIC_EMERALD_BUD.get());
        this.simpleCubeBlockWithItem(BlocksPM.DAMAGED_BUDDING_EMERALD_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.CHIPPED_BUDDING_EMERALD_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.FLAWED_BUDDING_EMERALD_BLOCK.get());
        this.directionalCrossBlockWithItem(BlocksPM.SYNTHETIC_QUARTZ_CLUSTER.get());
        this.directionalCrossBlockWithItem(BlocksPM.LARGE_SYNTHETIC_QUARTZ_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.MEDIUM_SYNTHETIC_QUARTZ_BUD.get());
        this.directionalCrossBlockWithItem(BlocksPM.SMALL_SYNTHETIC_QUARTZ_BUD.get());
        this.cubeColumnBlockWithItem(BlocksPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get());
        this.cubeColumnBlockWithItem(BlocksPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get());
        this.cubeColumnBlockWithItem(BlocksPM.FLAWED_BUDDING_QUARTZ_BLOCK.get());
        RitualCandleBlock.getAllCandles().forEach(this::ritualCandleBlockWithItem);
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.BASIC).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture(BlocksPM.MARBLE_RAW.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.ENCHANTED).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture(BlocksPM.MARBLE_ENCHANTED.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.FORBIDDEN).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture(BlocksPM.MARBLE_SMOKED.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.HEAVENLY).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture(BlocksPM.MARBLE_HALLOWED.get())));
        this.simpleExistingBlockWithItem(BlocksPM.ARCANE_WORKBENCH.get());
        this.horizontalExistingBlockWithItem(BlocksPM.WAND_ASSEMBLY_TABLE.get());
        this.simpleExistingBlockWithItem(BlocksPM.WOOD_TABLE.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem(BlocksPM.ANALYSIS_TABLE.get());
        this.calcinatorBlockWithItem(BlocksPM.ESSENCE_FURNACE.get(), state -> this.models().getExistingFile(ResourceUtils.loc("block/essence_furnace").withSuffix((Boolean)state.getValue((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : "")));
        this.calcinatorBlockWithItem(BlocksPM.CALCINATOR_BASIC.get());
        this.calcinatorBlockWithItem(BlocksPM.CALCINATOR_ENCHANTED.get());
        this.calcinatorBlockWithItem(BlocksPM.CALCINATOR_FORBIDDEN.get());
        this.calcinatorBlockWithItem(BlocksPM.CALCINATOR_HEAVENLY.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem(BlocksPM.WAND_INSCRIPTION_TABLE.get());
        this.spellcraftingAltarBlockWithItem();
        this.simpleExistingBlockWithItem((Block)BlocksPM.WAND_CHARGER.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.RESEARCH_TABLE.get());
        this.sunlampBlockWithItem(BlocksPM.SUNLAMP.get());
        this.sunlampBlockWithItem(BlocksPM.SPIRIT_LANTERN.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.RITUAL_ALTAR.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.OFFERING_PEDESTAL.get());
        this.incenseBrazierBlockWithItem();
        this.horizontalExistingBlockWithItem((Block)BlocksPM.RITUAL_LECTERN.get());
        this.ritualBellBlockWithItem();
        this.bloodletterBlockWithItem();
        this.horizontalBlockWithItem((Block)BlocksPM.SOUL_ANVIL.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.SOUL_ANVIL.get()).withSuffix((Boolean)state.getValue((Property)SoulAnvilBlock.DIRTY) != false ? "_dirty" : "")));
        this.runescribingAltarBlockWithItem(BlocksPM.RUNESCRIBING_ALTAR_BASIC.get(), this.blockTexture(BlocksPM.MARBLE_RAW.get()));
        this.runescribingAltarBlockWithItem(BlocksPM.RUNESCRIBING_ALTAR_ENCHANTED.get(), this.blockTexture(BlocksPM.MARBLE_ENCHANTED.get()));
        this.runescribingAltarBlockWithItem(BlocksPM.RUNESCRIBING_ALTAR_FORBIDDEN.get(), this.blockTexture(BlocksPM.MARBLE_SMOKED.get()));
        this.runescribingAltarBlockWithItem(BlocksPM.RUNESCRIBING_ALTAR_HEAVENLY.get(), this.blockTexture(BlocksPM.MARBLE_HALLOWED.get()));
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.RUNECARVING_TABLE.get());
        this.horizontalFaceExistingBlockWithItem((Block)BlocksPM.RUNIC_GRINDSTONE.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.HONEY_EXTRACTOR.get());
        this.golemControllerBlockWithItem(BlocksPM.PRIMALITE_GOLEM_CONTROLLER.get(), this.blockTexture(BlocksPM.PRIMALITE_BLOCK.get()));
        this.golemControllerBlockWithItem(BlocksPM.HEXIUM_GOLEM_CONTROLLER.get(), this.blockTexture(BlocksPM.HEXIUM_BLOCK.get()));
        this.golemControllerBlockWithItem(BlocksPM.HALLOWSTEEL_GOLEM_CONTROLLER.get(), this.blockTexture(BlocksPM.HALLOWSTEEL_BLOCK.get()));
        this.horizontalBlockWithItem((Block)BlocksPM.SANGUINE_CRUCIBLE.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.SANGUINE_CRUCIBLE.get()).withSuffix((Boolean)state.getValue((Property)SanguineCrucibleBlock.LIT) != false ? "_lit" : "")));
        this.horizontalBlockWithItem((Block)BlocksPM.CONCOCTER.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.CONCOCTER.get()).withSuffix((Boolean)state.getValue((Property)ConcocterBlock.HAS_BOTTLE) != false ? "_bottle" : "")));
        this.horizontalExistingBlockWithItem((Block)BlocksPM.CELESTIAL_HARP.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.ENTROPY_SINK.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.AUTO_CHARGER.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.ESSENCE_TRANSMUTER.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.DISSOLUTION_CHAMBER.get());
        this.directionalExistingBlockWithItem((Block)BlocksPM.ZEPHYR_ENGINE.get());
        this.directionalExistingBlockWithItem((Block)BlocksPM.VOID_TURBINE.get());
        this.essenceCaskBlockWithItem(BlocksPM.ESSENCE_CASK_ENCHANTED.get());
        this.essenceCaskBlockWithItem(BlocksPM.ESSENCE_CASK_FORBIDDEN.get());
        this.essenceCaskBlockWithItem(BlocksPM.ESSENCE_CASK_HEAVENLY.get());
        this.horizontalExistingBlockWithItem(BlocksPM.WAND_GLAMOUR_TABLE.get());
        this.infernalFurnaceBlockWithItem();
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_NEXUS.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_SINGULARITY.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_SINGULARITY_CREATIVE.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.SCRIBE_TABLE.get());
        this.manaRelayBlockWithItem(BlocksPM.MANA_RELAY_BASIC.get());
        this.manaRelayBlockWithItem(BlocksPM.MANA_RELAY_ENCHANTED.get());
        this.manaRelayBlockWithItem(BlocksPM.MANA_RELAY_FORBIDDEN.get());
        this.manaRelayBlockWithItem(BlocksPM.MANA_RELAY_HEAVENLY.get());
        this.manaInjectorBlockWithItem(BlocksPM.MANA_INJECTOR_BASIC.get());
        this.manaInjectorBlockWithItem(BlocksPM.MANA_INJECTOR_ENCHANTED.get());
        this.manaInjectorBlockWithItem(BlocksPM.MANA_INJECTOR_FORBIDDEN.get());
        this.manaInjectorBlockWithItem(BlocksPM.MANA_INJECTOR_HEAVENLY.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.DESALINATOR.get());
        this.emptyBlock((Block)BlocksPM.CONSECRATION_FIELD.get());
        this.emptyBlock(BlocksPM.GLOW_FIELD.get());
        this.emptyBlock(BlocksPM.SOUL_GLOW_FIELD.get());
        this.simpleCubeBlockWithItem(BlocksPM.ROCK_SALT_ORE.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.QUARTZ_ORE.get());
        this.simpleCubeBlockWithItem(BlocksPM.PRIMALITE_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.HEXIUM_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.HALLOWSTEEL_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.IGNYX_BLOCK.get());
        this.simpleCubeBlockWithItem(BlocksPM.SALT_BLOCK.get());
        this.crossBlockWithItem((Block)BlocksPM.TREEFOLK_SPROUT.get(), this.key((Item)ItemsPM.TREEFOLK_SEED.get()));
        this.horizontalExistingBlockWithBasicItem(BlocksPM.ENDERWARD.get());
    }

    private ResourceLocation key(Block block) {
        return Services.BLOCKS_REGISTRY.getKey(block);
    }

    private ResourceLocation key(Item item) {
        return Services.ITEMS_REGISTRY.getKey(item);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private ResourceLocation defaultModel(Block block) {
        return this.key(block).withPrefix("block/");
    }

    private void emptyBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(ResourceUtils.loc("block/empty")));
    }

    private void simpleCubeBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    private void simpleExistingBlockWithItem(Block block) {
        this.simpleExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void simpleExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void slabBlockWithItem(SlabBlock block, Block doubleSlabBlock) {
        this.slabBlockWithItem(block, doubleSlabBlock, this.blockTexture(doubleSlabBlock));
    }

    private void slabBlockWithItem(SlabBlock block, Block doubleSlabBlock, ResourceLocation texture) {
        String blockName = this.name((Block)block);
        ModelBuilder bottomModel = this.models().slab(blockName, texture, texture, texture);
        ModelBuilder topModel = this.models().slabTop(blockName + "_top", texture, texture, texture);
        this.slabBlock(block, (ModelFile)bottomModel, (ModelFile)topModel, (ModelFile)this.models().getExistingFile(this.key(doubleSlabBlock)));
        this.simpleBlockItem((Block)block, (ModelFile)bottomModel);
    }

    private void stairsBlockWithItem(StairBlock block, ResourceLocation texture) {
        String baseName = this.name((Block)block);
        ModelBuilder stairs = this.models().stairs(baseName, texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", texture, texture, texture);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)block, (ModelFile)stairs);
    }

    private void wallBlockWithItem(WallBlock block, ResourceLocation texture) {
        this.wallBlock(block, texture);
        ModelBuilder wallInv = this.models().wallInventory(this.name((Block)block) + "_inventory", texture);
        this.simpleBlockItem((Block)block, (ModelFile)wallInv);
    }

    private void cubeColumnBlockWithItem(Block block) {
        this.cubeColumnBlockWithItem(block, this.blockTexture(block).withSuffix("_side"), this.blockTexture(block).withSuffix("_end"));
    }

    private void cubeColumnBlockWithItem(Block block, ResourceLocation endTexture) {
        this.cubeColumnBlockWithItem(block, this.blockTexture(block), endTexture);
    }

    private void cubeColumnBlockWithItem(Block block, ResourceLocation sideTexture, ResourceLocation endTexture) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeColumn(this.name(block), sideTexture, endTexture));
    }

    private void pillarBlockWithItem(PillarBlock block) {
        this.pillarBlockWithItem(block, this.blockTexture(block));
    }

    private void pillarBlockWithItem(PillarBlock block, ResourceLocation texture) {
        this.pillarBlockWithItem(block, texture, texture.withSuffix("_inner"), texture.withSuffix("_top"), texture.withSuffix("_bottom"), texture.withSuffix("_base"));
    }

    private void pillarBlockWithItem(PillarBlock block, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation baseTexture) {
        ModelBuilder baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), ResourceUtils.loc("block/pillar"))).texture("side", sideTexture)).texture("inner", innerTexture);
        ModelBuilder topModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top", ResourceUtils.loc("block/pillar_top"))).texture("side", topTexture)).texture("inner", innerTexture)).texture("top", baseTexture);
        ModelBuilder bottomModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom", ResourceUtils.loc("block/pillar_bottom"))).texture("side", bottomTexture)).texture("inner", innerTexture)).texture("bottom", baseTexture);
        this.getVariantBuilder(block).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.BASE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)baseModel)}).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.TOP)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topModel)}).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.BOTTOM)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomModel)});
        this.simpleBlockItem(block, (ModelFile)baseModel);
    }

    private void phasingLogBlockWithItem(AbstractPhasingLogBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation sideTexture = this.blockTexture((Block)block).withSuffix("_" + phaseName);
            ResourceLocation endTexture = this.blockTexture((Block)block).withSuffix("_top_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, sideTexture, endTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.axisBlockPhase(block, (ModelFile)model, (ModelFile)model, (TimePhase)((Object)phase));
        });
        String phaseName = TimePhase.FULL.getSerializedName();
        ResourceLocation sideTexture = this.blockTexture((Block)block).withSuffix("_" + phaseName);
        ResourceLocation endTexture = this.blockTexture((Block)block).withSuffix("_top_" + phaseName);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, sideTexture, endTexture));
    }

    private void phasingWoodBlockWithItem(AbstractPhasingLogBlock block, ResourceLocation texture) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation phaseTexture = texture.withSuffix("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, phaseTexture, phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.axisBlockPhase(block, (ModelFile)model, (ModelFile)model, (TimePhase)((Object)phase));
        });
        String phaseName = TimePhase.FULL.getSerializedName();
        ResourceLocation phaseTexture = texture.withSuffix("_" + phaseName);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, phaseTexture, phaseTexture));
    }

    private void axisBlockPhase(AbstractPhasingLogBlock block, ModelFile vertical, ModelFile horizontal, TimePhase phase) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile(vertical).addModel()).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile(horizontal).rotationX(90).addModel()).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile(horizontal).rotationX(90).rotationY(90).addModel();
    }

    private void phasingLeavesBlockWithItem(AbstractPhasingLeavesBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation phaseTexture = this.blockTexture(block).withSuffix("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + phaseName, ResourceLocation.withDefaultNamespace((String)"block/leaves"))).texture("all", phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? CUTOUT : TRANSLUCENT);
            this.getVariantBuilder(block).partialState().with(AbstractPhasingLeavesBlock.PHASE, (Comparable)((Object)phase)).modelForState().modelFile((ModelFile)model).addModel();
        });
        String phaseName = TimePhase.FULL.getSerializedName();
        ResourceLocation phaseTexture = this.blockTexture(block).withSuffix("_" + phaseName);
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + phaseName, ResourceLocation.withDefaultNamespace((String)"block/leaves"))).texture("all", phaseTexture));
    }

    private void saplingBlockWithPotAndItem(Block block, FlowerPotBlock pottedBlock) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType(CUTOUT));
        this.simpleBlock((Block)pottedBlock, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)pottedBlock), ResourceLocation.withDefaultNamespace((String)"block/flower_pot_cross"))).texture("plant", this.blockTexture(pottedBlock.getPotted()))).renderType(CUTOUT));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture(block));
    }

    private void phasingCubeBlockWithItem(AbstractPhasingBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation phaseTexture = this.blockTexture(block).withSuffix("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + phaseName, phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.getVariantBuilder(block).partialState().with(AbstractPhasingBlock.PHASE, (Comparable)((Object)phase)).modelForState().modelFile((ModelFile)model).addModel();
        });
        String phaseName = TimePhase.FULL.getSerializedName();
        ResourceLocation phaseTexture = this.blockTexture(block).withSuffix("_" + phaseName);
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + phaseName, phaseTexture)).renderType(SOLID));
    }

    private void phasingSlabBlockWithItem(AbstractPhasingSlabBlock block, AbstractPhasingBlock doubleSlabBlock) {
        String blockName = this.name((Block)block);
        ResourceLocation texture = this.blockTexture(doubleSlabBlock);
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation phaseTexture = texture.withSuffix("_" + phaseName);
            ResourceLocation renderType = TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT;
            ModelBuilder bottomModel = ((BlockModelBuilder)this.models().slab(blockName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType);
            ModelBuilder topModel = ((BlockModelBuilder)this.models().slabTop(blockName + "_top_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType);
            ModelFile.ExistingModelFile doubleModel = this.models().getExistingFile(this.key(doubleSlabBlock).withSuffix("_" + phaseName));
            this.getVariantBuilder((Block)block).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomModel)}).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topModel)}).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleModel)});
        });
        String phaseName = TimePhase.FULL.getSerializedName();
        ResourceLocation phaseTexture = texture.withSuffix("_" + phaseName);
        ModelBuilder bottomModel = this.models().slab(blockName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture);
        this.simpleBlockItem((Block)block, (ModelFile)bottomModel);
    }

    private void phasingStairsBlockWithItem(AbstractPhasingStairsBlock block, ResourceLocation texture) {
        String baseName = this.name((Block)block);
        HashMap baseModels = new HashMap();
        HashMap innerModels = new HashMap();
        HashMap outerModels = new HashMap();
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.getSerializedName();
            ResourceLocation phaseTexture = texture.withSuffix("_" + phaseName);
            ResourceLocation renderType = TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT;
            baseModels.put(phase, ((BlockModelBuilder)this.models().stairs(baseName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
            innerModels.put(phase, ((BlockModelBuilder)this.models().stairsInner(baseName + "_inner_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
            outerModels.put(phase, ((BlockModelBuilder)this.models().stairsOuter(baseName + "_outer_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
        });
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            TimePhase phase = (TimePhase)((Object)((Object)state.getValue(AbstractPhasingStairsBlock.PHASE)));
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? (ModelFile)baseModels.get((Object)phase) : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? (ModelFile)innerModels.get((Object)phase) : (ModelFile)outerModels.get((Object)phase))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairBlock.WATERLOGGED});
        this.simpleBlockItem((Block)block, (ModelFile)baseModels.get((Object)TimePhase.FULL));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block) {
        this.phasingPillarBlockWithItem(block, this.blockTexture(block));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block, ResourceLocation texture) {
        this.phasingPillarBlockWithItem(block, texture, texture.withSuffix("_inner"), texture.withSuffix("_top"), texture.withSuffix("_bottom"), texture.withSuffix("_base"));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation baseTexture) {
        String baseName = this.name(block);
        HashBasedTable models = HashBasedTable.create();
        Stream.of(TimePhase.values()).forEach(arg_0 -> this.lambda$phasingPillarBlockWithItem$15((Table)models, baseName, sideTexture, innerTexture, topTexture, baseTexture, bottomTexture, arg_0));
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateProviderPMNeoforge.lambda$phasingPillarBlockWithItem$16((Table)models, arg_0));
        this.simpleBlockItem(block, (ModelFile)models.get((Object)PillarBlock.Type.BASE, (Object)TimePhase.FULL));
    }

    private void logBlockWithItem(RotatedPillarBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        ModelBuilder model = this.models().cubeColumn(this.name((Block)block), texture, texture.withSuffix("_top"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void woodBlockWithItem(RotatedPillarBlock block, ResourceLocation texture) {
        ModelBuilder model = this.models().cubeColumn(this.name((Block)block), texture, texture);
        this.axisBlock(block, (ModelFile)model, (ModelFile)model);
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void leavesBlockWithItem(LeavesBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), ResourceLocation.withDefaultNamespace((String)"block/leaves"))).texture("all", this.blockTexture((Block)block));
        this.simpleBlockWithItem((Block)block, (ModelFile)model);
    }

    private void ritualCandleBlockWithItem(RitualCandleBlock block) {
        this.simpleExistingBlockWithItem((Block)block, ResourceUtils.loc("block/ritual_candle"));
    }

    private void manaFontBlockWithItem(AbstractManaFontBlock block, ResourceLocation baseTexture) {
        this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), ResourceUtils.loc("block/template_mana_font"))).texture("base", baseTexture));
        this.itemModels().withExistingParent(this.name((Block)block), ResourceUtils.loc("item/template_mana_font"));
    }

    private void horizontalExistingBlockWithItem(Block block) {
        this.horizontalExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void horizontalBlockWithItem(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.defaultBlockState()));
    }

    private void horizontalExistingBlockWithBasicItem(Block block) {
        this.horizontalExistingBlockWithBasicItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithBasicItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithBasicItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithBasicItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        this.itemModels().basicItem(block.asItem());
    }

    private void horizontalExistingBlockWithRightHandAdjustmentsAndItem(Block block) {
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithRightHandAdjustmentsAndItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithRightHandAdjustmentsAndItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithRightHandAdjustmentsAndItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent(model)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 135.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void horizontalFaceExistingBlockWithItem(Block block) {
        this.horizontalFaceBlockWithItem(block, (ModelFile)this.models().getExistingFile(this.defaultModel(block)));
    }

    private void horizontalFaceBlockWithItem(Block block, ModelFile model) {
        this.horizontalFaceBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void directionalExistingBlockWithItem(Block block) {
        this.directionalExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void directionalExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.directionalBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void directionalBlockWithItem(Block block, ModelFile model) {
        this.directionalBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void directionalBlockWithItem(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.defaultBlockState()));
    }

    private void calcinatorBlockWithItem(AbstractCalcinatorBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        this.calcinatorBlockWithItem(block, state -> this.models().orientableWithBottom(this.name((Block)block) + ((Boolean)state.getValue((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : ""), texture.withSuffix("_side"), texture.withSuffix("_front" + ((Boolean)state.getValue((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : "")), this.mcLoc("block/furnace_top"), texture.withSuffix("_top")));
    }

    private void calcinatorBlockWithItem(AbstractCalcinatorBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock((Block)block, modelFunc);
        this.simpleBlockItem((Block)block, modelFunc.apply(block.defaultBlockState()));
    }

    private void infernalFurnaceBlockWithItem() {
        Block block = (Block)BlocksPM.INFERNAL_FURNACE.get();
        ResourceLocation texture = this.blockTexture(block);
        Function<BlockState, ModelFile> modelFunc = state -> this.models().orientableWithBottom(this.name(block) + ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? "_on" : ""), texture.withSuffix("_side"), texture.withSuffix("_front" + ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? "_on" : "")), texture.withSuffix("_top"), texture.withSuffix("_top"));
        this.horizontalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.defaultBlockState()));
    }

    private void spellcraftingAltarBlockWithItem() {
        Block block = (Block)BlocksPM.SPELLCRAFTING_ALTAR.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(ResourceUtils.loc("block/spellcrafting_altar"));
        this.horizontalBlock(block, (ModelFile)model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void manaRelayBlockWithItem(ManaRelayBlock block) {
        this.simpleBlock((Block)block, (ModelFile)this.models().withExistingParent(this.name((Block)block), ResourceLocation.withDefaultNamespace((String)"block/copper_block")));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void manaInjectorBlockWithItem(ManaInjectorBlock block) {
        this.simpleBlock((Block)block, (ModelFile)this.models().withExistingParent(this.name((Block)block), ResourceLocation.withDefaultNamespace((String)"block/copper_block")));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void sunlampBlockWithItem(SunlampBlock block) {
        ResourceLocation modelLoc = this.defaultModel((Block)block);
        DirectionProperty prop = SunlampBlock.ATTACHMENT;
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_ground_base"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_ground_chain_stub"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_base"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_chain_stub"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_chain_full"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_arm"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_arm"))).rotationY(90).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_arm"))).rotationY(180).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_hanging_arm"))).rotationY(270).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.WEST}).end();
        this.itemModels().basicItem(block.asItem());
    }

    private void incenseBrazierBlockWithItem() {
        Block block = (Block)BlocksPM.INCENSE_BRAZIER.get();
        ResourceLocation modelLoc = this.defaultModel(block);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)IncenseBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc)).addModel()).partialState().with((Property)IncenseBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_lit"))).addModel();
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(modelLoc));
    }

    private void ritualBellBlockWithItem() {
        Block block = (Block)BlocksPM.RITUAL_BELL.get();
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getRitualBellModel((BlockState)state)).rotationY(this.getRitualBellRotationY((BlockState)state)).build());
        this.itemModels().basicItem(block.asItem());
    }

    private ModelFile getRitualBellModel(BlockState state) {
        String suffix = switch ((BellAttachType)state.getValue((Property)BlockStateProperties.BELL_ATTACHMENT)) {
            case BellAttachType.FLOOR -> "_floor";
            case BellAttachType.CEILING -> "_ceiling";
            case BellAttachType.SINGLE_WALL -> "_wall";
            case BellAttachType.DOUBLE_WALL -> "_between_walls";
            default -> throw new IllegalArgumentException("Unknown bell attachment type");
        };
        return this.models().getExistingFile(this.defaultModel(state.getBlock()).withSuffix(suffix));
    }

    private int getRitualBellRotationY(BlockState state) {
        int angleOffset = switch ((BellAttachType)state.getValue((Property)BlockStateProperties.BELL_ATTACHMENT)) {
            default -> throw new MatchException(null, null);
            case BellAttachType.FLOOR, BellAttachType.CEILING -> 180;
            case BellAttachType.SINGLE_WALL, BellAttachType.DOUBLE_WALL -> 90;
        };
        return ((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + angleOffset) % 360;
    }

    private void bloodletterBlockWithItem() {
        Block block = (Block)BlocksPM.BLOODLETTER.get();
        ResourceLocation modelLoc = this.defaultModel(block);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BloodletterBlock.FILLED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc)).addModel()).partialState().with((Property)BloodletterBlock.FILLED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc.withSuffix("_full"))).addModel();
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(modelLoc));
    }

    private void runescribingAltarBlockWithItem(RunescribingAltarBlock block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), ResourceUtils.loc("block/runescribing_altar"))).texture("altar_bottom", texture)).texture("altar_side", this.blockTexture((Block)block).withSuffix("_side"));
        this.simpleBlockWithItem((Block)block, (ModelFile)model);
    }

    private void golemControllerBlockWithItem(AbstractEnchantedGolemControllerBlock<?> block, ResourceLocation topTexture) {
        ResourceLocation baseTexture = this.blockTexture(block);
        ModelBuilder model = this.models().orientable(this.name(block), baseTexture.withSuffix("_side"), baseTexture.withSuffix("_front"), topTexture);
        this.horizontalBlockWithItem(block, (ModelFile)model);
    }

    private void essenceCaskBlockWithItem(EssenceCaskBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        this.essenceCaskBlockWithItem(block, state -> this.models().cubeBottomTop(this.name((Block)block) + ((Boolean)state.getValue((Property)EssenceCaskBlock.OPEN) != false ? "_open" : ""), texture.withSuffix("_side"), texture.withSuffix("_bottom"), texture.withSuffix("_top" + ((Boolean)state.getValue((Property)EssenceCaskBlock.OPEN) != false ? "_open" : ""))));
    }

    private void essenceCaskBlockWithItem(EssenceCaskBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalBlockWithItem((Block)block, modelFunc);
        this.simpleBlockItem((Block)block, modelFunc.apply(block.defaultBlockState()));
    }

    private ModelFile getCrossModel(Block block) {
        return ((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType(CUTOUT);
    }

    private void crossBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.simpleBlock(block, this.getCrossModel(block));
        this.itemModels().basicItem(itemTexture);
    }

    private void stemBlock(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        StemBlock.AGE.getPossibleValues().forEach(stage -> builder.partialState().with((Property)StemBlock.AGE, (Comparable)stage).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_stage" + stage, ResourceLocation.withDefaultNamespace((String)("block/stem_growth" + stage)))).texture("stem", this.blockTexture(block))).renderType(CUTOUT)).addModel());
    }

    private void attachedStemBlock(Block block, ResourceLocation lowerStemTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), ResourceLocation.withDefaultNamespace((String)"block/stem_fruit"))).texture("stem", lowerStemTexture)).texture("upperstem", this.blockTexture(block))).renderType(CUTOUT);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)AttachedStemBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)AttachedStemBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)AttachedStemBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)AttachedStemBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(180).addModel();
    }

    private void tallCrossBlockWithItem(Block block) {
        this.tallCrossBlockWithItem(block, this.blockTexture(block).withSuffix("_top"), this.blockTexture(block).withSuffix("_bottom"));
    }

    private void tallCrossBlockWithItem(Block block, ResourceLocation topTexture, ResourceLocation bottomTexture) {
        ModelBuilder topModel = ((BlockModelBuilder)this.models().cross(this.name(block) + "_top", topTexture)).renderType(CUTOUT);
        ModelBuilder bottomModel = ((BlockModelBuilder)this.models().cross(this.name(block) + "_bottom", bottomTexture)).renderType(CUTOUT);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottomModel).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture(block).withSuffix("_top"));
    }

    private void tallExistingBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.tallExistingBlockWithItem(block, this.defaultModel(block).withSuffix("_top"), this.defaultModel(block).withSuffix("_bottom"), itemTexture);
    }

    private void tallExistingBlockWithItem(Block block, ResourceLocation topModel, ResourceLocation bottomModel, ResourceLocation itemTexture) {
        this.tallExistingBlockWithItem(block, (ModelFile)this.models().getExistingFile(topModel), (ModelFile)this.models().getExistingFile(bottomModel), itemTexture);
    }

    private void tallExistingBlockWithItem(Block block, ModelFile topModel, ModelFile bottomModel, ResourceLocation itemTexture) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile(topModel).addModel()).partialState().with((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile(bottomModel).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", itemTexture);
    }

    private void directionalCrossBlockWithItem(Block block) {
        this.directionalCrossBlockWithItem(block, this.blockTexture(block));
    }

    private void directionalCrossBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.directionalBlock(block, this.getCrossModel(block));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", itemTexture);
    }

    private void carvedBookshelfBlockWithItem(CarvedBookshelfBlock block, Block sideTextureBlock) {
        DirectionProperty facingProp = CarvedBookshelfBlock.FACING;
        ModelFile baseModel = this.getCarvedBookshelfBaseModel(block, sideTextureBlock);
        String baseName = this.name((Block)block);
        ResourceLocation sideTexture = this.blockTexture(sideTextureBlock);
        ResourceLocation emptyTexture = this.blockTexture((Block)block).withSuffix("_empty");
        ResourceLocation occupiedTexture = this.blockTexture((Block)block).withSuffix("_occupied");
        ImmutableMap slotNameMap = ImmutableMap.builder().put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_0_OCCUPIED, (Object)"top_left").put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_1_OCCUPIED, (Object)"top_mid").put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_2_OCCUPIED, (Object)"top_right").put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_3_OCCUPIED, (Object)"bottom_left").put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_4_OCCUPIED, (Object)"bottom_mid").put((Object)BlockStateProperties.CHISELED_BOOKSHELF_SLOT_5_OCCUPIED, (Object)"bottom_right").build();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        Direction.Plane.HORIZONTAL.stream().forEach(arg_0 -> this.lambda$carvedBookshelfBlockWithItem$23(builder, baseModel, facingProp, (Map)slotNameMap, baseName, emptyTexture, occupiedTexture, arg_0));
        ModelFile invModel = this.getCarvedBookshelfInventoryModel(this.name((Block)block) + "_inventory", this.blockTexture((Block)block).withSuffix("_empty"), sideTexture, sideTexture);
        ((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).toString())).parent(invModel);
    }

    private ModelFile getCarvedBookshelfBaseModel(CarvedBookshelfBlock block, Block sideTextureBlock) {
        ResourceLocation sideTexture = this.blockTexture(sideTextureBlock);
        return this.getCarvedBookshelfBaseModel(this.name((Block)block), sideTexture, sideTexture);
    }

    private ModelFile getCarvedBookshelfBaseModel(String name, ResourceLocation topTexture, ResourceLocation sideTexture) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/block")).texture("top", topTexture)).texture("side", sideTexture)).texture("particle", "#top")).renderType(SOLID)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.EAST).end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.WEST).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").cullface(Direction.UP).end().face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").cullface(Direction.DOWN).end().end();
    }

    private ModelFile getCarvedBookshelfSlotModel(String baseName, String slotName, boolean occupied, ResourceLocation slotTexture) {
        String name = baseName + "_" + (occupied ? "occupied" : "empty") + "_slot_" + slotName;
        ResourceLocation parent = ResourceLocation.withDefaultNamespace((String)("block/template_chiseled_bookshelf_slot_" + slotName));
        return ((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("texture", slotTexture);
    }

    private ModelFile getCarvedBookshelfInventoryModel(String name, ResourceLocation frontTexture, ResourceLocation topTexture, ResourceLocation sideTexture) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/block")).texture("top", topTexture)).texture("side", sideTexture)).texture("front", frontTexture)).texture("particle", "#top")).renderType(SOLID)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#front").end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").end().end();
    }

    private /* synthetic */ void lambda$carvedBookshelfBlockWithItem$23(MultiPartBlockStateBuilder builder, ModelFile baseModel, DirectionProperty facingProp, Map slotNameMap, String baseName, ResourceLocation emptyTexture, ResourceLocation occupiedTexture, Direction dir) {
        int rotY = (int)(dir.toYRot() + 180.0f) % 360;
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(baseModel).rotationY(rotY).uvLock(true).addModel()).condition((Property)facingProp, (Comparable[])new Direction[]{dir}).end();
        slotNameMap.keySet().forEach(slotProperty -> {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getCarvedBookshelfSlotModel(baseName, (String)slotNameMap.get(slotProperty), false, emptyTexture)).rotationY(rotY).addModel()).nestedGroup().condition((Property)facingProp, (Comparable[])new Direction[]{dir}).end().nestedGroup().condition((Property)slotProperty, (Comparable[])new Boolean[]{false}).end().end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getCarvedBookshelfSlotModel(baseName, (String)slotNameMap.get(slotProperty), true, occupiedTexture)).rotationY(rotY).addModel()).nestedGroup().condition((Property)facingProp, (Comparable[])new Direction[]{dir}).end().nestedGroup().condition((Property)slotProperty, (Comparable[])new Boolean[]{true}).end().end();
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$phasingPillarBlockWithItem$16(Table models, BlockState state) {
        PillarBlock.Type type = (PillarBlock.Type)((Object)state.getValue((Property)AbstractPhasingPillarBlock.PROPERTY_TYPE));
        TimePhase phase = (TimePhase)((Object)state.getValue(AbstractPhasingPillarBlock.PHASE));
        return ConfiguredModel.builder().modelFile((ModelFile)models.get((Object)type, (Object)phase)).build();
    }

    private /* synthetic */ void lambda$phasingPillarBlockWithItem$15(Table models, String baseName, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation baseTexture, ResourceLocation bottomTexture, TimePhase phase) {
        String phaseName = phase.getSerializedName();
        ResourceLocation renderType = TimePhase.FULL.equals((Object)phase) ? SOLID : TRANSLUCENT;
        models.put((Object)PillarBlock.Type.BASE, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_" + phaseName, ResourceUtils.loc("block/pillar"))).texture("side", sideTexture.withSuffix("_" + phaseName))).texture("inner", innerTexture.withSuffix("_" + phaseName))).renderType(renderType));
        models.put((Object)PillarBlock.Type.TOP, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_top_" + phaseName, ResourceUtils.loc("block/pillar_top"))).texture("side", topTexture.withSuffix("_" + phaseName))).texture("inner", innerTexture.withSuffix("_" + phaseName))).texture("top", baseTexture.withSuffix("_" + phaseName))).renderType(renderType));
        models.put((Object)PillarBlock.Type.BOTTOM, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_bottom_" + phaseName, ResourceUtils.loc("block/pillar_bottom"))).texture("side", bottomTexture.withSuffix("_" + phaseName))).texture("inner", innerTexture.withSuffix("_" + phaseName))).texture("bottom", baseTexture.withSuffix("_" + phaseName))).renderType(renderType));
    }
}

