/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.affinities;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.common.affinities.AffinityType;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.datagen.affinities.EnchantmentBonusAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.EntityTypeAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.IFinishedAffinity;
import com.verdantartifice.primalmagick.datagen.affinities.ItemAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.PotionBonusAffinityBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AffinityProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput packOutput;
    protected final CompletableFuture<HolderLookup.Provider> lookupProviderFuture;

    public AffinityProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProviderFuture) {
        this.packOutput = packOutput;
        this.lookupProviderFuture = lookupProviderFuture;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.lookupProviderFuture.thenCompose(p -> {
            ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
            HashMap map = new HashMap();
            this.registerAffinities((HolderLookup.Provider)p, affinity -> {
                if (map.computeIfAbsent(affinity.getType(), type -> new HashMap()).put(affinity.getId(), affinity) != null) {
                    LOGGER.debug("Duplicate affinity in data generation: " + affinity.getId().toString());
                }
            });
            map.entrySet().forEach(typeEntry -> ((Map)typeEntry.getValue()).entrySet().forEach(affinityEntry -> {
                IFinishedAffinity affinity = (IFinishedAffinity)affinityEntry.getValue();
                futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)affinity.getAffinityJson(), (Path)this.getPath(this.packOutput, affinity.getType(), (ResourceLocation)affinityEntry.getKey())));
            }));
            return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
        });
    }

    private Path getPath(PackOutput output, AffinityType affinityType, ResourceLocation entryLoc) {
        return output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(entryLoc.getNamespace()).resolve("affinities").resolve(affinityType.getFolder()).resolve(entryLoc.getPath() + ".json");
    }

    protected void registerAffinities(HolderLookup.Provider lookupProvider, Consumer<IFinishedAffinity> consumer) {
        SourceList auraUnit = SourceList.builder().withEarth(1).withSea(1).withSky(1).withSun(1).withMoon(1).build();
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STONE).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRANITE).base((ItemLike)Items.STONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POLISHED_GRANITE).base((ItemLike)Items.GRANITE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIORITE).base((ItemLike)Items.STONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POLISHED_DIORITE).base((ItemLike)Items.DIORITE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ANDESITE).base((ItemLike)Items.STONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POLISHED_ANDESITE).base((ItemLike)Items.ANDESITE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE).base((ItemLike)Items.STONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COBBLED_DEEPSLATE).base((ItemLike)Items.DEEPSLATE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POLISHED_DEEPSLATE).base((ItemLike)Items.DEEPSLATE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CALCITE).base((ItemLike)Items.STONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TUFF).base((ItemLike)Items.OBSIDIAN).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DRIPSTONE_BLOCK).base((ItemLike)Items.STONE).add(Sources.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRASS_BLOCK).base((ItemLike)Items.DIRT).add(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIRT).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COARSE_DIRT).base((ItemLike)Items.DIRT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PODZOL).base((ItemLike)Items.DIRT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ROOTED_DIRT).base((ItemLike)Items.DIRT).add(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_NYLIUM).base((ItemLike)Items.NETHERRACK).add(Sources.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_NYLIUM).base((ItemLike)Items.NETHERRACK).add(Sources.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COBBLESTONE).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_PLANKS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_PLANKS).base((ItemLike)Items.OAK_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_PLANKS).base((ItemLike)Items.OAK_PLANKS).add(Sources.MOON, 2).add(Sources.INFERNAL, 2).remove(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_PLANKS).base((ItemLike)Items.CRIMSON_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BAMBOO_MOSAIC).base((ItemLike)Items.BAMBOO_PLANKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_SAPLING).set(Sources.EARTH, 10).set(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_PROPAGULE).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_SAPLING).base((ItemLike)Items.OAK_SAPLING).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BEDROCK).set(Sources.EARTH, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SAND).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SUSPICIOUS_SAND).base((ItemLike)Items.SAND).add(Sources.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_SAND).base((ItemLike)Items.SAND).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAVEL).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SUSPICIOUS_GRAVEL).base((ItemLike)Items.GRAVEL).add(Sources.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GOLD_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_GOLD_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COPPER_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_COPPER_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.IRON_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_IRON_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COAL_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 5).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_COAL_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 5).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.REDSTONE_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_REDSTONE_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EMERALD_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_EMERALD_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LAPIS_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_LAPIS_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIAMOND_ORE).base((ItemLike)Items.STONE).add(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEEPSLATE_DIAMOND_ORE).base((ItemLike)Items.DEEPSLATE).add(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_GOLD_ORE).base((ItemLike)Items.NETHERRACK).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_QUARTZ_ORE).base((ItemLike)Items.NETHERRACK).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ANCIENT_DEBRIS).base((ItemLike)Items.NETHERRACK).add(Sources.EARTH, 5).add(Sources.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HEAVY_CORE).set(Sources.EARTH, 100).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BUDDING_AMETHYST).base((ItemLike)Items.AMETHYST_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPOSED_COPPER).base((ItemLike)Items.COPPER_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WEATHERED_COPPER).base((ItemLike)Items.COPPER_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OXIDIZED_COPPER).base((ItemLike)Items.COPPER_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_LOG).set(Sources.EARTH, 10).set(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_ROOTS).base((ItemLike)Items.MANGROVE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_STEM).base((ItemLike)Items.OAK_LOG).add(Sources.MOON, 10).add(Sources.INFERNAL, 10).remove(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_STEM).base((ItemLike)Items.CRIMSON_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_OAK_LOG).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_SPRUCE_LOG).base((ItemLike)Items.SPRUCE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_BIRCH_LOG).base((ItemLike)Items.BIRCH_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_JUNGLE_LOG).base((ItemLike)Items.JUNGLE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_ACACIA_LOG).base((ItemLike)Items.ACACIA_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_DARK_OAK_LOG).base((ItemLike)Items.DARK_OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_MANGROVE_LOG).base((ItemLike)Items.MANGROVE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_CHERRY_LOG).base((ItemLike)Items.CHERRY_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_CRIMSON_STEM).base((ItemLike)Items.CRIMSON_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_WARPED_STEM).base((ItemLike)Items.WARPED_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_OAK_WOOD).base((ItemLike)Items.OAK_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_SPRUCE_WOOD).base((ItemLike)Items.SPRUCE_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_BIRCH_WOOD).base((ItemLike)Items.BIRCH_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_JUNGLE_WOOD).base((ItemLike)Items.JUNGLE_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_ACACIA_WOOD).base((ItemLike)Items.ACACIA_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_DARK_OAK_WOOD).base((ItemLike)Items.DARK_OAK_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_MANGROVE_WOOD).base((ItemLike)Items.MANGROVE_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_CHERRY_WOOD).base((ItemLike)Items.CHERRY_WOOD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_BAMBOO_BLOCK).base((ItemLike)Items.BAMBOO_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_CRIMSON_HYPHAE).base((ItemLike)Items.CRIMSON_HYPHAE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRIPPED_WARPED_HYPHAE).base((ItemLike)Items.WARPED_HYPHAE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_WOOD).base((ItemLike)Items.OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_WOOD).base((ItemLike)Items.SPRUCE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_WOOD).base((ItemLike)Items.BIRCH_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_WOOD).base((ItemLike)Items.JUNGLE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_WOOD).base((ItemLike)Items.ACACIA_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_WOOD).base((ItemLike)Items.DARK_OAK_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_WOOD).base((ItemLike)Items.MANGROVE_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_WOOD).base((ItemLike)Items.CHERRY_LOG).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_HYPHAE).base((ItemLike)Items.CRIMSON_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_HYPHAE).base((ItemLike)Items.WARPED_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_LEAVES).set(Sources.EARTH, 5).set(Sources.SKY, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MANGROVE_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AZALEA_LEAVES).base((ItemLike)Items.OAK_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLOWERING_AZALEA_LEAVES).base((ItemLike)Items.AZALEA_LEAVES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPONGE).set(Sources.SEA, 20).set(Sources.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WET_SPONGE).base((ItemLike)Items.SPONGE).add(Sources.SEA, 10).remove(Sources.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SANDSTONE).base((ItemLike)Items.STONE).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COBWEB).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SHORT_GRASS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FERN).base((ItemLike)Items.SHORT_GRASS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AZALEA).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLOWERING_AZALEA).base((ItemLike)Items.AZALEA).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BUSH).base((ItemLike)Items.SHORT_GRASS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SEAGRASS).base((ItemLike)Items.SHORT_GRASS).add(Sources.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SEA_PICKLE).set(Sources.EARTH, 5).set(Sources.SEA, 20).set(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_WOOL).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_WOOL).base((ItemLike)Items.WHITE_WOOL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DANDELION).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POPPY).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_ORCHID).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ALLIUM).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AZURE_BLUET).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_TULIP).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_TULIP).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_TULIP).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_TULIP).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OXEYE_DAISY).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CORNFLOWER).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LILY_OF_THE_VALLEY).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WITHER_ROSE).base((ItemLike)Items.DANDELION).add(Sources.INFERNAL, 5).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TORCHFLOWER).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PITCHER_PLANT).base((ItemLike)Items.DANDELION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPORE_BLOSSOM).set(Sources.EARTH, 5).set(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_MUSHROOM).set(Sources.EARTH, 5).set(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_MUSHROOM).base((ItemLike)Items.BROWN_MUSHROOM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_FUNGUS).base((ItemLike)Items.BROWN_MUSHROOM).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_FUNGUS).base((ItemLike)Items.CRIMSON_FUNGUS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_ROOTS).set(Sources.EARTH, 2).set(Sources.MOON, 2).set(Sources.INFERNAL, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_ROOTS).base((ItemLike)Items.CRIMSON_ROOTS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_SPROUTS).base((ItemLike)Items.CRIMSON_ROOTS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WEEPING_VINES).base((ItemLike)Items.VINE).add(Sources.MOON, 5).add(Sources.INFERNAL, 5).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TWISTING_VINES).base((ItemLike)Items.WEEPING_VINES).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SUGAR_CANE).set(Sources.EARTH, 5).set(Sources.SEA, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.KELP).set(Sources.EARTH, 5).set(Sources.SEA, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_PETALS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MOSS_BLOCK).set(Sources.EARTH, 5).set(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HANGING_ROOTS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIG_DRIPLEAF).set(Sources.EARTH, 5).set(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SMALL_DRIPLEAF).set(Sources.EARTH, 2).set(Sources.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BAMBOO).set(Sources.EARTH, 5).set(Sources.SKY, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OAK_SLAB).set(Sources.EARTH, 1).set(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPRUCE_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BIRCH_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.JUNGLE_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ACACIA_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHERRY_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DARK_OAK_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRIMSON_SLAB).base((ItemLike)Items.OAK_SLAB).add(Sources.MOON, 1).add(Sources.INFERNAL, 1).remove(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_SLAB).base((ItemLike)Items.CRIMSON_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PETRIFIED_OAK_SLAB).base((ItemLike)Items.OAK_SLAB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MOSSY_COBBLESTONE).base((ItemLike)Items.COBBLESTONE).add(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OBSIDIAN).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TORCH).set(Sources.EARTH, 2).set(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHORUS_PLANT).set(Sources.EARTH, 5).set(Sources.MOON, 5).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHORUS_FLOWER).base((ItemLike)Items.CHORUS_PLANT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPUR_BLOCK).set(Sources.EARTH, 5).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPAWNER).set(Sources.BLOOD, 20).set(Sources.INFERNAL, 10).set(Sources.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FARMLAND).base((ItemLike)Items.DIRT).add(Sources.SEA, 2).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FURNACE).set(Sources.EARTH, 30).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SNOW).set(Sources.SEA, 2).set(Sources.SKY, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ICE).set(Sources.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SNOW_BLOCK).set(Sources.SEA, 5).set(Sources.SKY, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CACTUS).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PUMPKIN).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CARVED_PUMPKIN).base((ItemLike)Items.PUMPKIN).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERRACK).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SOUL_SAND).base((ItemLike)Items.NETHERRACK).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SOUL_SOIL).base((ItemLike)Items.SOUL_SAND).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BASALT).base((ItemLike)Items.STONE).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SOUL_TORCH).base((ItemLike)Items.TORCH).add(Sources.INFERNAL, 5).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_STONE).base((ItemLike)Items.STONE).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_COBBLESTONE).base((ItemLike)Items.COBBLESTONE).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_STONE_BRICKS).base((ItemLike)Items.STONE_BRICKS).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_MOSSY_STONE_BRICKS).base((ItemLike)Items.MOSSY_STONE_BRICKS).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_CRACKED_STONE_BRICKS).base((ItemLike)Items.CRACKED_STONE_BRICKS).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_CHISELED_STONE_BRICKS).base((ItemLike)Items.CHISELED_STONE_BRICKS).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INFESTED_DEEPSLATE).base((ItemLike)Items.DEEPSLATE).add(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STONE_BRICKS).set(Sources.EARTH, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MOSSY_STONE_BRICKS).base((ItemLike)Items.STONE_BRICKS).add(Sources.MOON, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRACKED_STONE_BRICKS).base((ItemLike)Items.STONE_BRICKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHISELED_STONE_BRICKS).base((ItemLike)Items.STONE_BRICKS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_MUSHROOM_BLOCK).base((ItemLike)Items.MUSHROOM_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_MUSHROOM_BLOCK).base((ItemLike)Items.MUSHROOM_STEM).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSHROOM_STEM).set(Sources.EARTH, 5).set(Sources.MOON, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MELON).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.VINE).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GLOW_LICHEN).set(Sources.EARTH, 2).set(Sources.SUN, 2).set(Sources.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MYCELIUM).set(Sources.EARTH, 5).set(Sources.MOON, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LILY_PAD).set(Sources.EARTH, 2).set(Sources.SEA, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.END_PORTAL_FRAME).set(Sources.EARTH, 5).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.END_STONE).set(Sources.EARTH, 5).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DRAGON_EGG).set(Sources.BLOOD, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHIPPED_ANVIL).base((ItemLike)Items.ANVIL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DAMAGED_ANVIL).base((ItemLike)Items.ANVIL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIRT_PATH).base((ItemLike)Items.GRASS_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SUNFLOWER).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LILAC).base((ItemLike)Items.SUNFLOWER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ROSE_BUSH).base((ItemLike)Items.SUNFLOWER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PEONY).base((ItemLike)Items.SUNFLOWER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TALL_GRASS).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LARGE_FERN).base((ItemLike)Items.TALL_GRASS).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SEA_LANTERN).set(Sources.EARTH, 24).set(Sources.SEA, 52).set(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_SANDSTONE).base((ItemLike)Items.SANDSTONE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGMA_BLOCK).set(Sources.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BONE_BLOCK).set(Sources.MOON, 10).set(Sources.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WARPED_WART_BLOCK).base((ItemLike)Items.NETHER_WART_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_SHULKER_BOX).base((ItemLike)Items.SHULKER_BOX).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE_POWDER).add(Sources.SEA, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_CONCRETE).base((ItemLike)Items.WHITE_CONCRETE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TURTLE_EGG).set(Sources.SEA, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SNIFFER_EGG).set(Sources.EARTH, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_TUBE_CORAL_BLOCK).base((ItemLike)Items.DEAD_TUBE_CORAL).add(Sources.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BRAIN_CORAL_BLOCK).base((ItemLike)Items.DEAD_BRAIN_CORAL).add(Sources.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BUBBLE_CORAL_BLOCK).base((ItemLike)Items.DEAD_BUBBLE_CORAL).add(Sources.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_FIRE_CORAL_BLOCK).base((ItemLike)Items.DEAD_FIRE_CORAL).add(Sources.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_HORN_CORAL_BLOCK).base((ItemLike)Items.DEAD_HORN_CORAL).add(Sources.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TUBE_CORAL_BLOCK).base((ItemLike)Items.DEAD_TUBE_CORAL_BLOCK).add(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BRAIN_CORAL_BLOCK).base((ItemLike)Items.DEAD_BRAIN_CORAL_BLOCK).add(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BUBBLE_CORAL_BLOCK).base((ItemLike)Items.DEAD_BUBBLE_CORAL_BLOCK).add(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FIRE_CORAL_BLOCK).base((ItemLike)Items.DEAD_FIRE_CORAL_BLOCK).add(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HORN_CORAL_BLOCK).base((ItemLike)Items.DEAD_HORN_CORAL_BLOCK).add(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TUBE_CORAL).base((ItemLike)Items.DEAD_TUBE_CORAL).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BRAIN_CORAL).base((ItemLike)Items.DEAD_BRAIN_CORAL).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BUBBLE_CORAL).base((ItemLike)Items.DEAD_BUBBLE_CORAL).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FIRE_CORAL).base((ItemLike)Items.DEAD_FIRE_CORAL).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HORN_CORAL).base((ItemLike)Items.DEAD_HORN_CORAL).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_TUBE_CORAL).set(Sources.EARTH, 5).set(Sources.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BRAIN_CORAL).base((ItemLike)Items.DEAD_TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BUBBLE_CORAL).base((ItemLike)Items.DEAD_TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_FIRE_CORAL).base((ItemLike)Items.DEAD_TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_HORN_CORAL).base((ItemLike)Items.DEAD_TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TUBE_CORAL_FAN).base((ItemLike)Items.TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BRAIN_CORAL_FAN).base((ItemLike)Items.BRAIN_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BUBBLE_CORAL_FAN).base((ItemLike)Items.BUBBLE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FIRE_CORAL_FAN).base((ItemLike)Items.FIRE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HORN_CORAL_FAN).base((ItemLike)Items.HORN_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_TUBE_CORAL_FAN).base((ItemLike)Items.DEAD_TUBE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BRAIN_CORAL_FAN).base((ItemLike)Items.DEAD_BRAIN_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_BUBBLE_CORAL_FAN).base((ItemLike)Items.DEAD_BUBBLE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_FIRE_CORAL_FAN).base((ItemLike)Items.DEAD_FIRE_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DEAD_HORN_CORAL_FAN).base((ItemLike)Items.DEAD_HORN_CORAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CONDUIT).set(Sources.SEA, 78).set(Sources.SUN, 15).set(Sources.BLOOD, 12).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPOSED_COPPER_DOOR).base((ItemLike)Items.COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WEATHERED_COPPER_DOOR).base((ItemLike)Items.COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OXIDIZED_COPPER_DOOR).base((ItemLike)Items.COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_EXPOSED_COPPER_DOOR).base((ItemLike)Items.WAXED_COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_WEATHERED_COPPER_DOOR).base((ItemLike)Items.WAXED_COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_OXIDIZED_COPPER_DOOR).base((ItemLike)Items.WAXED_COPPER_DOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPOSED_COPPER_TRAPDOOR).base((ItemLike)Items.COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WEATHERED_COPPER_TRAPDOOR).base((ItemLike)Items.COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OXIDIZED_COPPER_TRAPDOOR).base((ItemLike)Items.COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_EXPOSED_COPPER_TRAPDOOR).base((ItemLike)Items.WAXED_COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_WEATHERED_COPPER_TRAPDOOR).base((ItemLike)Items.WAXED_COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_OXIDIZED_COPPER_TRAPDOOR).base((ItemLike)Items.WAXED_COPPER_TRAPDOOR).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ELYTRA).set(Sources.SKY, 25).set(Sources.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TURTLE_SCUTE).set(Sources.SEA, 2).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ARMADILLO_SCUTE).set(Sources.SUN, 2).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.APPLE).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COAL).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHARCOAL).base((ItemLike)Items.COAL).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIAMOND).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EMERALD).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LAPIS_LAZULI).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.QUARTZ).set(Sources.EARTH, 10).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AMETHYST_SHARD).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RAW_IRON).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.IRON_INGOT).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RAW_COPPER).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COPPER_INGOT).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RAW_GOLD).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GOLD_INGOT).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_SCRAP).set(Sources.EARTH, 5).set(Sources.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_SWORD).set(Sources.EARTH, 56).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_SHOVEL).set(Sources.EARTH, 45).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_PICKAXE).set(Sources.EARTH, 68).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_AXE).set(Sources.EARTH, 68).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_HOE).set(Sources.EARTH, 57).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STICK).set(Sources.EARTH, 1).set(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.STRING).set(Sources.SKY, 5).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FEATHER).set(Sources.SKY, 20).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GUNPOWDER).set(Sources.EARTH, 5).set(Sources.INFERNAL, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHEAT_SEEDS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHEAT).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_HELMET).set(Sources.EARTH, 90).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_CHESTPLATE).set(Sources.EARTH, 123).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_LEGGINGS).set(Sources.EARTH, 112).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHERITE_BOOTS).set(Sources.EARTH, 78).set(Sources.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLINT).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PORKCHOP).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ENCHANTED_GOLDEN_APPLE).base((ItemLike)Items.GOLDEN_APPLE).add(Sources.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WATER_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LAVA_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POWDER_SNOW_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SADDLE).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.REDSTONE).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SNOWBALL).set(Sources.SEA, 2).set(Sources.SKY, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LEATHER).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MILK_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PUFFERFISH_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SALMON_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COD_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TROPICAL_FISH_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AXOLOTL_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TADPOLE_BUCKET).base((ItemLike)Items.BUCKET).add(Sources.SEA, 5).add(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BRICK).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CLAY_BALL).set(Sources.EARTH, 2).set(Sources.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SLIME_BALL).set(Sources.SEA, 5).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EGG).set(Sources.SKY, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GLOWSTONE_DUST).set(Sources.SUN, 10).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COD).set(Sources.SEA, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SALMON).set(Sources.SEA, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TROPICAL_FISH).set(Sources.SEA, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PUFFERFISH).set(Sources.SEA, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.INK_SAC).set(Sources.SEA, 5).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GLOW_INK_SAC).base((ItemLike)Items.INK_SAC).add(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COCOA_BEANS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_DYE).set(Sources.SEA, 1).set(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_DYE).base((ItemLike)Items.WHITE_DYE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BONE_MEAL).set(Sources.MOON, 1).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BONE).set(Sources.MOON, 5).set(Sources.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_BED).set(Sources.EARTH, 4).set(Sources.SUN, 4).set(Sources.BLOOD, 11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_BED).base((ItemLike)Items.WHITE_BED).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FILLED_MAP).base((ItemLike)Items.MAP).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MELON_SLICE).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DRIED_KELP).base((ItemLike)Items.KELP).remove(Sources.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PUMPKIN_SEEDS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MELON_SEEDS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BEEF).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHICKEN).set(Sources.SKY, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ROTTEN_FLESH).set(Sources.MOON, 5).set(Sources.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ENDER_PEARL).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLAZE_ROD).set(Sources.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GHAST_TEAR).set(Sources.SKY, 20).set(Sources.BLOOD, 5).set(Sources.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_WART).set(Sources.EARTH, 5).set(Sources.MOON, 5).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POTION).set(Sources.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPIDER_EYE).set(Sources.MOON, 5).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPERIENCE_BOTTLE).set(auraUnit.multiply(5.0)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WRITTEN_BOOK).base((ItemLike)Items.WRITABLE_BOOK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLOWER_POT).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CARROT).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POTATO).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POISONOUS_POTATO).base((ItemLike)Items.POTATO).add(Sources.MOON, 5).add(Sources.VOID, 2).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAP).set(Sources.EARTH, 42).set(Sources.SKY, 18).set(Sources.SUN, 18).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SKELETON_SKULL).set(Sources.MOON, 5).set(Sources.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WITHER_SKELETON_SKULL).base((ItemLike)Items.SKELETON_SKULL).add(Sources.INFERNAL, 10).remove(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PLAYER_HEAD).set(Sources.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ZOMBIE_HEAD).set(Sources.MOON, 5).set(Sources.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CREEPER_HEAD).set(Sources.BLOOD, 20).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DRAGON_HEAD).set(Sources.BLOOD, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PIGLIN_HEAD).set(Sources.BLOOD, 20).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_STAR).set(Sources.EARTH, 25).set(Sources.SEA, 25).set(Sources.SKY, 25).set(Sources.SUN, 25).set(Sources.MOON, 25).set(Sources.BLOOD, 25).set(Sources.INFERNAL, 25).set(Sources.VOID, 25).set(Sources.HALLOWED, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FIREWORK_ROCKET).set(Sources.EARTH, 5).set(Sources.SKY, 20).set(Sources.SUN, 15).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FIREWORK_STAR).base((ItemLike)Items.GUNPOWDER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ENCHANTED_BOOK).set(auraUnit.multiply(5.0)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NETHER_BRICK).base((ItemLike)Items.BRICK).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PRISMARINE_SHARD).set(Sources.EARTH, 2).set(Sources.SEA, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PRISMARINE_CRYSTALS).set(Sources.EARTH, 5).set(Sources.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RABBIT).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RABBIT_FOOT).set(Sources.MOON, 20).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RABBIT_HIDE).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.IRON_HORSE_ARMOR).set(Sources.EARTH, 52).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GOLDEN_HORSE_ARMOR).set(Sources.EARTH, 52).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DIAMOND_HORSE_ARMOR).set(Sources.EARTH, 105).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NAME_TAG).set(Sources.MOON, 10).set(Sources.BLOOD, 10).set(Sources.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUTTON).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHORUS_FRUIT).set(Sources.EARTH, 5).set(Sources.MOON, 5).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TORCHFLOWER_SEEDS).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PITCHER_POD).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BEETROOT).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BEETROOT_SEEDS).set(Sources.EARTH, 2).set(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DRAGON_BREATH).set(Sources.SKY, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SPLASH_POTION).base((ItemLike)Items.POTION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TIPPED_ARROW).base((ItemLike)Items.ARROW).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LINGERING_POTION).base((ItemLike)Items.POTION).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TOTEM_OF_UNDYING).set(Sources.HALLOWED, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SHULKER_SHELL).set(Sources.BLOOD, 5).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_11).set(Sources.SKY, 20).set(Sources.MOON, 20).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_13).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_BLOCKS).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_CAT).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_CHIRP).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_CREATOR).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_CREATOR_MUSIC_BOX).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_FAR).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_MALL).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_MELLOHI).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_OTHERSIDE).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_RELIC).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_PIGSTEP).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_PRECIPICE).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_STAL).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_STRAD).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_WAIT).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_WARD).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DISC_FRAGMENT_5).set(Sources.SKY, 2).set(Sources.MOON, 2).set(Sources.HALLOWED, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUSIC_DISC_5).base((ItemLike)Items.MUSIC_DISC_11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TRIDENT).set(Sources.EARTH, 15).set(Sources.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PHANTOM_MEMBRANE).set(Sources.SKY, 20).set(Sources.MOON, 20).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.NAUTILUS_SHELL).set(Sources.SEA, 20).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HEART_OF_THE_SEA).set(Sources.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SUSPICIOUS_STEW).set(Sources.EARTH, 12).set(Sources.SUN, 4).set(Sources.MOON, 7).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GLOBE_BANNER_PATTERN).base((ItemLike)Items.PAPER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PIGLIN_BANNER_PATTERN).base((ItemLike)Items.PAPER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLOW_BANNER_PATTERN).base((ItemLike)Items.PAPER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GUSTER_BANNER_PATTERN).base((ItemLike)Items.PAPER).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BELL).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LANTERN).set(Sources.EARTH, 7).set(Sources.SUN, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SOUL_LANTERN).set(Sources.EARTH, 7).set(Sources.SUN, 18).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SWEET_BERRIES).set(Sources.EARTH, 5).set(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GLOW_BERRIES).set(Sources.EARTH, 5).set(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SHROOMLIGHT).set(Sources.EARTH, 5).set(Sources.SUN, 15).set(Sources.MOON, 10).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HONEYCOMB).set(Sources.SEA, 5).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BEE_NEST).base((ItemLike)Items.BEEHIVE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HONEY_BOTTLE).base((ItemLike)Items.GLASS_BOTTLE).add(Sources.SEA, 5).add(Sources.BLOOD, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CRYING_OBSIDIAN).base((ItemLike)Items.OBSIDIAN).add(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACKSTONE).base((ItemLike)Items.COBBLESTONE).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GILDED_BLACKSTONE).base((ItemLike)Items.BLACKSTONE).add(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WHITE_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ORANGE_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MAGENTA_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_BLUE_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.YELLOW_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIME_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PINK_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GRAY_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LIGHT_GRAY_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CYAN_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PURPLE_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLUE_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BROWN_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GREEN_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.RED_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLACK_CANDLE).base((ItemLike)Items.CANDLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SMALL_AMETHYST_BUD).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MEDIUM_AMETHYST_BUD).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.LARGE_AMETHYST_BUD).set(Sources.EARTH, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.AMETHYST_CLUSTER).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.POINTED_DRIPSTONE).set(Sources.EARTH, 2).set(Sources.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCULK).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCULK_VEIN).set(Sources.EARTH, 2).set(Sources.INFERNAL, 2).set(Sources.VOID, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCULK_SENSOR).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCULK_CATALYST).set(Sources.EARTH, 5).set(Sources.INFERNAL, 20).set(Sources.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCULK_SHRIEKER).set(Sources.EARTH, 5).set(Sources.INFERNAL, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MUD).set(Sources.EARTH, 5).set(Sources.SEA, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OCHRE_FROGLIGHT).set(Sources.EARTH, 20).set(Sources.SEA, 50).set(Sources.SUN, 15).set(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PEARLESCENT_FROGLIGHT).base((ItemLike)Items.OCHRE_FROGLIGHT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.VERDANT_FROGLIGHT).base((ItemLike)Items.OCHRE_FROGLIGHT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ECHO_SHARD).set(Sources.EARTH, 5).set(Sources.INFERNAL, 5).set(Sources.VOID, 5).set(Sources.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GOAT_HORN).set(Sources.EARTH, 5).set(Sources.SKY, 20).set(Sources.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ANGLER_POTTERY_SHERD).set(Sources.EARTH, 20).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ARCHER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.ARMS_UP_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BLADE_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BREWER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BURN_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.DANGER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPLORER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FLOW_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.FRIEND_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.GUSTER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HEART_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HEARTBREAK_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.HOWL_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MINER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.MOURNER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PLENTY_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.PRIZE_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SCRAPE_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SHEAF_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SHELTER_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SKULL_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.SNORT_POTTERY_SHERD).base((ItemLike)Items.ANGLER_POTTERY_SHERD).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.COPPER_BULB).set(Sources.EARTH, 38).set(Sources.SUN, 15).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.EXPOSED_COPPER_BULB).set(Sources.EARTH, 38).set(Sources.SUN, 12).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WEATHERED_COPPER_BULB).set(Sources.EARTH, 38).set(Sources.SUN, 8).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OXIDIZED_COPPER_BULB).set(Sources.EARTH, 38).set(Sources.SUN, 4).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_COPPER_BULB).base((ItemLike)Items.COPPER_BULB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_EXPOSED_COPPER_BULB).base((ItemLike)Items.EXPOSED_COPPER_BULB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_WEATHERED_COPPER_BULB).base((ItemLike)Items.WEATHERED_COPPER_BULB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.WAXED_OXIDIZED_COPPER_BULB).base((ItemLike)Items.OXIDIZED_COPPER_BULB).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TRIAL_SPAWNER).set(Sources.BLOOD, 20).set(Sources.INFERNAL, 10).set(Sources.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.TRIAL_KEY).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OMINOUS_TRIAL_KEY).set(Sources.HALLOWED, 50).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.VAULT).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.OMINOUS_BOTTLE).set(Sources.BLOOD, 20).set(Sources.INFERNAL, 20).set(Sources.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.BREEZE_ROD).set(Sources.SKY, 20).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.REINFORCED_DEEPSLATE).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.BARRIER).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.LIGHT).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.COMMAND_BLOCK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.REPEATING_COMMAND_BLOCK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.CHAIN_COMMAND_BLOCK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.STRUCTURE_BLOCK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.STRUCTURE_VOID).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.JIGSAW).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.FROGSPAWN).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHAINMAIL_HELMET).set(SourceList.builder().withEarth(24).withSky(24).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHAINMAIL_CHESTPLATE).set(SourceList.builder().withEarth(40).withSky(40).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHAINMAIL_LEGGINGS).set(SourceList.builder().withEarth(34).withSky(34).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.CHAINMAIL_BOOTS).set(SourceList.builder().withEarth(20).withSky(20).build()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.COMMAND_BLOCK_MINECART).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.KNOWLEDGE_BOOK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.DEBUG_STICK).build(consumer);
        SpawnEggItem.eggs().forEach(egg -> ItemAffinityBuilder.emptyAffinity((ItemLike)egg).build(consumer));
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.GRIMOIRE.get()).base((ItemLike)Items.ENCHANTED_BOOK).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.CREATIVE_GRIMOIRE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_RAW.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_SLAB.get()).base((ItemLike)ItemsPM.MARBLE_SLAB.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_STAIRS.get()).base((ItemLike)ItemsPM.MARBLE_STAIRS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_WALL.get()).base((ItemLike)ItemsPM.MARBLE_WALL.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICKS.get()).base((ItemLike)ItemsPM.MARBLE_BRICKS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_SLAB.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_SLAB.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_STAIRS.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_STAIRS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_WALL.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_WALL.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_PILLAR.get()).base((ItemLike)ItemsPM.MARBLE_PILLAR.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_CHISELED.get()).base((ItemLike)ItemsPM.MARBLE_CHISELED.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_RUNED.get()).base((ItemLike)ItemsPM.MARBLE_RUNED.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_SMOKED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(Sources.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_HALLOWED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(Sources.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_LOG.get()).base((ItemLike)Items.OAK_LOG).add(Sources.MOON, 20).remove(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_MOONWOOD_LOG.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_WOOD.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_MOONWOOD_WOOD.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_LEAVES.get()).base((ItemLike)Items.OAK_LEAVES).add(Sources.MOON, 10).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_SAPLING.get()).base((ItemLike)Items.OAK_SAPLING).add(Sources.MOON, 20).remove(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_PLANKS.get()).base((ItemLike)Items.OAK_PLANKS).add(Sources.MOON, 4).remove(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_SLAB.get()).base((ItemLike)Items.OAK_SLAB).add(Sources.MOON, 2).remove(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_LOG.get()).base((ItemLike)Items.OAK_LOG).add(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_SUNWOOD_LOG.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_WOOD.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_SUNWOOD_WOOD.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_LEAVES.get()).base((ItemLike)Items.OAK_LEAVES).add(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_SAPLING.get()).base((ItemLike)Items.OAK_SAPLING).add(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_PLANKS.get()).base((ItemLike)Items.OAK_PLANKS).add(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_SLAB.get()).base((ItemLike)Items.OAK_SLAB).add(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).base((ItemLike)Items.OAK_LOG).add(Sources.HALLOWED, 10).remove(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_HALLOWOOD_LOG.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_WOOD.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_HALLOWOOD_WOOD.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_LEAVES.get()).base((ItemLike)Items.OAK_LEAVES).add(Sources.HALLOWED, 5).remove(Sources.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_SAPLING.get()).base((ItemLike)Items.OAK_SAPLING).add(Sources.HALLOWED, 10).remove(Sources.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_PLANKS.get()).base((ItemLike)Items.OAK_PLANKS).add(Sources.HALLOWED, 2).remove(Sources.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_SLAB.get()).base((ItemLike)Items.OAK_SLAB).add(Sources.HALLOWED, 1).remove(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HYDROMELON_SEEDS.get()).base((ItemLike)Items.MELON_SEEDS).add(Sources.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HYDROMELON_SLICE.get()).base((ItemLike)Items.MELON_SLICE).add(Sources.SEA, 6).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOOD_ROSE.get()).set(SourceList.builder().withEarth(5).withMoon(5).withBlood(20).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.EMBERFLOWER.get()).base((ItemLike)Items.SUNFLOWER).add(Sources.SUN, 5).add(Sources.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_EARTH.get()).base((ItemLike)Items.STONE).add(Sources.EARTH, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SEA.get()).base((ItemLike)Items.STONE).add(Sources.SEA, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SKY.get()).base((ItemLike)Items.STONE).add(Sources.SKY, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SUN.get()).base((ItemLike)Items.STONE).add(Sources.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_MOON.get()).base((ItemLike)Items.STONE).add(Sources.MOON, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_AMETHYST_CLUSTER.get()).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_AMETHYST_BUD.get()).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_AMETHYST_BUD.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_AMETHYST_BUD.get()).set(Sources.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.AMETHYST_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.AMETHYST_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.AMETHYST_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_DIAMOND_CLUSTER.get()).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_DIAMOND_BUD.get()).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_DIAMOND_BUD.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_DIAMOND_BUD.get()).set(Sources.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.DIAMOND_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.DIAMOND_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.DIAMOND_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_EMERALD_CLUSTER.get()).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_EMERALD_BUD.get()).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_EMERALD_BUD.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_EMERALD_BUD.get()).set(Sources.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.EMERALD_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.EMERALD_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.EMERALD_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_QUARTZ_CLUSTER.get()).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_QUARTZ_BUD.get()).set(Sources.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_QUARTZ_BUD.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_QUARTZ_BUD.get()).set(Sources.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.QUARTZ_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.QUARTZ_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.QUARTZ_BLOCK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BLACK.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BROWN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_CYAN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_GREEN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIME.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_MAGENTA.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_ORANGE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PINK.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PURPLE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_RED.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_WHITE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_YELLOW.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SKYGLASS_PANE.get()).base((ItemLike)Items.GLASS_PANE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLACK.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BROWN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_CYAN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GREEN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIME.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_MAGENTA.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_ORANGE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PINK.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PURPLE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_RED.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_WHITE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_YELLOW.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_EARTH.get()).set(Sources.EARTH, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SEA.get()).set(Sources.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SKY.get()).set(Sources.SKY, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SUN.get()).set(Sources.SUN, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_MOON.get()).set(Sources.MOON, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ROCK_SALT_ORE.get()).base((ItemLike)Items.STONE).add(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.QUARTZ_ORE.get()).base((ItemLike)Items.STONE).add(Sources.EARTH, 10).add(Sources.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ARCANE_WORKBENCH.get()).base((ItemLike)Items.CRAFTING_TABLE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ESSENCE_FURNACE.get()).base((ItemLike)Items.FURNACE).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CALCINATOR_BASIC.get()).set(auraUnit.multiply(5.0)).set(Sources.EARTH, 46).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CALCINATOR_ENCHANTED.get()).set(auraUnit.multiply(26.0)).set(Sources.EARTH, 77).set(Sources.INFERNAL, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).set(Sources.SEA, 3).set(Sources.SKY, 3).set(Sources.SUN, 1).set(Sources.BLOOD, 4).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_ORANGE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_MAGENTA.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_YELLOW.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIME.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_PINK.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_GRAY.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_CYAN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_PURPLE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BLUE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BROWN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_GREEN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_RED.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BLACK.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MUNDANE_WAND.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MODULAR_WAND.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MODULAR_STAFF.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOODY_FLESH.get()).set(Sources.BLOOD, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOOD_NOTES.get()).set(Sources.BLOOD, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWED_ORB.get()).set(Sources.HALLOWED, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ENCHANTED_INK.get()).set(Sources.SEA, 3).set(Sources.MOON, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ROCK_SALT.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.REFINED_SALT.get()).base((ItemLike)ItemsPM.ROCK_SALT.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SALT_PINCH.get()).set(Sources.EARTH, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MANA_PRISM.get()).set(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MANA_SALTS.get()).set(auraUnit.multiply(5.0)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BEESWAX.get()).set(Sources.SEA, 2).set(Sources.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.PRIMALITE_INGOT.get()).set(auraUnit.multiply(3.0)).set(Sources.EARTH, 11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEXIUM_INGOT.get()).set(auraUnit.multiply(2.0)).set(Sources.EARTH, 8).set(Sources.BLOOD, 15).set(Sources.INFERNAL, 15).set(Sources.VOID, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWSTEEL_INGOT.get()).set(auraUnit).set(Sources.EARTH, 6).set(Sources.BLOOD, 11).set(Sources.INFERNAL, 11).set(Sources.VOID, 11).set(Sources.HALLOWED, 37).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SPELLCLOTH.get()).set(Sources.EARTH, 4).set(Sources.SEA, 4).set(Sources.SKY, 19).set(Sources.SUN, 4).set(Sources.MOON, 4).set(Sources.BLOOD, 9).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEXWEAVE.get()).set(Sources.EARTH, 3).set(Sources.SEA, 3).set(Sources.SKY, 29).set(Sources.SUN, 3).set(Sources.MOON, 3).set(Sources.BLOOD, 30).set(Sources.INFERNAL, 27).set(Sources.VOID, 27).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEARTWOOD.get()).set(auraUnit.multiply(5.0)).set(Sources.EARTH, 15).set(Sources.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INCENSE_STICK.get()).set(Sources.EARTH, 4).set(Sources.SKY, 5).set(Sources.SUN, 4).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DOWSING_ROD.get()).set(Sources.EARTH, 3).set(Sources.SUN, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FOUR_LEAF_CLOVER.get()).set(Sources.EARTH, 5).set(Sources.SUN, 5).set(Sources.MOON, 20).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_EARTH.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SEA.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SKY.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SUN.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_MOON.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_BLOOD.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_INFERNAL.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_VOID.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_HALLOWED.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.TREEFOLK_SEED.get()).set(Sources.EARTH, 20).set(Sources.SUN, 20).set(Sources.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.APPRENTICE_WAND_GEM_ITEM.get()).base((ItemLike)Items.DIAMOND).add(auraUnit.multiply(2.0)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ADEPT_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.APPRENTICE_WAND_GEM_ITEM.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.WIZARD_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.ADEPT_WAND_GEM_ITEM.get()).add(auraUnit.multiply(2.0)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ARCHMAGE_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.WIZARD_WAND_GEM_ITEM.get()).add(auraUnit.multiply(2.0)).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.CREATIVE_WAND_GEM_ITEM.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_EARTH.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_SEA.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_SKY.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_SUN.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_MOON.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_BLOOD.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_INFERNAL.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_VOID.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_DUST_HALLOWED.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_EARTH.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_SEA.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_SKY.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_SUN.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_MOON.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_BLOOD.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_INFERNAL.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_VOID.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_SHARD_HALLOWED.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_EARTH.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_SEA.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_SKY.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_SUN.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_MOON.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_VOID.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_EARTH.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_SEA.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_SKY.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_SUN.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_MOON.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_BLOOD.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_INFERNAL.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_VOID.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity(ItemsPM.ESSENCE_CLUSTER_HALLOWED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SPELL_SCROLL_FILLED.get()).base((ItemLike)ItemsPM.SPELL_SCROLL_BLANK.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MANA_SINGULARITY_CREATIVE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.ALCHEMICAL_WASTE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get()).set(Sources.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.OBSERVATION_NOTES.get()).set(auraUnit.multiply(5.0).add(Sources.HALLOWED, 5)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.THEORY_NOTES.get()).set(auraUnit.multiply(20.0).add(Sources.HALLOWED, 20)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get()).set(auraUnit.multiply(3.0).add(Sources.HALLOWED, 3)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SHEEP_TOME.get()).set(auraUnit.multiply(5.0).add(Sources.MOON, 15).add(Sources.HALLOWED, 20)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_BOOK.get()).base((ItemLike)Items.WRITTEN_BOOK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_BOOK_UNCOMMON.get()).base((ItemLike)Items.WRITTEN_BOOK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_BOOK_RARE.get()).base((ItemLike)Items.WRITTEN_BOOK).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_TABLET.get()).set(Sources.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LORE_TABLET_FRAGMENT.get()).set(Sources.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LORE_TABLET_DIRTY.get()).base((ItemLike)ItemsPM.STATIC_TABLET.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.TICK_STICK.get()).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ALLAY).value(Sources.SKY, 10).value(Sources.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ARMADILLO).value(Sources.SUN, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.AXOLOTL).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.BAT).value(Sources.SKY, 10).value(Sources.MOON, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.BEE).value(Sources.SKY, 10).value(Sources.SUN, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.BLAZE).value(Sources.SKY, 10).value(Sources.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.BOGGED).value(Sources.SEA, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.BREEZE).value(Sources.SKY, 25).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.CAMEL).value(Sources.SUN, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.CAT).value(Sources.MOON, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.CAVE_SPIDER).value(Sources.EARTH, 10).value(Sources.MOON, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.CHICKEN).value(Sources.SKY, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.COD).value(Sources.SEA, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.COW).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.CREEPER).value(Sources.EARTH, 5).value(Sources.SUN, 5).value(Sources.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.DOLPHIN).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.DONKEY).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.DROWNED).value(Sources.SEA, 5).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ELDER_GUARDIAN).value(Sources.SEA, 20).value(Sources.BLOOD, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ENDER_DRAGON).value(Sources.SKY, 20).value(Sources.BLOOD, 50).value(Sources.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ENDERMAN).value(Sources.BLOOD, 10).value(Sources.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ENDERMITE).value(Sources.BLOOD, 5).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.EVOKER).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.FOX).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.FROG).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.GHAST).value(Sources.SKY, 10).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.GLOW_SQUID).value(Sources.SEA, 10).value(Sources.SUN, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.GOAT).value(Sources.SKY, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.GUARDIAN).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.HOGLIN).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.HORSE).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.HUSK).value(Sources.SUN, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ILLUSIONER).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.IRON_GOLEM).value(Sources.EARTH, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.LLAMA).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.MAGMA_CUBE).value(Sources.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.MULE).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.MOOSHROOM).value(Sources.MOON, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.OCELOT).value(Sources.MOON, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PANDA).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PARROT).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PHANTOM).value(Sources.SKY, 10).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PIG).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PIGLIN).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PIGLIN_BRUTE).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PILLAGER).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.POLAR_BEAR).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.PUFFERFISH).value(Sources.SEA, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.RABBIT).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.RAVAGER).value(Sources.BLOOD, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SALMON).value(Sources.SEA, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SHEEP).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SHULKER).value(Sources.BLOOD, 10).value(Sources.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SILVERFISH).value(Sources.EARTH, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SKELETON).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SKELETON_HORSE).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SLIME).value(Sources.SEA, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SNIFFER).value(Sources.EARTH, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SNOW_GOLEM).value(Sources.SEA, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SPIDER).value(Sources.MOON, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.SQUID).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.STRAY).value(Sources.SEA, 5).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.STRIDER).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.TADPOLE).value(Sources.SEA, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.TRADER_LLAMA).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.TROPICAL_FISH).value(Sources.SEA, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.TURTLE).value(Sources.SEA, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.VEX).value(Sources.SKY, 10).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.VILLAGER).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.VINDICATOR).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WANDERING_TRADER).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WARDEN).value(Sources.EARTH, 50).value(Sources.INFERNAL, 20).value(Sources.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WITCH).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WITHER).value(Sources.SKY, 20).value(Sources.INFERNAL, 50).value(Sources.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WITHER_SKELETON).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 10).value(Sources.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.WOLF).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ZOGLIN).value(Sources.MOON, 10).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ZOMBIE).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ZOMBIE_HORSE).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ZOMBIE_VILLAGER).value(Sources.MOON, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.ZOMBIFIED_PIGLIN).value(Sources.MOON, 10).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.TREEFOLK.get()).value(Sources.EARTH, 10).value(Sources.SUN, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.INNER_DEMON.get()).value(Sources.BLOOD, 50).value(Sources.INFERNAL, 50).value(Sources.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.PRIMALITE_GOLEM.get()).value(Sources.EARTH, 30).value(Sources.SEA, 10).value(Sources.SKY, 10).value(Sources.SUN, 10).value(Sources.MOON, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.HEXIUM_GOLEM.get()).value(Sources.EARTH, 20).value(Sources.BLOOD, 10).value(Sources.INFERNAL, 10).value(Sources.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.HALLOWSTEEL_GOLEM.get()).value(Sources.EARTH, 20).value(Sources.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_EARTH_PIXIE.get()).value(Sources.EARTH, 5).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_EARTH_PIXIE.get()).value(Sources.EARTH, 10).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_EARTH_PIXIE.get()).value(Sources.EARTH, 20).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_SEA_PIXIE.get()).value(Sources.SEA, 5).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_SEA_PIXIE.get()).value(Sources.SEA, 10).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_SEA_PIXIE.get()).value(Sources.SEA, 20).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_SKY_PIXIE.get()).value(Sources.SKY, 15).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_SKY_PIXIE.get()).value(Sources.SKY, 20).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_SKY_PIXIE.get()).value(Sources.SKY, 30).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_SUN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.SUN, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_SUN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.SUN, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_SUN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.SUN, 20).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_MOON_PIXIE.get()).value(Sources.SKY, 10).value(Sources.MOON, 5).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_MOON_PIXIE.get()).value(Sources.SKY, 10).value(Sources.MOON, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_MOON_PIXIE.get()).value(Sources.SKY, 10).value(Sources.MOON, 20).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_BLOOD_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_BLOOD_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 15).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_BLOOD_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 25).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_INFERNAL_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_INFERNAL_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_INFERNAL_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_VOID_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_VOID_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_VOID_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_HALLOWED_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.HALLOWED, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_HALLOWED_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_HALLOWED_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).value(Sources.HALLOWED, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.PIXIE_HOUSE.get()).value(Sources.EARTH, 5).value(Sources.SKY, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.BASIC_GUARDIAN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.GRAND_GUARDIAN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityTypesPM.MAJESTIC_GUARDIAN_PIXIE.get()).value(Sources.SKY, 10).value(Sources.BLOOD, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.NIGHT_VISION).bonus(Sources.MOON, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_NIGHT_VISION).bonus(Sources.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.INVISIBILITY).bonus(Sources.MOON, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_INVISIBILITY).bonus(Sources.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LEAPING).bonus(Sources.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_LEAPING).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_LEAPING).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.FIRE_RESISTANCE).bonus(Sources.INFERNAL, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_FIRE_RESISTANCE).bonus(Sources.INFERNAL, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.SWIFTNESS).bonus(Sources.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_SWIFTNESS).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_SWIFTNESS).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.SLOWNESS).bonus(Sources.SKY, 1).bonus(Sources.VOID, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_SLOWNESS).bonus(Sources.SKY, 2).bonus(Sources.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_SLOWNESS).bonus(Sources.SKY, 2).bonus(Sources.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.TURTLE_MASTER).bonus(Sources.SEA, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_TURTLE_MASTER).bonus(Sources.SEA, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_TURTLE_MASTER).bonus(Sources.SEA, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.WATER_BREATHING).bonus(Sources.SEA, 1).bonus(Sources.SKY, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_WATER_BREATHING).bonus(Sources.SEA, 2).bonus(Sources.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.HEALING).bonus(Sources.SUN, 1).bonus(Sources.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_HEALING).bonus(Sources.SUN, 2).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.HARMING).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_HARMING).bonus(Sources.BLOOD, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.POISON).bonus(Sources.EARTH, 1).bonus(Sources.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_POISON).bonus(Sources.EARTH, 2).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_POISON).bonus(Sources.EARTH, 2).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.REGENERATION).bonus(Sources.SUN, 1).bonus(Sources.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_REGENERATION).bonus(Sources.SUN, 2).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_REGENERATION).bonus(Sources.SUN, 2).bonus(Sources.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRENGTH).bonus(Sources.EARTH, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_STRENGTH).bonus(Sources.EARTH, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.STRONG_STRENGTH).bonus(Sources.EARTH, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.WEAKNESS).bonus(Sources.EARTH, 1).bonus(Sources.VOID, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_WEAKNESS).bonus(Sources.EARTH, 2).bonus(Sources.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LUCK).bonus(Sources.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.SLOW_FALLING).bonus(Sources.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.LONG_SLOW_FALLING).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.WIND_CHARGED).bonus(Sources.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.WEAVING).bonus(Sources.BLOOD, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.OOZING).bonus(Sources.SEA, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity((Holder<Potion>)Potions.INFESTED).bonus(Sources.BLOOD, 5).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.PROTECTION).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION).multiplier(Sources.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.RESPIRATION).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.THORNS).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.SHARPNESS).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.SMITE).multiplier(Sources.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.BANE_OF_ARTHROPODS).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT).multiplier(Sources.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.LOOTING).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.UNBREAKING).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FORTUNE).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.POWER).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.PUNCH).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.FLAME).multiplier(Sources.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.INFINITY).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.LURE).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.LOYALTY).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.IMPALING).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.RIPTIDE).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.CHANNELING).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.MULTISHOT).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.QUICK_CHARGE).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.PIERCING).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.DENSITY).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.BREACH).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.WIND_BURST).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.MENDING).multiplier(Sources.SUN).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.LIFESTEAL).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.ENDERLOCK).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.JUDGMENT).multiplier(Sources.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.ENDERPORT).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.REGROWTH).multiplier(Sources.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.AEGIS).multiplier(Sources.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.MANA_EFFICIENCY).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.SPELL_POWER).multiplier(Sources.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.TREASURE).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.BLUDGEONING).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.REVERBERATION).multiplier(Sources.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.BOUNTY).multiplier(Sources.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.DISINTEGRATION).multiplier(Sources.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.VERDANT).multiplier(Sources.SUN).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.LUCKY_STRIKE).multiplier(Sources.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.RENDING).multiplier(Sources.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.SOULPIERCING).multiplier(Sources.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.ESSENCE_THIEF).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.BULWARK).multiplier(Sources.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.MAGICK_PROTECTION).multiplier(Sources.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(lookupProvider, EnchantmentsPM.GUILLOTINE).multiplier(Sources.BLOOD).build(consumer);
    }

    public String getName() {
        return "Primal Magick Affinities";
    }
}

