/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures.library;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.Culture;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructureTypesPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.library.NetherLibraryPiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class NetherLibraryStructure
extends Structure {
    public static final MapCodec<NetherLibraryStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NetherLibraryStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)ResourceKey.codec(RegistryKeysPM.CULTURES).fieldOf("culture_key").forGetter(library -> library.cultureKey), (App)HeightProvider.CODEC.fieldOf("height").forGetter(library -> library.height)).apply((Applicative)instance, NetherLibraryStructure::new));
    private final HeightProvider height;
    private final ResourceKey<Culture> cultureKey;

    public NetherLibraryStructure(Structure.StructureSettings config, ResourceKey<Culture> cultureKey, HeightProvider heightProvider) {
        super(config);
        this.cultureKey = cultureKey;
        this.height = heightProvider;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext pContext) {
        WorldgenRandom random = pContext.random();
        int x = pContext.chunkPos().getMinBlockX() + random.nextInt(16);
        int z = pContext.chunkPos().getMinBlockZ() + random.nextInt(16);
        int minY = pContext.chunkGenerator().getSeaLevel();
        int y = this.height.sample((RandomSource)random, new WorldGenerationContext(pContext.chunkGenerator(), pContext.heightAccessor()));
        NoiseColumn column = pContext.chunkGenerator().getBaseColumn(x, z, pContext.heightAccessor(), pContext.randomState());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > minY) {
            BlockState above = column.getBlock(y);
            BlockState below = column.getBlock(--y);
            if (!above.isAir() || below.is(Blocks.BEDROCK) || !below.is(Blocks.SOUL_SAND) && !below.isFaceSturdy((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mutablePos.setY(y), Direction.UP)) continue;
            break;
        }
        if (y <= minY) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)new NetherLibraryPiece(pContext.structureTemplateManager(), this.cultureKey, pos))));
    }

    public StructureType<?> type() {
        return StructureTypesPM.NETHER_LIBRARY.get();
    }
}

