/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures.library;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.Culture;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructureTypesPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.library.LibraryPiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class LibraryStructure
extends Structure {
    public static final MapCodec<LibraryStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LibraryStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)ResourceKey.codec(RegistryKeysPM.CULTURES).fieldOf("culture_key").forGetter(library -> library.cultureKey)).apply((Applicative)instance, LibraryStructure::new));
    private final ResourceKey<Culture> cultureKey;

    public LibraryStructure(Structure.StructureSettings config, ResourceKey<Culture> cultureKey) {
        super(config);
        this.cultureKey = cultureKey;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext pContext) {
        return LibraryStructure.onTopOfChunkCenter((Structure.GenerationContext)pContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, pContext));
    }

    public StructureType<?> type() {
        return StructureTypesPM.LIBRARY.get();
    }

    protected void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.chunkPos().getMiddleBlockX();
        int z = context.chunkPos().getMiddleBlockZ();
        int surfaceY = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        BlockPos pos = new BlockPos(x, surfaceY, z);
        builder.addPiece((StructurePiece)new LibraryPiece(context.structureTemplateManager(), this.cultureKey, pos));
    }
}

