/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures.library;

import com.verdantartifice.primalmagick.common.books.Culture;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.tiles.base.IRandomizableContents;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructurePieceTypesPM;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class AbstractLibraryPiece
extends TemplateStructurePiece {
    protected final ResourceKey<Culture> cultureKey;

    public AbstractLibraryPiece(StructureTemplateManager templateManager, ResourceLocation template, ResourceKey<Culture> cultureKey, BlockPos pos) {
        super(StructurePieceTypesPM.LIBRARY.get(), 0, templateManager, template, template.toString(), AbstractLibraryPiece.makePlaceSettings(), pos);
        this.cultureKey = cultureKey;
    }

    public AbstractLibraryPiece(StructureTemplateManager templateManager, CompoundTag nbt) {
        super(StructurePieceTypesPM.LIBRARY.get(), nbt, templateManager, dummy -> AbstractLibraryPiece.makePlaceSettings());
        this.cultureKey = ResourceKey.create(RegistryKeysPM.CULTURES, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("Culture")));
    }

    public AbstractLibraryPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(StructurePieceTypesPM.LIBRARY.get(), nbt, context.structureTemplateManager(), dummy -> AbstractLibraryPiece.makePlaceSettings());
        this.cultureKey = ResourceKey.create(RegistryKeysPM.CULTURES, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("Culture")));
    }

    protected static StructurePlaceSettings makePlaceSettings() {
        return new StructurePlaceSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext pContext, CompoundTag pTag) {
        super.addAdditionalSaveData(pContext, pTag);
        pTag.putString("Culture", this.cultureKey.location().toString());
    }

    protected abstract BlockState getFillerBlockState();

    protected abstract BlockState getBrickBlockState();

    protected void handleDataMarker(String pName, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pBox) {
        Holder.Reference culture = pLevel.registryAccess().registryOrThrow(RegistryKeysPM.CULTURES).getHolderOrThrow(this.cultureKey);
        if ("shelf_low".equals(pName)) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos.above());
            if (blockEntity instanceof IRandomizableContents) {
                IRandomizableContents container = (IRandomizableContents)blockEntity;
                container.setLootTable(((Culture)culture.value()).shelfLootTable(), pRandom.nextLong());
            }
            pLevel.setBlock(pPos, this.getFillerBlockState(), 3);
        } else if ("shelf_high".equals(pName)) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos.below());
            if (blockEntity instanceof IRandomizableContents) {
                IRandomizableContents container = (IRandomizableContents)blockEntity;
                container.setLootTable(((Culture)culture.value()).shelfLootTable(), pRandom.nextLong());
            }
            pLevel.setBlock(pPos, this.getBrickBlockState(), 3);
        } else if ("welcome".equals(pName)) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos.above());
            if (blockEntity instanceof IRandomizableContents) {
                IRandomizableContents container = (IRandomizableContents)blockEntity;
                container.setLootTable(((Culture)culture.value()).welcomeLootTable(), pRandom.nextLong());
            }
            pLevel.setBlock(pPos, this.getFillerBlockState(), 3);
        } else if ("hidden".equals(pName)) {
            BlockEntity blockEntity;
            if (pRandom.nextDouble() < 0.25 && (blockEntity = pLevel.getBlockEntity(pPos.below())) instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                container.setLootTable(((Culture)culture.value()).hiddenLootTable(), pRandom.nextLong());
            } else {
                pLevel.setBlock(pPos, this.getFillerBlockState(), 3);
                pLevel.setBlock(pPos.below(), this.getFillerBlockState(), 3);
            }
        } else if ("accent".equals(pName)) {
            pLevel.setBlock(pPos, ((Culture)culture.value()).accentBlockState(), 3);
        }
    }
}

