/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.verdantartifice.primalmagick.common.books.Culture;
import com.verdantartifice.primalmagick.common.books.CulturesPM;
import com.verdantartifice.primalmagick.common.tags.BiomeTagsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrineStructure;
import com.verdantartifice.primalmagick.common.worldgen.structures.library.LibraryStructure;
import com.verdantartifice.primalmagick.common.worldgen.structures.library.NetherLibraryStructure;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class StructuresPM {
    public static final ResourceKey<Structure> EARTH_SHRINE = StructuresPM.registryKey("earth_shrine");
    public static final ResourceKey<Structure> SEA_SHRINE = StructuresPM.registryKey("sea_shrine");
    public static final ResourceKey<Structure> SKY_SHRINE = StructuresPM.registryKey("sky_shrine");
    public static final ResourceKey<Structure> SUN_SHRINE = StructuresPM.registryKey("sun_shrine");
    public static final ResourceKey<Structure> MOON_SHRINE = StructuresPM.registryKey("moon_shrine");
    public static final ResourceKey<Structure> EARTH_LIBRARY = StructuresPM.registryKey("earth_library");
    public static final ResourceKey<Structure> SEA_LIBRARY = StructuresPM.registryKey("sea_library");
    public static final ResourceKey<Structure> SKY_LIBRARY = StructuresPM.registryKey("sky_library");
    public static final ResourceKey<Structure> SUN_LIBRARY = StructuresPM.registryKey("sun_library");
    public static final ResourceKey<Structure> MOON_LIBRARY = StructuresPM.registryKey("moon_library");
    public static final ResourceKey<Structure> FORBIDDEN_LIBRARY = StructuresPM.registryKey("forbidden_library");

    private static ResourceKey<Structure> registryKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceUtils.loc(name));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> pBiomes, Map<MobCategory, StructureSpawnOverride> pSpawnOverrides, GenerationStep.Decoration pStep, TerrainAdjustment pTerrainAdaptation) {
        return new Structure.StructureSettings(pBiomes, pSpawnOverrides, pStep, pTerrainAdaptation);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> pBiomes) {
        return StructuresPM.structure(pBiomes, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN);
    }

    private static void registerShrine(BootstrapContext<Structure> context, ResourceKey<Structure> structureKey, HolderSet<Biome> biomes, ShrineStructure.Type shrineType) {
        context.register(structureKey, (Object)new ShrineStructure(StructuresPM.structure(biomes), shrineType));
    }

    private static void registerLibrary(BootstrapContext<Structure> context, ResourceKey<Structure> structureKey, HolderSet<Biome> biomes, ResourceKey<Culture> cultureKey) {
        context.register(structureKey, (Object)new LibraryStructure(StructuresPM.structure(biomes), cultureKey));
    }

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        StructuresPM.registerShrine(context, EARTH_SHRINE, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_EARTH_SHRINE), ShrineStructure.Type.EARTH);
        StructuresPM.registerShrine(context, SEA_SHRINE, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SEA_SHRINE), ShrineStructure.Type.SEA);
        StructuresPM.registerShrine(context, SKY_SHRINE, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SKY_SHRINE), ShrineStructure.Type.SKY);
        StructuresPM.registerShrine(context, SUN_SHRINE, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SUN_SHRINE), ShrineStructure.Type.SUN);
        StructuresPM.registerShrine(context, MOON_SHRINE, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_MOON_SHRINE), ShrineStructure.Type.MOON);
        StructuresPM.registerLibrary(context, EARTH_LIBRARY, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_EARTH_LIBRARY), CulturesPM.EARTH);
        StructuresPM.registerLibrary(context, SEA_LIBRARY, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SEA_LIBRARY), CulturesPM.SEA);
        StructuresPM.registerLibrary(context, SKY_LIBRARY, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SKY_LIBRARY), CulturesPM.SKY);
        StructuresPM.registerLibrary(context, SUN_LIBRARY, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_SUN_LIBRARY), CulturesPM.SUN);
        StructuresPM.registerLibrary(context, MOON_LIBRARY, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTagsPM.HAS_MOON_LIBRARY), CulturesPM.MOON);
        context.register(FORBIDDEN_LIBRARY, (Object)new NetherLibraryStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(BiomeTagsPM.HAS_FORBIDDEN_LIBRARY), Map.of(), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_THIN), CulturesPM.FORBIDDEN, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.belowTop((int)10))));
    }
}

