/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructuresPM;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureSetsPM {
    public static final ResourceKey<StructureSet> SHRINES = StructureSetsPM.registryKey("shrines");
    public static final ResourceKey<StructureSet> LIBRARIES = StructureSetsPM.registryKey("libraries");

    private static ResourceKey<StructureSet> registryKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceUtils.loc(name));
    }

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter structureGetter = context.lookup(Registries.STRUCTURE);
        context.register(SHRINES, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.EARTH_SHRINE)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SEA_SHRINE)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SKY_SHRINE)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SUN_SHRINE)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.MOON_SHRINE))), (StructurePlacement)new RandomSpreadStructurePlacement(20, 10, RandomSpreadType.LINEAR, 11893192)));
        context.register(LIBRARIES, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.EARTH_LIBRARY)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SEA_LIBRARY)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SKY_LIBRARY)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.SUN_LIBRARY)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.MOON_LIBRARY)), StructureSet.entry((Holder)structureGetter.getOrThrow(StructuresPM.FORBIDDEN_LIBRARY))), (StructurePlacement)new RandomSpreadStructurePlacement(30, 15, RandomSpreadType.LINEAR, 11893193)));
    }
}

