/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrinePiece;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructureTypesPM;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ShrineStructure
extends Structure {
    public static final MapCodec<ShrineStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShrineStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Type.CODEC.fieldOf("shrine_type").forGetter(shrine -> shrine.shrineType)).apply((Applicative)instance, ShrineStructure::new));
    private final Type shrineType;

    public ShrineStructure(Structure.StructureSettings config, Type shrineType) {
        super(config);
        this.shrineType = shrineType;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return ShrineStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    public StructureType<?> type() {
        return StructureTypesPM.SHRINE.get();
    }

    protected void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.chunkPos().getMiddleBlockX();
        int z = context.chunkPos().getMiddleBlockZ();
        int surfaceY = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        BlockPos pos = new BlockPos(x, surfaceY, z);
        builder.addPiece((StructurePiece)new ShrinePiece(context.structureTemplateManager(), this.shrineType, pos));
    }

    public static enum Type implements StringRepresentable
    {
        EARTH("earth"),
        SEA("sea"),
        SKY("sky"),
        SUN("sun"),
        MOON("moon");

        private final String name;
        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;

        private Type(String name) {
            this.name = name;
        }

        public static Type byName(String name) {
            return BY_NAME.get(name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getSerializedName, type -> type));
        }
    }
}

