/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrineStructure;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructurePieceTypesPM;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ShrinePiece
extends TemplateStructurePiece {
    protected static final ResourceLocation TEMPLATE = ResourceUtils.loc("shrine");
    protected final ShrineStructure.Type type;

    public ShrinePiece(StructureTemplateManager templateManager, ShrineStructure.Type type, BlockPos pos) {
        super(StructurePieceTypesPM.SHRINE.get(), 0, templateManager, TEMPLATE, TEMPLATE.toString(), ShrinePiece.makePlaceSettings(), pos);
        this.type = type;
    }

    public ShrinePiece(StructureTemplateManager templateManager, CompoundTag nbt) {
        super(StructurePieceTypesPM.SHRINE.get(), nbt, templateManager, dummy -> ShrinePiece.makePlaceSettings());
        this.type = ShrineStructure.Type.byName(nbt.getString("Source"));
    }

    public ShrinePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(StructurePieceTypesPM.SHRINE.get(), nbt, context.structureTemplateManager(), dummy -> ShrinePiece.makePlaceSettings());
        this.type = ShrineStructure.Type.byName(nbt.getString("Source"));
    }

    protected static StructurePlaceSettings makePlaceSettings() {
        return new StructurePlaceSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        super.addAdditionalSaveData(context, tagCompound);
        tagCompound.putString("Source", this.type.getSerializedName());
    }

    protected void handleDataMarker(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
        if ("font".equals(function)) {
            worldIn.setBlock(pos, this.getFont().defaultBlockState(), 3);
        }
    }

    @Nonnull
    protected Block getFont() {
        if (this.type == null) {
            return Blocks.AIR;
        }
        if (this.type.equals((Object)ShrineStructure.Type.EARTH)) {
            return (Block)BlocksPM.ANCIENT_FONT_EARTH.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SEA)) {
            return (Block)BlocksPM.ANCIENT_FONT_SEA.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SKY)) {
            return (Block)BlocksPM.ANCIENT_FONT_SKY.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SUN)) {
            return (Block)BlocksPM.ANCIENT_FONT_SUN.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.MOON)) {
            return (Block)BlocksPM.ANCIENT_FONT_MOON.get();
        }
        return Blocks.AIR;
    }

    @Nonnull
    protected Block getInfusedStone() {
        if (this.type == null) {
            return Blocks.AIR;
        }
        if (this.type.equals((Object)ShrineStructure.Type.EARTH)) {
            return BlocksPM.INFUSED_STONE_EARTH.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SEA)) {
            return BlocksPM.INFUSED_STONE_SEA.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SKY)) {
            return BlocksPM.INFUSED_STONE_SKY.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SUN)) {
            return BlocksPM.INFUSED_STONE_SUN.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.MOON)) {
            return BlocksPM.INFUSED_STONE_MOON.get();
        }
        return Blocks.AIR;
    }

    public void postProcess(WorldGenLevel worldIn, StructureManager structureManager, ChunkGenerator generator, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
        int i = worldIn.getHeight(Heightmap.Types.WORLD_SURFACE_WG, this.templatePosition.getX(), this.templatePosition.getZ());
        this.templatePosition = new BlockPos(this.templatePosition.getX(), i, this.templatePosition.getZ());
        super.postProcess(worldIn, structureManager, generator, randomIn, structureBoundingBoxIn, chunkPos, blockPos);
        BlockState bs = this.getInfusedStone().defaultBlockState();
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (int x = 2; x < 11; ++x) {
            for (int y = -3; y < 0; ++y) {
                for (int z = 2; z < 11; ++z) {
                    mbp.set(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
                    if (worldIn.isEmptyBlock((BlockPos)mbp) || randomIn.nextInt(10) >= 3) continue;
                    this.placeBlock(worldIn, bs, x, y, z, structureBoundingBoxIn);
                }
            }
        }
    }
}

