/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

@Immutable
public class WandGem
implements IWandComponent {
    protected static final Map<String, WandGem> REGISTRY = new HashMap<String, WandGem>();
    public static final Codec<WandGem> CODEC = Codec.STRING.xmap(WandGem::getWandGem, WandGem::getTag);
    public static final StreamCodec<ByteBuf, WandGem> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(WandGem::getWandGem, WandGem::getTag);
    public static final WandGem APPRENTICE = new WandGem("apprentice", Rarity.COMMON, 7500);
    public static final WandGem ADEPT = new WandGem("adept", Rarity.UNCOMMON, 25000);
    public static final WandGem WIZARD = new WandGem("wizard", Rarity.RARE, 75000);
    public static final WandGem ARCHMAGE = new WandGem("archmage", Rarity.EPIC, 250000);
    public static final WandGem CREATIVE = new WandGem("creative", Rarity.EPIC, -1);
    protected final String tag;
    protected final int capacity;
    protected final Rarity rarity;
    protected final ResourceLocation mrlNamespace;

    public WandGem(@Nonnull String tag, @Nonnull Rarity rarity, int capacity) {
        this(tag, rarity, capacity, ResourceUtils.loc(tag + "_wand_gem"));
    }

    public WandGem(@Nonnull String tag, @Nonnull Rarity rarity, int capacity, @Nonnull ResourceLocation mrln) {
        if (REGISTRY.containsKey(tag)) {
            throw new IllegalArgumentException("Wand gem " + tag + " already registered!");
        }
        this.tag = tag;
        this.capacity = capacity;
        this.rarity = rarity;
        this.mrlNamespace = mrln;
        REGISTRY.put(tag, this);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public IWandComponent.Type getComponentType() {
        return IWandComponent.Type.GEM;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Nonnull
    public ResourceLocation getModelResourceLocationNamespace() {
        return this.mrlNamespace;
    }

    @Nonnull
    public static Collection<WandGem> getAllWandGems() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    @Nullable
    public static WandGem getWandGem(@Nullable String tag) {
        return REGISTRY.get(tag);
    }

    public boolean equals(Object o) {
        if (!(o instanceof WandGem)) {
            return false;
        }
        WandGem wandGem = (WandGem)o;
        return this.capacity == wandGem.capacity && Objects.equals(this.tag, wandGem.tag) && this.rarity == wandGem.rarity && Objects.equals(this.mrlNamespace, wandGem.mrlNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.capacity, this.rarity, this.mrlNamespace);
    }
}

