/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

@Immutable
public class WandCap
implements IWandComponent {
    protected static final Map<String, WandCap> REGISTRY = new HashMap<String, WandCap>();
    public static final Codec<WandCap> CODEC = Codec.STRING.xmap(WandCap::getWandCap, WandCap::getTag);
    public static final StreamCodec<ByteBuf, WandCap> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(WandCap::getWandCap, WandCap::getTag);
    public static final WandCap IRON = new WandCap("iron", Rarity.COMMON, 10, 100);
    public static final WandCap GOLD = new WandCap("gold", Rarity.COMMON, 20, 200);
    public static final WandCap PRIMALITE = new WandCap("primalite", Rarity.UNCOMMON, 25, 400);
    public static final WandCap HEXIUM = new WandCap("hexium", Rarity.RARE, 30, 800);
    public static final WandCap HALLOWSTEEL = new WandCap("hallowsteel", Rarity.EPIC, 35, 1600);
    protected final String tag;
    protected final Rarity rarity;
    protected final int baseCostModifier;
    protected final int siphonAmount;
    protected final ResourceLocation wandMrlNamespace;
    protected final ResourceLocation staffMrlNamespace;

    public WandCap(@Nonnull String tag, @Nonnull Rarity rarity, int costModifier, int siphon) {
        this(tag, rarity, costModifier, siphon, ResourceUtils.loc(tag + "_wand_cap"), ResourceUtils.loc(tag + "_staff_cap"));
    }

    public WandCap(@Nonnull String tag, @Nonnull Rarity rarity, int costModifier, int siphon, @Nonnull ResourceLocation wmrln, @Nonnull ResourceLocation smrln) {
        if (REGISTRY.containsKey(tag)) {
            throw new IllegalArgumentException("Wand cap " + tag + " already registered!");
        }
        this.tag = tag;
        this.rarity = rarity;
        this.baseCostModifier = costModifier;
        this.siphonAmount = siphon;
        this.wandMrlNamespace = wmrln;
        this.staffMrlNamespace = smrln;
        REGISTRY.put(tag, this);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public IWandComponent.Type getComponentType() {
        return IWandComponent.Type.CAP;
    }

    public int getBaseCostModifier() {
        return this.baseCostModifier;
    }

    public int getSiphonAmount() {
        return this.siphonAmount;
    }

    @Nonnull
    public ResourceLocation getWandModelResourceLocationNamespace() {
        return this.wandMrlNamespace;
    }

    @Nonnull
    public ResourceLocation getStaffModelResourceLocationNamespace() {
        return this.staffMrlNamespace;
    }

    @Nonnull
    public static Collection<WandCap> getAllWandCaps() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    @Nullable
    public static WandCap getWandCap(@Nullable String tag) {
        return REGISTRY.get(tag);
    }

    public boolean equals(Object o) {
        if (!(o instanceof WandCap)) {
            return false;
        }
        WandCap wandCap = (WandCap)o;
        return this.baseCostModifier == wandCap.baseCostModifier && this.siphonAmount == wandCap.siphonAmount && Objects.equals(this.tag, wandCap.tag) && this.rarity == wandCap.rarity && Objects.equals(this.wandMrlNamespace, wandCap.wandMrlNamespace) && Objects.equals(this.staffMrlNamespace, wandCap.staffMrlNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.rarity, this.baseCostModifier, this.siphonAmount, this.wandMrlNamespace, this.staffMrlNamespace);
    }
}

