/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.wands.IManaContainer;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.text.DecimalFormat;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManaManager {
    private static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static int getMana(@Nullable Player player, @Nullable Source source) {
        if (player != null && source != null) {
            return ManaManager.collectManaAmount((TriFunction<IManaContainer, ItemStack, Source, Integer>)((TriFunction)ManaManager::getStackMana), source, ManaManager.getPrioritizedEquipment(player, player.getMainHandItem()));
        }
        return 0;
    }

    private static int collectManaAmount(@NotNull TriFunction<IManaContainer, ItemStack, Source, Integer> extractor, @NotNull Source source, @NotNull List<ItemStack> stacks) {
        int retVal = 0;
        for (ItemStack stack : stacks) {
            Item item = stack.getItem();
            if (!(item instanceof IManaContainer)) continue;
            IManaContainer container = (IManaContainer)item;
            int amount = (Integer)extractor.apply((Object)container, (Object)stack, (Object)source);
            if (amount == -1) {
                return -1;
            }
            retVal += amount;
        }
        return retVal;
    }

    private static int getStackMana(@NotNull IManaContainer container, @NotNull ItemStack itemStack, @NotNull Source source) {
        return container.getMana(itemStack, source);
    }

    @NotNull
    public static MutableComponent getManaText(@Nullable Player player, @Nullable Source source) {
        return ManaManager.formatManaAmountText(ManaManager.getMana(player, source));
    }

    @NotNull
    private static MutableComponent formatManaAmountText(int amount) {
        if (amount == -1) {
            return Component.literal((String)Character.toString('\u221e'));
        }
        return Component.literal((String)MANA_FORMATTER.format((double)amount / 100.0));
    }

    @NotNull
    public static SourceList getAllMana(@Nullable Player player) {
        if (player == null) {
            return SourceList.EMPTY;
        }
        return Stream.of(player.getMainHandItem(), player.getOffhandItem()).map(stack -> {
            SourceList sourceList;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IManaContainer) {
                IManaContainer container = (IManaContainer)patt0$temp;
                sourceList = container.getAllMana((ItemStack)stack);
            } else {
                sourceList = SourceList.EMPTY;
            }
            return sourceList;
        }).reduce(SourceList.EMPTY, ManaManager::combineSourceLists);
    }

    @NotNull
    private static SourceList combineSourceLists(@NotNull SourceList lhs, @NotNull SourceList rhs) {
        SourceList retVal = SourceList.EMPTY;
        for (Source source : Sources.getAllSorted()) {
            OptionalInt amountOpt = ManaManager.combineSourceAmounts(source, lhs, rhs);
            if (!amountOpt.isPresent()) continue;
            retVal.set(source, amountOpt.getAsInt());
        }
        return retVal;
    }

    @NotNull
    private static OptionalInt combineSourceAmounts(@NotNull Source source, @NotNull SourceList lhs, @NotNull SourceList rhs) {
        if (lhs.getAmount(source) == -1 || rhs.getAmount(source) == -1) {
            return OptionalInt.of(-1);
        }
        if (!lhs.isPresent(source) && !rhs.isPresent(source)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(lhs.getAmount(source) + rhs.getAmount(source));
    }

    public static int getMaxMana(@Nullable Player player, @Nullable Source source) {
        if (player != null && source != null) {
            return ManaManager.collectManaAmount((TriFunction<IManaContainer, ItemStack, Source, Integer>)((TriFunction)ManaManager::getStackMaxMana), source, ManaManager.getPrioritizedEquipment(player, player.getMainHandItem()));
        }
        return 0;
    }

    private static int getStackMaxMana(@NotNull IManaContainer container, @NotNull ItemStack itemStack, @NotNull Source source) {
        return container.getMaxMana(itemStack, source);
    }

    @NotNull
    public static MutableComponent getMaxManaText(@Nullable Player player, @Nullable Source source) {
        return ManaManager.formatManaAmountText(ManaManager.getMaxMana(player, source));
    }

    public static int addMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable Source source, int amount) {
        return ManaManager.addMana(player, wandStack, source, amount, ManaManager.getMaxMana(player, source));
    }

    public static int addMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable Source source, int amount, int max) {
        if (player == null || wandStack == null || source == null) {
            return amount;
        }
        for (ItemStack stack : ManaManager.getPrioritizedEquipment(player, wandStack)) {
            Item item = stack.getItem();
            if (!(item instanceof IManaContainer)) continue;
            IManaContainer container = (IManaContainer)item;
            if (amount <= 0) continue;
            amount = container.addMana(stack, source, amount, max);
        }
        return amount;
    }

    @NotNull
    private static List<ItemStack> getPrioritizedEquipment(@NotNull Player player, @NotNull ItemStack wandStack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)wandStack);
        ItemStack offhandStack = ManaManager.getOffhandStack(player, wandStack);
        if (!(wandStack.getItem() instanceof IWand) || !(offhandStack.getItem() instanceof IWand)) {
            builder.add((Object)offhandStack);
        }
        return builder.build();
    }

    public static boolean consumeMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable Source source, int amount, HolderLookup.Provider registries) {
        int leftover;
        int modifiedAmount;
        if (!ManaManager.containsMana(player, wandStack, source, amount, registries)) {
            return false;
        }
        if (ManaManager.getMana(player, source) == -1) {
            ManaManager.recordManaConsumptionSideEffects(player, source, amount);
            return true;
        }
        Item item = wandStack.getItem();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            v0 = wand.getModifiedCost(wandStack, player, source, amount, registries);
        } else {
            v0 = modifiedAmount = amount;
        }
        if (modifiedAmount > 0 && (leftover = ManaManager.deductManaInner(player, wandStack, source, modifiedAmount)) > 0) {
            LOGGER.warn("Leftover mana when trying to consume from player equipment: {}", (Object)leftover);
        }
        ManaManager.recordManaConsumptionSideEffects(player, source, amount);
        return true;
    }

    public static boolean consumeMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable SourceList sources, HolderLookup.Provider registries) {
        if (player == null || sources == null || wandStack == null || !ManaManager.containsMana(player, wandStack, sources, registries)) {
            return false;
        }
        for (Source source : sources.getSources()) {
            int rawAmount = sources.getAmount(source);
            if (ManaManager.getMana(player, source) != -1) {
                int leftover;
                int modifiedAmount;
                Item item = wandStack.getItem();
                if (item instanceof IWand) {
                    IWand wand = (IWand)item;
                    v0 = wand.getModifiedCost(wandStack, player, source, rawAmount, registries);
                } else {
                    v0 = modifiedAmount = rawAmount;
                }
                if (modifiedAmount > 0 && (leftover = ManaManager.deductManaInner(player, wandStack, source, modifiedAmount)) > 0) {
                    LOGGER.warn("Leftover mana when trying to consume batch from player equipment: {}", (Object)leftover);
                }
            }
            ManaManager.recordManaConsumptionSideEffects(player, source, rawAmount);
        }
        return true;
    }

    public static boolean removeManaRaw(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable Source source, int amount) {
        if (player == null || wandStack == null || source == null || !ManaManager.containsManaRaw(player, source, amount)) {
            return false;
        }
        if (ManaManager.getMana(player, source) == -1) {
            return true;
        }
        int leftover = ManaManager.deductManaInner(player, wandStack, source, amount);
        if (leftover > 0) {
            LOGGER.warn("Leftover mana when trying to remove from player equipment: {}", (Object)leftover);
        }
        return leftover <= 0;
    }

    private static int deductManaInner(@NotNull Player player, @NotNull ItemStack wandStack, @NotNull Source source, int amount) {
        for (ItemStack stack : ManaManager.getPrioritizedEquipment(player, wandStack).reversed()) {
            Item item = stack.getItem();
            if (!(item instanceof IManaContainer)) continue;
            IManaContainer container = (IManaContainer)item;
            amount = container.deductMana(stack, source, amount);
        }
        return amount;
    }

    public static boolean containsMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable Source source, int amount, HolderLookup.Provider registries) {
        Item item;
        if (player != null && wandStack != null && source != null && (item = wandStack.getItem()) instanceof IWand) {
            IWand wand = (IWand)item;
            int totalMana = ManaManager.getMana(player, source);
            return totalMana == -1 || totalMana >= wand.getModifiedCost(wandStack, player, source, amount, registries);
        }
        return false;
    }

    public static boolean containsMana(@Nullable Player player, @Nullable ItemStack wandStack, @Nullable SourceList sources, HolderLookup.Provider registries) {
        if (sources == null || sources.isEmpty()) {
            return true;
        }
        if (player == null || wandStack == null) {
            return false;
        }
        for (Source source : sources.getSources()) {
            if (ManaManager.containsMana(player, wandStack, source, sources.getAmount(source), registries)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsManaRaw(@Nullable Player player, @Nullable Source source, int amount) {
        int total = ManaManager.getMana(player, source);
        return total == -1 || total >= amount;
    }

    @NotNull
    private static ItemStack getOffhandStack(@NotNull Player player, @NotNull ItemStack wandStack) {
        if (wandStack == player.getOffhandItem()) {
            return player.getMainHandItem();
        }
        return player.getOffhandItem();
    }

    public static void recordManaConsumptionSideEffects(@NotNull Player player, @NotNull Source source, int amount) {
        int realAmount = amount / 100;
        StatsManager.incrementValue(player, StatsPM.MANA_SPENT_TOTAL, realAmount);
        StatsManager.incrementValue(player, source.getManaSpentStat(), realAmount);
        AttunementManager.incrementAttunement(player, source, AttunementType.TEMPORARY, Mth.floor((double)Math.sqrt(realAmount)));
    }
}

