/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Rarity;

public interface IWandComponent {
    @Nonnull
    public String getTag();

    @Nonnull
    public Type getComponentType();

    @Nonnull
    public Rarity getRarity();

    @Nonnull
    default public String getNameTranslationKey() {
        return String.join((CharSequence)".", this.getComponentType().getSerializedName(), "primalmagick", this.getTag());
    }

    default public int getEnchantability() {
        switch (this.getRarity()) {
            case COMMON: {
                return 4;
            }
            case UNCOMMON: {
                return 8;
            }
            case RARE: {
                return 12;
            }
            case EPIC: {
                return 16;
            }
        }
        return 0;
    }

    public static enum Type implements StringRepresentable
    {
        CORE("wand_core"),
        CAP("wand_cap"),
        GEM("wand_gem");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

