/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.verdantartifice.primalmagick.common.crafting.IWandTransform;
import com.verdantartifice.primalmagick.common.crafting.WandTransforms;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IManaContainer;
import com.verdantartifice.primalmagick.common.wands.ISpellContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWand
extends ISpellContainer,
IManaContainer {
    public int getSiphonAmount(@Nullable ItemStack var1);

    public void clearPositionInUse(@NotNull ItemStack var1);

    public void setPositionInUse(@NotNull ItemStack var1, @NotNull BlockPos var2);

    @Nullable
    public BlockPos getPositionInUse(@NotNull ItemStack var1);

    public boolean isGlamoured(@Nullable ItemStack var1);

    default public InteractionResult onWandUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        if (context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        context.getPlayer().startUsingItem(context.getHand());
        BlockState bs = context.getLevel().getBlockState(context.getClickedPos());
        Block block = bs.getBlock();
        if (block instanceof IInteractWithWand) {
            IInteractWithWand wandable = (IInteractWithWand)block;
            return wandable.onWandRightClick(context.getItemInHand(), context.getLevel(), context.getPlayer(), context.getClickedPos(), context.getClickedFace());
        }
        BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
        if (tile != null && tile instanceof IInteractWithWand) {
            IInteractWithWand wandable = (IInteractWithWand)tile;
            return wandable.onWandRightClick(context.getItemInHand(), context.getLevel(), context.getPlayer(), context.getClickedPos(), context.getClickedFace());
        }
        for (IWandTransform transform : WandTransforms.getAll()) {
            if (transform.isValid(context.getLevel(), context.getPlayer(), context.getClickedPos())) {
                if (!context.getPlayer().mayUseItemAt(context.getClickedPos(), context.getClickedFace(), context.getItemInHand())) {
                    return InteractionResult.FAIL;
                }
                this.setPositionInUse(stack, context.getClickedPos());
                return InteractionResult.SUCCESS;
            }
            if (!transform.isSimilar(context.getLevel(), context.getPlayer(), context.getClickedPos())) continue;
            transform.showSimilarityWarning(context.getLevel(), context.getPlayer(), context.getClickedPos());
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

